/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.TopicName;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubLiteWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubLiteWriteSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_FORMATS = Sets.newHashSet((Object[])new String[]{"JSON", "AVRO"});

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubLiteWriteSchemaTransformConfiguration> configurationClass() {
        return PubsubLiteWriteSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(final @UnknownKeyFor @NonNull @Initialized PubsubLiteWriteSchemaTransformConfiguration configuration) {
        if (!SUPPORTED_FORMATS.contains(configuration.getFormat())) {
            throw new IllegalArgumentException("Format " + configuration.getFormat() + " is not supported. Supported formats are: " + String.join((CharSequence)", ", SUPPORTED_FORMATS));
        }
        return new SchemaTransform(){

            public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
                return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                        Schema inputSchema = input.get("input").getSchema();
                        SimpleFunction toBytesFn = configuration.getFormat().equals("JSON") ? JsonUtils.getRowToJsonBytesFunction((Schema)inputSchema) : AvroUtils.getRowToAvroBytesFunction((Schema)inputSchema);
                        ((PCollection)((PCollection)input.get("input").apply("Map Rows to PubSubMessages", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubSubMessage.class)).via(arg_0 -> 1.lambda$expand$68c7e41d$1((SerializableFunction)toBytesFn, arg_0)))).apply("Add UUIDs", PubsubLiteIO.addUuids())).apply("Write to PS Lite", PubsubLiteIO.write(PublisherOptions.newBuilder().setTopicPath(((TopicPath.Builder)((TopicPath.Builder)TopicPath.newBuilder().setProject(ProjectId.of((String)configuration.getProject()))).setName(TopicName.of((String)configuration.getTopicName())).setLocation(CloudRegionOrZone.parse((String)configuration.getLocation()))).build()).build()));
                        return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
                    }

                    private static /* synthetic */ PubSubMessage lambda$expand$68c7e41d$1(SerializableFunction toBytesFn, Row row) {
                        return PubSubMessage.newBuilder().setData(ByteString.copyFrom((byte[])Objects.requireNonNull((byte[])toBytesFn.apply((Object)row)))).build();
                    }
                };
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsublite_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class PubsubLiteWriteSchemaTransformConfiguration {
        public abstract @UnknownKeyFor @NonNull @Initialized String getProject();

        public abstract @UnknownKeyFor @NonNull @Initialized String getLocation();

        public abstract @UnknownKeyFor @NonNull @Initialized String getTopicName();

        public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProject(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopicName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized PubsubLiteWriteSchemaTransformConfiguration build();
        }
    }
}

