/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitterImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReaderImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReaderSettings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SubscriberAssembler {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized SubscriptionPath, @UnknownKeyFor @NonNull @Initialized TopicPath> KNOWN_PATHS = new ConcurrentHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized SubscriptionPath, @UnknownKeyFor @NonNull @Initialized SubscriberServiceClient> SUB_CLIENTS = new ConcurrentHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized SubscriptionPath, @UnknownKeyFor @NonNull @Initialized CursorServiceClient> CURSOR_CLIENTS = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized SubscriberOptions options;
    private final @UnknownKeyFor @NonNull @Initialized Partition partition;

    private static @UnknownKeyFor @NonNull @Initialized TopicPath lookupTopicPath(@UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPath) {
        TopicPath topicPath;
        block8: {
            AdminClient adminClient = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(subscriptionPath.location().extractRegion()).build());
            try {
                topicPath = TopicPath.parse((String)((Subscription)adminClient.getSubscription(subscriptionPath).get(1L, TimeUnit.MINUTES)).getTopic());
                if (adminClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw ExtractStatus.toCanonical((Throwable)t).underlying;
                }
            }
            adminClient.close();
        }
        return topicPath;
    }

    private @UnknownKeyFor @NonNull @Initialized TopicPath getTopicPath() {
        return KNOWN_PATHS.computeIfAbsent(this.options.subscriptionPath(), SubscriberAssembler::lookupTopicPath);
    }

    private @UnknownKeyFor @NonNull @Initialized SubscriberServiceClient newSubscriberServiceClient() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        try {
            SubscriberServiceSettings.Builder settingsBuilder = SubscriberServiceSettings.newBuilder();
            return SubscriberServiceClient.create((SubscriberServiceSettings)((SubscriberServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized SubscriberServiceClient getSubscriberServiceClient() {
        return SUB_CLIENTS.computeIfAbsent(this.options.subscriptionPath(), path -> this.newSubscriberServiceClient());
    }

    private @UnknownKeyFor @NonNull @Initialized CursorServiceClient newCursorClient() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        try {
            CursorServiceSettings.Builder settingsBuilder = CursorServiceSettings.newBuilder();
            return CursorServiceClient.create((CursorServiceSettings)((CursorServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized CursorServiceClient getCursorClient() {
        return CURSOR_CLIENTS.computeIfAbsent(this.options.subscriptionPath(), path -> this.newCursorClient());
    }

    SubscriberAssembler(@UnknownKeyFor @NonNull @Initialized SubscriberOptions options, @UnknownKeyFor @NonNull @Initialized Partition partition) {
        this.options = options;
        this.partition = partition;
    }

    @UnknownKeyFor @NonNull @Initialized SubscriberFactory getSubscriberFactory(@UnknownKeyFor @NonNull @Initialized Offset initialOffset) {
        SubscriberServiceClient client = this.getSubscriberServiceClient();
        return (SubscriberFactory & Serializable)consumer -> SubscriberBuilder.newBuilder().setMessageConsumer(consumer).setSubscriptionPath(this.options.subscriptionPath()).setPartition(this.partition).setRetryStreamRaces(false).setStreamFactory(responseStream -> {
            ApiCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((SubscriptionPath)this.options.subscriptionPath(), (Partition)this.partition));
            return client.subscribeCallable().splitCall(responseStream, context);
        }).setInitialLocation(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(initialOffset.value())).build()).build();
    }

    @UnknownKeyFor @NonNull @Initialized BlockingCommitter newCommitter() {
        CursorServiceClient client = this.getCursorClient();
        Committer committer = CommitterSettings.newBuilder().setPartition(this.partition).setSubscriptionPath(this.options.subscriptionPath()).setStreamFactory(responseStream -> {
            ApiCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((SubscriptionPath)this.options.subscriptionPath(), (Partition)this.partition));
            return client.streamingCommitCursorCallable().splitCall(responseStream, context);
        }).build().instantiate();
        committer.startAsync().awaitRunning();
        return new BlockingCommitterImpl(committer);
    }

    @UnknownKeyFor @NonNull @Initialized TopicBacklogReader getBacklogReader() {
        return TopicBacklogReaderSettings.newBuilder().setTopicPath(this.getTopicPath()).setPartition(this.partition).build().instantiate();
    }

    @UnknownKeyFor @NonNull @Initialized InitialOffsetReader getInitialOffsetReader() {
        return new InitialOffsetReaderImpl(CursorClient.create((CursorClientSettings)CursorClientSettings.newBuilder().setServiceClient(this.getCursorClient()).setRegion(this.options.subscriptionPath().location().extractRegion()).build()), this.options.subscriptionPath(), this.partition);
    }
}

