/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessorFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PerSubscriptionPartitionSdf
extends DoFn<SubscriptionPartition, SequencedMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(PerSubscriptionPartitionSdf.class);
    private final ManagedFactory<TopicBacklogReader> backlogReaderFactory;
    private final ManagedFactory<BlockingCommitter> committerFactory;
    private final SubscriptionPartitionProcessorFactory processorFactory;
    private final SerializableFunction<SubscriptionPartition, InitialOffsetReader> offsetReaderFactory;
    private final SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress> trackerFactory;

    PerSubscriptionPartitionSdf(ManagedFactory<TopicBacklogReader> backlogReaderFactory, ManagedFactory<BlockingCommitter> committerFactory, SerializableFunction<SubscriptionPartition, InitialOffsetReader> offsetReaderFactory, SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress> trackerFactory, SubscriptionPartitionProcessorFactory processorFactory) {
        this.backlogReaderFactory = backlogReaderFactory;
        this.committerFactory = committerFactory;
        this.processorFactory = processorFactory;
        this.offsetReaderFactory = offsetReaderFactory;
        this.trackerFactory = trackerFactory;
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        try (ManagedFactory<BlockingCommitter> c1 = this.committerFactory;){
            ManagedFactory<TopicBacklogReader> c2 = this.backlogReaderFactory;
            Throwable throwable = null;
            if (c2 != null) {
                if (throwable != null) {
                    try {
                        c2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    c2.close();
                }
            }
        }
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public Instant getInitialWatermarkState(@DoFn.Timestamp Instant elementTimestamp) {
        return elementTimestamp;
    }

    @DoFn.NewWatermarkEstimator
    public WatermarkEstimators.MonotonicallyIncreasing newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant state) {
        return new WatermarkEstimators.MonotonicallyIncreasing(state);
    }

    @DoFn.ProcessElement
    public DoFn.ProcessContinuation processElement(RestrictionTracker<OffsetByteRange, OffsetByteProgress> tracker, @DoFn.Element SubscriptionPartition subscriptionPartition, DoFn.OutputReceiver<SequencedMessage> receiver) throws Exception {
        LOG.debug("Starting process for {} at {}", (Object)subscriptionPartition, (Object)Instant.now());
        SubscriptionPartitionProcessor processor = this.processorFactory.newProcessor(subscriptionPartition, tracker, receiver);
        DoFn.ProcessContinuation result = processor.run();
        LOG.debug("Starting commit for {} at {}", (Object)subscriptionPartition, (Object)Instant.now());
        processor.lastClaimed().ifPresent(lastClaimed -> {
            try {
                this.committerFactory.create(subscriptionPartition).commitOffset(Offset.of((long)(lastClaimed.value() + 1L)));
            }
            catch (Exception e) {
                throw ExtractStatus.toCanonical((Throwable)e).underlying;
            }
        });
        LOG.debug("Finishing process for {} at {}", (Object)subscriptionPartition, (Object)Instant.now());
        return result;
    }

    @DoFn.GetInitialRestriction
    public OffsetByteRange getInitialRestriction(@DoFn.Element SubscriptionPartition subscriptionPartition) {
        Offset offset = ((InitialOffsetReader)this.offsetReaderFactory.apply((Object)subscriptionPartition)).read();
        return OffsetByteRange.of(new OffsetRange(offset.value(), Long.MAX_VALUE));
    }

    @DoFn.NewTracker
    public TrackerWithProgress newTracker(@DoFn.Element SubscriptionPartition subscriptionPartition, @DoFn.Restriction OffsetByteRange range) {
        return (TrackerWithProgress)((Object)this.trackerFactory.apply((Object)this.backlogReaderFactory.create(subscriptionPartition), (Object)range));
    }

    @DoFn.GetSize
    public double getSize(@DoFn.Element SubscriptionPartition subscriptionPartition, @DoFn.Restriction OffsetByteRange restriction) {
        if (restriction.getRange().getTo() != Long.MAX_VALUE) {
            return restriction.getByteCount();
        }
        return this.newTracker(subscriptionPartition, restriction).getProgress().getWorkRemaining();
    }
}

