/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Options;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataAdminDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;

public class DaoFactory
implements Serializable {
    private static final long serialVersionUID = 7929063669009832487L;
    private transient PartitionMetadataAdminDao partitionMetadataAdminDao;
    private transient PartitionMetadataDao partitionMetadataDaoInstance;
    private transient ChangeStreamDao changeStreamDaoInstance;
    private final SpannerConfig changeStreamSpannerConfig;
    private final SpannerConfig metadataSpannerConfig;
    private final String changeStreamName;
    private final String partitionMetadataTableName;
    private final Options.RpcPriority rpcPriority;
    private final String jobName;

    public DaoFactory(SpannerConfig changeStreamSpannerConfig, String changeStreamName, SpannerConfig metadataSpannerConfig, String partitionMetadataTableName, Options.RpcPriority rpcPriority, String jobName) {
        if (metadataSpannerConfig.getInstanceId() == null) {
            throw new IllegalArgumentException("Metadata instance can not be null");
        }
        if (metadataSpannerConfig.getDatabaseId() == null) {
            throw new IllegalArgumentException("Metadata database can not be null");
        }
        this.changeStreamSpannerConfig = changeStreamSpannerConfig;
        this.changeStreamName = changeStreamName;
        this.metadataSpannerConfig = metadataSpannerConfig;
        this.partitionMetadataTableName = partitionMetadataTableName;
        this.rpcPriority = rpcPriority;
        this.jobName = jobName;
    }

    public synchronized PartitionMetadataAdminDao getPartitionMetadataAdminDao() {
        if (this.partitionMetadataAdminDao == null) {
            DatabaseAdminClient databaseAdminClient = SpannerAccessor.getOrCreate(this.metadataSpannerConfig).getDatabaseAdminClient();
            this.partitionMetadataAdminDao = new PartitionMetadataAdminDao(databaseAdminClient, (String)this.metadataSpannerConfig.getInstanceId().get(), (String)this.metadataSpannerConfig.getDatabaseId().get(), this.partitionMetadataTableName);
        }
        return this.partitionMetadataAdminDao;
    }

    public synchronized PartitionMetadataDao getPartitionMetadataDao() {
        SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.metadataSpannerConfig);
        if (this.partitionMetadataDaoInstance == null) {
            this.partitionMetadataDaoInstance = new PartitionMetadataDao(this.partitionMetadataTableName, spannerAccessor.getDatabaseClient());
        }
        return this.partitionMetadataDaoInstance;
    }

    public synchronized ChangeStreamDao getChangeStreamDao() {
        SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.changeStreamSpannerConfig);
        if (this.changeStreamDaoInstance == null) {
            this.changeStreamDaoInstance = new ChangeStreamDao(this.changeStreamName, spannerAccessor.getDatabaseClient(), this.rpcPriority, this.jobName);
        }
        return this.changeStreamDaoInstance;
    }
}

