/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSchemaDestination
extends DoFn<Iterable<KV<TableDestination, WriteTables.Result>>, Iterable<KV<TableDestination, WriteTables.Result>>> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSchemaDestination.class);
    private final BigQueryServices bqServices;
    private final PCollectionView<String> loadJobIdPrefixView;
    private final ValueProvider<String> loadJobProjectId;
    @Nullable
    private transient BigQueryServices.DatasetService datasetService;
    private final int maxRetryJobs;
    @Nullable
    private final String kmsKey;
    private final String sourceFormat;
    private final boolean useAvroLogicalTypes;
    @Nullable
    private BigQueryServices.JobService jobService;
    private final boolean ignoreUnknownValues;
    private final Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
    private BigQueryIO.Write.WriteDisposition writeDisposition;
    private BigQueryIO.Write.CreateDisposition createDisposition;
    private DynamicDestinations dynamicDestinations;
    private List<PendingJobData> pendingJobs = Lists.newArrayList();

    public UpdateSchemaDestination(BigQueryServices bqServices, PCollectionView<String> loadJobIdPrefixView, @Nullable ValueProvider<String> loadJobProjectId, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, int maxRetryJobs, boolean ignoreUnknownValues, @Nullable String kmsKey, String sourceFormat, boolean useAvroLogicalTypes, Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions, DynamicDestinations dynamicDestinations) {
        this.loadJobProjectId = loadJobProjectId;
        this.loadJobIdPrefixView = loadJobIdPrefixView;
        this.bqServices = bqServices;
        this.maxRetryJobs = maxRetryJobs;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.kmsKey = kmsKey;
        this.sourceFormat = sourceFormat;
        this.useAvroLogicalTypes = useAvroLogicalTypes;
        this.schemaUpdateOptions = schemaUpdateOptions;
        this.createDisposition = createDisposition;
        this.writeDisposition = writeDisposition;
        this.dynamicDestinations = dynamicDestinations;
    }

    @DoFn.StartBundle
    public void startBundle(DoFn.StartBundleContext c) {
        this.pendingJobs.clear();
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element Iterable<KV<TableDestination, WriteTables.Result>> element, DoFn.ProcessContext context, BoundedWindow window) throws IOException {
        KV<TableDestination, WriteTables.Result> entry;
        Object destination = null;
        Iterator<KV<TableDestination, WriteTables.Result>> iterator = element.iterator();
        while (iterator.hasNext() && (destination = (entry = iterator.next()).getKey()) == null) {
        }
        if (destination != null) {
            TableDestination tableDestination = this.dynamicDestinations.getTable(destination);
            TableSchema schema = this.dynamicDestinations.getSchema(destination);
            TableReference tableReference = tableDestination.getTableReference();
            String jobIdPrefix = BigQueryResourceNaming.createJobIdWithDestination((String)context.sideInput(this.loadJobIdPrefixView), tableDestination, 1, context.pane().getIndex());
            jobIdPrefix = jobIdPrefix + "_schemaUpdateDestination";
            BigQueryHelpers.PendingJob updateSchemaDestinationJob = this.startZeroLoadJob(this.getJobService(context.getPipelineOptions().as(BigQueryOptions.class)), this.getDatasetService(context.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, tableReference, tableDestination.getTimePartitioning(), tableDestination.getClustering(), schema, this.writeDisposition, this.createDisposition, this.schemaUpdateOptions);
            if (updateSchemaDestinationJob != null) {
                this.pendingJobs.add(new PendingJobData(updateSchemaDestinationJob, tableDestination, window));
            }
            context.output(element);
        }
    }

    @DoFn.Teardown
    public void onTeardown() {
        try {
            if (this.datasetService != null) {
                this.datasetService.close();
                this.datasetService = null;
            }
            if (this.jobService != null) {
                this.jobService.close();
                this.jobService = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @DoFn.FinishBundle
    public void finishBundle(DoFn.FinishBundleContext context) throws Exception {
        BigQueryServices.DatasetService datasetService = this.getDatasetService(context.getPipelineOptions().as(BigQueryOptions.class));
        BigQueryHelpers.PendingJobManager jobManager = new BigQueryHelpers.PendingJobManager();
        for (PendingJobData pendingJobData : this.pendingJobs) {
            jobManager = jobManager.addPendingJob(pendingJobData.retryJob, (SerializableFunction<BigQueryHelpers.PendingJob, Exception>)(SerializableFunction & Serializable)j -> {
                try {
                    if (pendingJobData.tableDestination.getTableDescription() != null) {
                        TableReference ref = pendingJobData.tableDestination.getTableReference();
                        datasetService.patchTableDescription(ref.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(ref.getTableId())), pendingJobData.tableDestination.getTableDescription());
                    }
                    return null;
                }
                catch (IOException | InterruptedException e) {
                    return e;
                }
            });
        }
        jobManager.waitForDone();
    }

    private BigQueryHelpers.PendingJob startZeroLoadJob(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference tableReference, TimePartitioning timePartitioning, Clustering clustering, @Nullable TableSchema schema, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
        JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(tableReference).setSchema(schema).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat(this.sourceFormat).setIgnoreUnknownValues(Boolean.valueOf(this.ignoreUnknownValues)).setUseAvroLogicalTypes(Boolean.valueOf(this.useAvroLogicalTypes));
        if (schemaUpdateOptions != null) {
            List options = schemaUpdateOptions.stream().map(Enum::name).collect(Collectors.toList());
            loadConfig.setSchemaUpdateOptions(options);
        }
        if (!loadConfig.getWriteDisposition().equals(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.toString()) && !loadConfig.getWriteDisposition().equals(BigQueryIO.Write.WriteDisposition.WRITE_APPEND.toString())) {
            return null;
        }
        Table destinationTable = null;
        try {
            destinationTable = datasetService.getTable(tableReference);
            if (destinationTable == null) {
                return null;
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Failed to get table {} with {}", (Object)tableReference, (Object)e.toString());
            throw new RuntimeException(e);
        }
        if (destinationTable.getSchema().equals((Object)schema)) {
            return null;
        }
        if (timePartitioning != null) {
            loadConfig.setTimePartitioning(timePartitioning);
            if (clustering != null) {
                loadConfig.setClustering(clustering);
            }
        }
        if (this.kmsKey != null) {
            loadConfig.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(this.kmsKey));
        }
        String projectId = this.loadJobProjectId == null || this.loadJobProjectId.get() == null ? tableReference.getProjectId() : (String)this.loadJobProjectId.get();
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, tableReference.getProjectId(), tableReference.getDatasetId());
        BigQueryHelpers.PendingJob retryJob = new BigQueryHelpers.PendingJob((SerializableFunction<BigQueryHelpers.RetryJobId, Void>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            LOG.info("Loading zero rows using job {}, job id {} iteration {}", new Object[]{tableReference, jobRef, jobId.getRetryIndex()});
            try {
                jobService.startLoadJob(jobRef, loadConfig, (AbstractInputStreamContent)new ByteArrayContent("text/plain", new byte[0]));
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Load job {} failed with {}", (Object)jobRef, (Object)e.toString());
                throw new RuntimeException(e);
            }
            return null;
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.pollJob(jobRef, Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.getJob(jobRef);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.maxRetryJobs, jobIdPrefix);
        return retryJob;
    }

    private BigQueryServices.JobService getJobService(PipelineOptions pipelineOptions) throws IOException {
        if (this.jobService == null) {
            this.jobService = this.bqServices.getJobService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.jobService;
    }

    private BigQueryServices.DatasetService getDatasetService(PipelineOptions pipelineOptions) throws IOException {
        if (this.datasetService == null) {
            this.datasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
        }
        return this.datasetService;
    }

    private static class PendingJobData {
        final BigQueryHelpers.PendingJob retryJob;
        final TableDestination tableDestination;
        final BoundedWindow window;

        public PendingJobData(BigQueryHelpers.PendingJob retryJob, TableDestination tableDestination, BoundedWindow window) {
            this.retryJob = retryJob;
            this.tableDestination = tableDestination;
            this.window = window;
        }
    }
}

