/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StorageApiConvertMessages<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollectionTuple> {
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryServices bqServices;
    private final TupleTag<BigQueryStorageApiInsertError> failedWritesTag;
    private final TupleTag<KV<DestinationT, StorageApiWritePayload>> successfulWritesTag;
    private final Coder<BigQueryStorageApiInsertError> errorCoder;
    private final Coder<KV<DestinationT, StorageApiWritePayload>> successCoder;

    public StorageApiConvertMessages(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices, TupleTag<BigQueryStorageApiInsertError> failedWritesTag, TupleTag<KV<DestinationT, StorageApiWritePayload>> successfulWritesTag, Coder<BigQueryStorageApiInsertError> errorCoder, Coder<KV<DestinationT, StorageApiWritePayload>> successCoder) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
        this.failedWritesTag = failedWritesTag;
        this.successfulWritesTag = successfulWritesTag;
        this.errorCoder = errorCoder;
        this.successCoder = successCoder;
    }

    public PCollectionTuple expand(PCollection<KV<DestinationT, ElementT>> input) {
        String operationName = input.getName() + "/" + this.getName();
        PCollectionTuple result = (PCollectionTuple)input.apply("Convert to message", (PTransform)ParDo.of(new ConvertMessagesDoFn<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, operationName, this.failedWritesTag, this.successfulWritesTag)).withOutputTags(this.successfulWritesTag, TupleTagList.of(this.failedWritesTag)).withSideInputs(this.dynamicDestinations.getSideInputs()));
        result.get(this.successfulWritesTag).setCoder(this.successCoder);
        result.get(this.failedWritesTag).setCoder(this.errorCoder);
        return result;
    }

    public static class ConvertMessagesDoFn<DestinationT, ElementT>
    extends DoFn<KV<DestinationT, ElementT>, KV<DestinationT, StorageApiWritePayload>> {
        private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;
        private final BigQueryServices bqServices;
        private final TupleTag<BigQueryStorageApiInsertError> failedWritesTag;
        private final TupleTag<KV<DestinationT, StorageApiWritePayload>> successfulWritesTag;
        private transient @Nullable BigQueryServices.DatasetService datasetServiceInternal = null;

        ConvertMessagesDoFn(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices, String operationName, TupleTag<BigQueryStorageApiInsertError> failedWritesTag, TupleTag<KV<DestinationT, StorageApiWritePayload>> successfulWritesTag) {
            this.dynamicDestinations = dynamicDestinations;
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
            this.bqServices = bqServices;
            this.failedWritesTag = failedWritesTag;
            this.successfulWritesTag = successfulWritesTag;
        }

        private BigQueryServices.DatasetService getDatasetService(PipelineOptions pipelineOptions) throws IOException {
            if (this.datasetServiceInternal == null) {
                this.datasetServiceInternal = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return this.datasetServiceInternal;
        }

        @DoFn.Teardown
        public void onTeardown() {
            try {
                if (this.datasetServiceInternal != null) {
                    this.datasetServiceInternal.close();
                    this.datasetServiceInternal = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, PipelineOptions pipelineOptions, @DoFn.Element KV<DestinationT, ElementT> element, DoFn.MultiOutputReceiver o) throws Exception {
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter = this.messageConverters.get(element.getKey(), this.dynamicDestinations, this.getDatasetService(pipelineOptions));
            try {
                StorageApiWritePayload payload = messageConverter.toMessage(element.getValue());
                o.get(this.successfulWritesTag).output((Object)KV.of((Object)element.getKey(), (Object)payload));
            }
            catch (TableRowToStorageApiProto.SchemaConversionException e) {
                TableRow tableRow = messageConverter.toTableRow(element.getValue());
                o.get(this.failedWritesTag).output((Object)new BigQueryStorageApiInsertError(tableRow, e.toString()));
            }
        }
    }
}

