/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.proto.CommitCursorRequest;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReaderImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReaderSettings;

class SubscriberAssembler {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private final SubscriberOptions options;
    private final Partition partition;

    SubscriberAssembler(SubscriberOptions options, Partition partition) {
        this.options = options;
        this.partition = partition;
    }

    private SubscriberServiceClient newSubscriberServiceClient() throws ApiException {
        try {
            SubscriberServiceSettings.Builder settingsBuilder = SubscriberServiceSettings.newBuilder();
            settingsBuilder = (SubscriberServiceSettings.Builder)ServiceClients.addDefaultMetadata((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((SubscriptionPath)this.options.subscriptionPath(), (Partition)this.partition), (ClientSettings.Builder)settingsBuilder);
            return SubscriberServiceClient.create((SubscriberServiceSettings)((SubscriberServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    SubscriberFactory getSubscriberFactory(Offset initialOffset) {
        return (SubscriberFactory & Serializable)consumer -> SubscriberBuilder.newBuilder().setMessageConsumer(consumer).setSubscriptionPath(this.options.subscriptionPath()).setPartition(this.partition).setServiceClient(this.newSubscriberServiceClient()).setInitialLocation(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(initialOffset.value())).build()).build();
    }

    private CursorServiceClient newCursorServiceClient() throws ApiException {
        try {
            return CursorServiceClient.create((CursorServiceSettings)((CursorServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)CursorServiceSettings.newBuilder())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    BlockingCommitter getCommitter() {
        return offset -> this.newCursorServiceClient().commitCursor(CommitCursorRequest.newBuilder().setSubscription(this.options.subscriptionPath().toString()).setPartition(this.partition.value()).setCursor(Cursor.newBuilder().setOffset(offset.value())).build());
    }

    TopicBacklogReader getBacklogReader() {
        return TopicBacklogReaderSettings.newBuilder().setTopicPathFromSubscriptionPath(this.options.subscriptionPath()).setPartition(this.partition).build().instantiate();
    }

    InitialOffsetReader getInitialOffsetReader() {
        return new InitialOffsetReaderImpl(CursorClient.create((CursorClientSettings)CursorClientSettings.newBuilder().setRegion(this.options.subscriptionPath().location().extractRegion()).build()), this.options.subscriptionPath(), this.partition);
    }
}

