/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.healthcare.v1.model.DeidentifyConfig;
import com.google.api.services.healthcare.v1.model.HttpBody;
import com.google.api.services.healthcare.v1.model.Operation;
import com.google.api.services.healthcare.v1.model.Status;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.healthcare.AutoValue_FhirIO_Write;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameter;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.JsonArrayCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirIO {
    private static final String BASE_METRIC_PREFIX = "fhirio/";
    private static final String LRO_COUNTER_KEY = "counter";
    private static final String LRO_SUCCESS_KEY = "success";
    private static final String LRO_FAILURE_KEY = "failure";
    private static final Logger LOG = LoggerFactory.getLogger(FhirIO.class);

    public static Read readResources() {
        return new Read();
    }

    public static Search<String> searchResources(String fhirStore) {
        return new Search<String>(fhirStore);
    }

    public static Search<?> searchResourcesWithGenericParameters(String fhirStore) {
        return new Search(fhirStore);
    }

    public static Import importResources(String fhirStore, String tempDir, String deadLetterDir, @Nullable Import.ContentStructure contentStructure) {
        return new Import(fhirStore, tempDir, deadLetterDir, contentStructure);
    }

    public static Import importResources(ValueProvider<String> fhirStore, ValueProvider<String> tempDir, ValueProvider<String> deadLetterDir, @Nullable Import.ContentStructure contentStructure) {
        return new Import(fhirStore, tempDir, deadLetterDir, contentStructure);
    }

    public static Export exportResourcesToGcs(String fhirStore, String exportGcsUriPrefix) {
        return new Export((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)exportGcsUriPrefix));
    }

    public static Export exportResourcesToGcs(ValueProvider<String> fhirStore, ValueProvider<String> exportGcsUriPrefix) {
        return new Export(fhirStore, exportGcsUriPrefix);
    }

    public static Deidentify deidentify(String sourceFhirStore, String destinationFhirStore, DeidentifyConfig deidConfig) {
        return new Deidentify((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)sourceFhirStore), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)destinationFhirStore), (ValueProvider<DeidentifyConfig>)ValueProvider.StaticValueProvider.of((Object)deidConfig));
    }

    public static Deidentify deidentify(ValueProvider<String> sourceFhirStore, ValueProvider<String> destinationFhirStore, ValueProvider<DeidentifyConfig> deidConfig) {
        return new Deidentify(sourceFhirStore, destinationFhirStore, deidConfig);
    }

    private static void incrementLroCounters(Operation operation, Counter operationSuccessCounter, Counter operationFailureCounter, Counter resourceSuccessCounter, Counter resourceFailureCounter) {
        Status error = operation.getError();
        if (error == null) {
            operationSuccessCounter.inc();
            LOG.debug(String.format("Operation %s finished successfully.", operation.getName()));
        } else {
            operationFailureCounter.inc();
            LOG.error(String.format("Operation %s failed with error code: %d and message: %s.", operation.getName(), error.getCode(), error.getMessage()));
        }
        Map opMetadata = operation.getMetadata();
        if (opMetadata.containsKey(LRO_COUNTER_KEY)) {
            try {
                Map counters = (Map)opMetadata.get(LRO_COUNTER_KEY);
                if (counters.containsKey(LRO_SUCCESS_KEY)) {
                    resourceSuccessCounter.inc(Long.parseLong((String)counters.get(LRO_SUCCESS_KEY)));
                }
                if (counters.containsKey(LRO_FAILURE_KEY)) {
                    Long numFailures = Long.parseLong((String)counters.get(LRO_FAILURE_KEY));
                    resourceFailureCounter.inc(numFailures.longValue());
                    if (numFailures > 0L) {
                        LOG.error("Operation " + operation.getName() + " had " + numFailures + " failures.");
                    }
                }
            }
            catch (Exception e) {
                LOG.error("failed to increment LRO counters, error message: " + e.getMessage());
            }
        }
    }

    public static class Search<T>
    extends PTransform<PCollection<FhirSearchParameter<T>>, Result> {
        private final ValueProvider<String> fhirStore;
        public static final TupleTag<KV<String, JsonArray>> OUT = new TupleTag<KV<String, JsonArray>>(){};
        public static final TupleTag<HealthcareIOError<String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

        Search(ValueProvider<String> fhirStore) {
            this.fhirStore = fhirStore;
        }

        Search(String fhirStore) {
            this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
        }

        public Result expand(PCollection<FhirSearchParameter<T>> input) {
            return (Result)input.apply("Fetch Fhir messages", (PTransform)new SearchResourcesJsonString(this.fhirStore));
        }

        class SearchResourcesJsonString
        extends PTransform<PCollection<FhirSearchParameter<T>>, Result> {
            private final ValueProvider<String> fhirStore;

            public SearchResourcesJsonString(ValueProvider<String> fhirStore) {
                this.fhirStore = fhirStore;
            }

            public Result expand(PCollection<FhirSearchParameter<T>> resourceIds) {
                return new Result((PCollectionTuple)resourceIds.apply((PTransform)ParDo.of((DoFn)new SearchResourcesFn(this.fhirStore)).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            class SearchResourcesFn
            extends DoFn<FhirSearchParameter<T>, KV<String, JsonArray>> {
                private final Counter searchResourceErrors = Metrics.counter(SearchResourcesFn.class, (String)"fhirio/search_resource_error_count");
                private final Counter searchResourceSuccess = Metrics.counter(SearchResourcesFn.class, (String)"fhirio/search_resource_success_count");
                private final Distribution searchResourceLatencyMs = Metrics.distribution(SearchResourcesFn.class, (String)"fhirio/search_resource_latency_ms");
                private final Logger log = LoggerFactory.getLogger(SearchResourcesFn.class);
                private HealthcareApiClient client;
                private final ValueProvider<String> fhirStore;

                SearchResourcesFn(ValueProvider<String> fhirStore) {
                    this.fhirStore = fhirStore;
                }

                @DoFn.Setup
                public void instantiateHealthcareClient() throws IOException {
                    this.client = new HttpHealthcareApiClient();
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    FhirSearchParameter fhirSearchParameters = (FhirSearchParameter)context.element();
                    try {
                        context.output((Object)KV.of((Object)fhirSearchParameters.getKey(), (Object)this.searchResources(this.client, this.fhirStore.toString(), fhirSearchParameters.getResourceType(), fhirSearchParameters.getQueries())));
                    }
                    catch (IllegalArgumentException | NoSuchElementException e) {
                        this.searchResourceErrors.inc();
                        this.log.warn(String.format("Error search FHIR messages writing to Dead Letter Queue. Cause: %s Stack Trace: %s", e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                        context.output(DEAD_LETTER, HealthcareIOError.of(this.fhirStore.toString(), e));
                    }
                }

                private JsonArray searchResources(HealthcareApiClient client, String fhirStore, String resourceType, @Nullable Map<String, T> parameters) throws NoSuchElementException {
                    long start = Instant.now().toEpochMilli();
                    HashMap<String, Object> parameterObjects = new HashMap<String, Object>();
                    if (parameters != null) {
                        parameters.forEach(parameterObjects::put);
                    }
                    HttpHealthcareApiClient.FhirResourcePages.FhirResourcePagesIterator iter = new HttpHealthcareApiClient.FhirResourcePages.FhirResourcePagesIterator(client, fhirStore, resourceType, parameterObjects);
                    JsonArray result = new JsonArray();
                    while (iter.hasNext()) {
                        result.addAll(iter.next());
                    }
                    this.searchResourceLatencyMs.update(Instant.now().toEpochMilli() - start);
                    this.searchResourceSuccess.inc();
                    return result;
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private final PCollection<KV<String, JsonArray>> keyedResources;
            private final PCollection<JsonArray> resources;
            private final PCollection<HealthcareIOError<String>> failedSearches;
            PCollectionTuple pct;

            static Result of(PCollectionTuple pct) throws IllegalArgumentException {
                if (pct.has(OUT) && pct.has(DEAD_LETTER)) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the FhirIO.Search.OUT and FhirIO.Search.DEAD_LETTER tuple tags");
            }

            private Result(PCollectionTuple pct) {
                this.pct = pct;
                this.keyedResources = pct.get(OUT).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)JsonArrayCoder.of()));
                this.resources = ((PCollection)this.keyedResources.apply("Extract Values", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(JsonArray.class)).via(KV::getValue))).setCoder((Coder)JsonArrayCoder.of());
                this.failedSearches = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            }

            public PCollection<HealthcareIOError<String>> getFailedSearches() {
                return this.failedSearches;
            }

            public PCollection<JsonArray> getResources() {
                return this.resources;
            }

            public PCollection<KV<String, JsonArray>> getKeyedResources() {
                return this.keyedResources;
            }

            public Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public Map<TupleTag<?>, PValue> expand() {
                return ImmutableMap.of(OUT, this.keyedResources);
            }

            public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
            }
        }
    }

    public static class Deidentify
    extends PTransform<PBegin, PCollection<String>> {
        private final ValueProvider<String> sourceFhirStore;
        private final ValueProvider<String> destinationFhirStore;
        private final ValueProvider<DeidentifyConfig> deidConfig;

        public Deidentify(ValueProvider<String> sourceFhirStore, ValueProvider<String> destinationFhirStore, ValueProvider<DeidentifyConfig> deidConfig) {
            this.sourceFhirStore = sourceFhirStore;
            this.destinationFhirStore = destinationFhirStore;
            this.deidConfig = deidConfig;
        }

        public PCollection<String> expand(PBegin input) {
            return (PCollection)((PCollection)input.getPipeline().apply((PTransform)Create.ofProvider(this.sourceFhirStore, (Coder)StringUtf8Coder.of()))).apply("ScheduleDeidentifyFhirStoreOperations", (PTransform)ParDo.of((DoFn)new DeidentifyFn(this.destinationFhirStore, this.deidConfig)));
        }

        public static class DeidentifyFn
        extends DoFn<String, String> {
            private static final Counter DEIDENTIFY_OPERATION_SUCCESS = Metrics.counter(DeidentifyFn.class, (String)"fhirio/deidentify_operation_success_count");
            private static final Counter DEIDENTIFY_OPERATION_ERRORS = Metrics.counter(DeidentifyFn.class, (String)"fhirio/deidentify_operation_failure_count");
            private static final Counter RESOURCES_DEIDENTIFIED_SUCCESS = Metrics.counter(DeidentifyFn.class, (String)"fhirio/resources_deidentified_success_count");
            private static final Counter RESOURCES_DEIDENTIFIED_ERRORS = Metrics.counter(DeidentifyFn.class, (String)"fhirio/resources_deidentified_failure_count");
            private HealthcareApiClient client;
            private final ValueProvider<String> destinationFhirStore;
            private static final Gson gson = new Gson();
            private final String deidConfigJson;

            public DeidentifyFn(ValueProvider<String> destinationFhirStore, ValueProvider<DeidentifyConfig> deidConfig) {
                this.destinationFhirStore = destinationFhirStore;
                this.deidConfigJson = gson.toJson(deidConfig.get());
            }

            @DoFn.Setup
            public void initClient() throws IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void deidentify(DoFn.ProcessContext context) throws IOException, InterruptedException {
                String sourceFhirStore = (String)context.element();
                String destinationFhirStore = (String)this.destinationFhirStore.get();
                DeidentifyConfig deidConfig = (DeidentifyConfig)gson.fromJson(this.deidConfigJson, DeidentifyConfig.class);
                Operation operation = this.client.deidentifyFhirStore(sourceFhirStore, destinationFhirStore, deidConfig);
                operation = this.client.pollOperation(operation, 15000L);
                FhirIO.incrementLroCounters(operation, DeidentifyFn.DEIDENTIFY_OPERATION_SUCCESS, DeidentifyFn.DEIDENTIFY_OPERATION_ERRORS, DeidentifyFn.RESOURCES_DEIDENTIFIED_SUCCESS, DeidentifyFn.RESOURCES_DEIDENTIFIED_ERRORS);
                if (operation.getError() != null) {
                    throw new IOException(String.format("DeidentifyFhirStore operation (%s) failed.", operation.getName()));
                }
                context.output((Object)destinationFhirStore);
            }
        }
    }

    public static class Export
    extends PTransform<PBegin, PCollection<String>> {
        private final ValueProvider<String> fhirStore;
        private final ValueProvider<String> exportGcsUriPrefix;

        public Export(ValueProvider<String> fhirStore, ValueProvider<String> exportGcsUriPrefix) {
            this.fhirStore = fhirStore;
            this.exportGcsUriPrefix = exportGcsUriPrefix;
        }

        public PCollection<String> expand(PBegin input) {
            return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Create.ofProvider(this.fhirStore, (Coder)StringUtf8Coder.of()))).apply("ScheduleExportOperations", (PTransform)ParDo.of((DoFn)new ExportResourcesToGcsFn(this.exportGcsUriPrefix)))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply("ReadResourcesFromFiles", (PTransform)TextIO.readFiles());
        }

        public static class ExportResourcesToGcsFn
        extends DoFn<String, String> {
            private static final Counter EXPORT_OPERATION_SUCCESS = Metrics.counter(ExportResourcesToGcsFn.class, (String)"fhirio/export_operation_success_count");
            private static final Counter EXPORT_OPERATION_ERRORS = Metrics.counter(ExportResourcesToGcsFn.class, (String)"fhirio/export_operation_failure_count");
            private static final Counter RESOURCES_EXPORTED_SUCCESS = Metrics.counter(ExportResourcesToGcsFn.class, (String)"fhirio/resources_exported_success_count");
            private static final Counter RESOURCES_EXPORTED_ERRORS = Metrics.counter(ExportResourcesToGcsFn.class, (String)"fhirio/resources_exported_failure_count");
            private HealthcareApiClient client;
            private final ValueProvider<String> exportGcsUriPrefix;

            public ExportResourcesToGcsFn(ValueProvider<String> exportGcsUriPrefix) {
                this.exportGcsUriPrefix = exportGcsUriPrefix;
            }

            @DoFn.Setup
            public void initClient() throws IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void exportResourcesToGcs(DoFn.ProcessContext context) throws IOException, InterruptedException {
                String fhirStore = (String)context.element();
                String gcsPrefix = (String)this.exportGcsUriPrefix.get();
                Operation operation = this.client.exportFhirResourceToGcs(fhirStore, gcsPrefix);
                operation = this.client.pollOperation(operation, 15000L);
                FhirIO.incrementLroCounters(operation, ExportResourcesToGcsFn.EXPORT_OPERATION_SUCCESS, ExportResourcesToGcsFn.EXPORT_OPERATION_ERRORS, ExportResourcesToGcsFn.RESOURCES_EXPORTED_SUCCESS, ExportResourcesToGcsFn.RESOURCES_EXPORTED_ERRORS);
                if (operation.getError() != null) {
                    throw new RuntimeException(String.format("Export operation (%s) failed.", operation.getName()));
                }
                context.output((Object)String.format("%s/*", gcsPrefix.replaceAll("/+$", "")));
            }
        }
    }

    public static class ExecuteBundles
    extends PTransform<PCollection<String>, Write.Result> {
        private final ValueProvider<String> fhirStore;

        ExecuteBundles(ValueProvider<String> fhirStore) {
            this.fhirStore = fhirStore;
        }

        ExecuteBundles(String fhirStore) {
            this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
        }

        public Write.Result expand(PCollection<String> input) {
            PCollectionTuple bodies = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new ExecuteBundlesFn(this.fhirStore)).withOutputTags(Write.SUCCESSFUL_BODY, TupleTagList.of(Write.FAILED_BODY)));
            bodies.get(Write.SUCCESSFUL_BODY).setCoder((Coder)StringUtf8Coder.of());
            bodies.get(Write.FAILED_BODY).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            return Write.Result.in(input.getPipeline(), bodies);
        }

        static class ExecuteBundlesFn
        extends DoFn<String, String> {
            private static final Counter EXECUTE_BUNDLE_ERRORS = Metrics.counter(ExecuteBundlesFn.class, (String)"fhirio/execute_bundle_error_count");
            private static final Counter EXECUTE_BUNDLE_SUCCESS = Metrics.counter(ExecuteBundlesFn.class, (String)"fhirio/execute_bundle_success_count");
            private static final Distribution EXECUTE_BUNDLE_LATENCY_MS = Metrics.distribution(ExecuteBundlesFn.class, (String)"fhirio/execute_bundle_latency_ms");
            private transient HealthcareApiClient client;
            private final ObjectMapper mapper = new ObjectMapper();
            private final ValueProvider<String> fhirStore;

            ExecuteBundlesFn(ValueProvider<String> fhirStore) {
                this.fhirStore = fhirStore;
            }

            @DoFn.Setup
            public void initClient() throws IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void executeBundles(DoFn.ProcessContext context) {
                String body = (String)context.element();
                try {
                    long startTime = Instant.now().toEpochMilli();
                    this.mapper.readTree(body);
                    this.client.executeFhirBundle((String)this.fhirStore.get(), body);
                    EXECUTE_BUNDLE_LATENCY_MS.update(Instant.now().toEpochMilli() - startTime);
                    EXECUTE_BUNDLE_SUCCESS.inc();
                    context.output(Write.SUCCESSFUL_BODY, (Object)body);
                }
                catch (IOException | HttpHealthcareApiClient.HealthcareHttpException e) {
                    EXECUTE_BUNDLE_ERRORS.inc();
                    context.output(Write.FAILED_BODY, HealthcareIOError.of(body, e));
                }
            }
        }
    }

    public static class Import
    extends Write {
        private static final Logger LOG = LoggerFactory.getLogger(Import.class);
        private final ValueProvider<String> fhirStore;
        private final ValueProvider<String> deadLetterGcsPath;
        private final ValueProvider<String> tempGcsPath;
        private final ContentStructure contentStructure;

        Import(ValueProvider<String> fhirStore, ValueProvider<String> tempGcsPath, ValueProvider<String> deadLetterGcsPath, @Nullable ContentStructure contentStructure) {
            this.fhirStore = fhirStore;
            this.tempGcsPath = tempGcsPath;
            this.deadLetterGcsPath = deadLetterGcsPath;
            this.contentStructure = contentStructure == null ? ContentStructure.CONTENT_STRUCTURE_UNSPECIFIED : contentStructure;
        }

        Import(ValueProvider<String> fhirStore, ValueProvider<String> deadLetterGcsPath, @Nullable ContentStructure contentStructure) {
            this(fhirStore, null, deadLetterGcsPath, contentStructure);
        }

        Import(String fhirStore, String tempGcsPath, String deadLetterGcsPath, @Nullable ContentStructure contentStructure) {
            this.fhirStore = ValueProvider.StaticValueProvider.of((Object)fhirStore);
            this.tempGcsPath = ValueProvider.StaticValueProvider.of((Object)tempGcsPath);
            this.deadLetterGcsPath = ValueProvider.StaticValueProvider.of((Object)deadLetterGcsPath);
            this.contentStructure = contentStructure == null ? ContentStructure.CONTENT_STRUCTURE_UNSPECIFIED : contentStructure;
        }

        @Override
        ValueProvider<String> getFhirStore() {
            return this.fhirStore;
        }

        @Override
        Write.WriteMethod getWriteMethod() {
            return Write.WriteMethod.IMPORT;
        }

        @Override
        Optional<ContentStructure> getContentStructure() {
            return Optional.of(this.contentStructure);
        }

        @Override
        Optional<ValueProvider<String>> getImportGcsTempPath() {
            return Optional.of(this.tempGcsPath);
        }

        @Override
        Optional<ValueProvider<String>> getImportGcsDeadLetterPath() {
            return Optional.of(this.deadLetterGcsPath);
        }

        @Override
        public Write.Result expand(PCollection<String> input) {
            Preconditions.checkState((input.isBounded() == PCollection.IsBounded.BOUNDED ? 1 : 0) != 0, (Object)"FhirIO.Import should only be used on bounded PCollections as it isintended for batch use only.");
            ValueProvider<String> tempPath = this.getImportGcsTempPath().orElse((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input.getPipeline().getOptions().getTempLocation()));
            PCollectionTuple writeTmpFileResults = (PCollectionTuple)input.apply("Write input to GCS", (PTransform)ParDo.of((DoFn)new WriteBatchToFilesFn(this.tempGcsPath)).withOutputTags(Write.TEMP_FILES, TupleTagList.of(Write.FAILED_BODY)));
            PCollection failedBodies = writeTmpFileResults.get(Write.FAILED_BODY).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            PCollection failedFiles = ((PCollection)writeTmpFileResults.get(Write.TEMP_FILES).apply("Import Batches", (PTransform)ParDo.of((DoFn)new ImportFn(this.fhirStore, tempPath, this.deadLetterGcsPath, this.contentStructure)))).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.getPipeline().apply("Instantiate Temp Path", (PTransform)Create.ofProvider(tempPath, (Coder)StringUtf8Coder.of()))).apply("Resolve SubDirs", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)path -> path.endsWith("/") ? path + "*" : path + "/*"))).apply("Wait On File Writing", (PTransform)Wait.on((PCollection[])new PCollection[]{failedBodies}))).apply("Wait On FHIR Importing", (PTransform)Wait.on((PCollection[])new PCollection[]{failedFiles}))).apply("Match tempGcsPath", (PTransform)FileIO.matchAll().withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW))).apply("Delete tempGcsPath", (PTransform)ParDo.of((DoFn)new DoFn<MatchResult.Metadata, Void>(){

                @DoFn.ProcessElement
                public void delete(@DoFn.Element MatchResult.Metadata path, DoFn.ProcessContext context) {
                    try {
                        FileSystems.delete(Collections.singleton(path.resourceId()), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                    }
                    catch (IOException e) {
                        LOG.error("error cleaning up tempGcsDir: %s", (Throwable)e);
                    }
                }
            }))).setCoder((Coder)VoidCoder.of());
            return Write.Result.in(input.getPipeline(), (PCollection<HealthcareIOError<String>>)failedBodies, (PCollection<HealthcareIOError<String>>)failedFiles);
        }

        public static enum ContentStructure {
            CONTENT_STRUCTURE_UNSPECIFIED,
            BUNDLE,
            RESOURCE;

        }

        static class ImportFn
        extends DoFn<ResourceId, HealthcareIOError<String>> {
            private static final Counter IMPORT_OPERATION_SUCCESS = Metrics.counter(ImportFn.class, (String)"fhirio/import_operation_success_count");
            private static final Counter IMPORT_OPERATION_ERRORS = Metrics.counter(ImportFn.class, (String)"fhirio/import_operation_failure_count");
            private static final Counter RESOURCES_IMPORTED_SUCCESS = Metrics.counter(ImportFn.class, (String)"fhirio/resources_imported_success_count");
            private static final Counter RESOURCES_IMPORTED_ERRORS = Metrics.counter(ImportFn.class, (String)"fhirio/resources_imported_failure_count");
            private static final Logger LOG = LoggerFactory.getLogger(ImportFn.class);
            private final ValueProvider<String> fhirStore;
            private final ValueProvider<String> tempGcsPath;
            private final ValueProvider<String> deadLetterGcsPath;
            private final ContentStructure contentStructure;
            private ResourceId tempDir;
            private HealthcareApiClient client;
            private BoundedWindow window;
            private List<ResourceId> files;
            private List<ResourceId> tempDestinations;
            private List<ResourceId> deadLetterDestinations;

            ImportFn(ValueProvider<String> fhirStore, ValueProvider<String> tempGcsPath, ValueProvider<String> deadLetterGcsPath, @Nullable ContentStructure contentStructure) {
                this.fhirStore = fhirStore;
                this.tempGcsPath = tempGcsPath;
                this.deadLetterGcsPath = deadLetterGcsPath;
                this.contentStructure = contentStructure == null ? ContentStructure.CONTENT_STRUCTURE_UNSPECIFIED : contentStructure;
            }

            @DoFn.Setup
            public void init() throws IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.StartBundle
            public void initBatch() {
                this.tempDir = FileSystems.matchNewResource((String)((String)this.tempGcsPath.get()), (boolean)true).resolve(String.format("tmp-%s", UUID.randomUUID()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
                this.files = new ArrayList<ResourceId>();
                this.tempDestinations = new ArrayList<ResourceId>();
                this.deadLetterDestinations = new ArrayList<ResourceId>();
            }

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
                this.window = window;
                ResourceId file = (ResourceId)context.element();
                assert (file != null);
                this.files.add(file);
                this.tempDestinations.add(this.tempDir.resolve(file.getFilename(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
                this.deadLetterDestinations.add(FileSystems.matchNewResource((String)((String)this.deadLetterGcsPath.get()), (boolean)true).resolve(file.getFilename(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
            }

            @DoFn.FinishBundle
            public void importBatch(DoFn.FinishBundleContext context) throws IOException {
                FileSystems.rename((List)ImmutableList.copyOf(this.files), this.tempDestinations, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                boolean hasMissingFile = FileSystems.matchResources(this.tempDestinations).stream().anyMatch(r -> r.status() != MatchResult.Status.OK);
                if (hasMissingFile) {
                    throw new IllegalStateException("Not all temporary files are present for importing.");
                }
                ResourceId importUri = this.tempDir.resolve("*", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
                try {
                    assert (this.contentStructure != null);
                    Operation operation = this.client.importFhirResource((String)this.fhirStore.get(), importUri.toString(), this.contentStructure.name());
                    operation = this.client.pollOperation(operation, 15000L);
                    FhirIO.incrementLroCounters(operation, ImportFn.IMPORT_OPERATION_SUCCESS, ImportFn.IMPORT_OPERATION_ERRORS, ImportFn.RESOURCES_IMPORTED_SUCCESS, ImportFn.RESOURCES_IMPORTED_ERRORS);
                    FileSystems.delete(this.tempDestinations, (MoveOptions[])new MoveOptions[0]);
                }
                catch (IOException | InterruptedException e) {
                    ResourceId deadLetterResourceId = FileSystems.matchNewResource((String)((String)this.deadLetterGcsPath.get()), (boolean)true);
                    LOG.warn(String.format("Failed to import %s with error: %s. Moving to deadletter path %s", importUri, e.getMessage(), deadLetterResourceId.toString()));
                    IMPORT_OPERATION_ERRORS.inc();
                    FileSystems.rename(this.tempDestinations, this.deadLetterDestinations, (MoveOptions[])new MoveOptions[0]);
                    context.output(HealthcareIOError.of(importUri.toString(), e), this.window.maxTimestamp(), this.window);
                }
            }
        }

        static class WriteBatchToFilesFn
        extends DoFn<String, ResourceId> {
            private final ValueProvider<String> tempGcsPath;
            private ObjectMapper mapper;
            private ResourceId resourceId;
            private WritableByteChannel ndJsonChannel;
            private BoundedWindow window;

            WriteBatchToFilesFn(ValueProvider<String> tempGcsPath) {
                this.tempGcsPath = tempGcsPath;
            }

            @DoFn.Setup
            public void init() throws IOException {
                this.mapper = new ObjectMapper();
            }

            @DoFn.StartBundle
            public void initFile() throws IOException {
                String filename = String.format("fhirImportBatch-%s.ndjson", UUID.randomUUID());
                ResourceId tempDir = FileSystems.matchNewResource((String)((String)this.tempGcsPath.get()), (boolean)true);
                this.resourceId = tempDir.resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
                this.ndJsonChannel = FileSystems.create((ResourceId)this.resourceId, (String)"application/ld+json");
            }

            @DoFn.ProcessElement
            public void addToFile(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
                this.window = window;
                String httpBody = (String)context.element();
                try {
                    Object data = this.mapper.readValue(httpBody, Object.class);
                    String ndJson = this.mapper.writeValueAsString(data) + "\n";
                    this.ndJsonChannel.write(ByteBuffer.wrap(ndJson.getBytes(StandardCharsets.UTF_8)));
                }
                catch (JsonProcessingException e) {
                    String resource = String.format("Failed to parse payload: %s as json at: %s : %s.Dropping message from batch import.", httpBody, e.getLocation().getCharOffset(), e.getMessage());
                    LOG.warn(resource);
                    context.output(Write.FAILED_BODY, HealthcareIOError.of(httpBody, new IOException(resource)));
                }
            }

            @DoFn.FinishBundle
            public void closeFile(DoFn.FinishBundleContext context) throws IOException {
                this.ndJsonChannel.close();
                context.output((Object)this.resourceId, this.window.maxTimestamp(), this.window);
            }
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<String>, Result> {
        public static final TupleTag<String> SUCCESSFUL_BODY = new TupleTag<String>(){};
        public static final TupleTag<HealthcareIOError<String>> FAILED_BODY = new TupleTag<HealthcareIOError<String>>(){};
        public static final TupleTag<HealthcareIOError<String>> FAILED_FILES = new TupleTag<HealthcareIOError<String>>(){};
        public static final TupleTag<ResourceId> TEMP_FILES = new TupleTag<ResourceId>(){};
        private static final Logger LOG = LoggerFactory.getLogger(Write.class);

        abstract ValueProvider<String> getFhirStore();

        abstract WriteMethod getWriteMethod();

        abstract Optional<Import.ContentStructure> getContentStructure();

        abstract Optional<ValueProvider<String>> getImportGcsTempPath();

        abstract Optional<ValueProvider<String>> getImportGcsDeadLetterPath();

        public static Write fhirStoresImport(String fhirStore, String gcsTempPath, String gcsDeadLetterPath, @Nullable Import.ContentStructure contentStructure) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore)).setWriteMethod(WriteMethod.IMPORT).setContentStructure(contentStructure).setImportGcsTempPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gcsTempPath)).setImportGcsDeadLetterPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gcsDeadLetterPath)).build();
        }

        public static Write fhirStoresImport(String fhirStore, String gcsDeadLetterPath, @Nullable Import.ContentStructure contentStructure) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore)).setWriteMethod(WriteMethod.IMPORT).setContentStructure(contentStructure).setImportGcsDeadLetterPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)gcsDeadLetterPath)).build();
        }

        public static Write fhirStoresImport(ValueProvider<String> fhirStore, ValueProvider<String> gcsTempPath, ValueProvider<String> gcsDeadLetterPath, @Nullable Import.ContentStructure contentStructure) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore(fhirStore).setWriteMethod(WriteMethod.IMPORT).setContentStructure(contentStructure).setImportGcsTempPath(gcsTempPath).setImportGcsDeadLetterPath(gcsDeadLetterPath).build();
        }

        public static Write executeBundles(String fhirStore) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fhirStore)).setWriteMethod(WriteMethod.EXECUTE_BUNDLE).build();
        }

        public static Write executeBundles(ValueProvider<String> fhirStore) {
            return new AutoValue_FhirIO_Write.Builder().setFhirStore(fhirStore).setWriteMethod(WriteMethod.EXECUTE_BUNDLE).build();
        }

        public Result expand(PCollection<String> input) {
            switch (this.getWriteMethod()) {
                case IMPORT: {
                    LOG.warn("Make sure the Cloud Healthcare Service Agent has permissions when using import: https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#fhir_store_cloud_storage_permissions");
                    ValueProvider<String> deadPath = this.getImportGcsDeadLetterPath().orElseThrow(IllegalArgumentException::new);
                    Import.ContentStructure contentStructure = this.getContentStructure().orElseThrow(IllegalArgumentException::new);
                    ValueProvider<String> tempPath = this.getImportGcsTempPath().orElse((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input.getPipeline().getOptions().getTempLocation()));
                    return (Result)input.apply((PTransform)new Import(this.getFhirStore(), tempPath, deadPath, contentStructure));
                }
            }
            PCollectionTuple bundles = (PCollectionTuple)input.apply("Execute FHIR Bundles", (PTransform)ParDo.of((DoFn)new ExecuteBundles.ExecuteBundlesFn(this.getFhirStore())).withOutputTags(SUCCESSFUL_BODY, TupleTagList.of(FAILED_BODY)));
            bundles.get(SUCCESSFUL_BODY).setCoder((Coder)StringUtf8Coder.of());
            bundles.get(FAILED_BODY).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            return Result.in(input.getPipeline(), bundles);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFhirStore(ValueProvider<String> var1);

            abstract Builder setWriteMethod(WriteMethod var1);

            abstract Builder setContentStructure(Import.ContentStructure var1);

            abstract Builder setImportGcsTempPath(ValueProvider<String> var1);

            abstract Builder setImportGcsDeadLetterPath(ValueProvider<String> var1);

            abstract Write build();
        }

        public static class Result
        implements POutput {
            private final Pipeline pipeline;
            private final PCollection<String> successfulBodies;
            private final PCollection<HealthcareIOError<String>> failedBodies;
            private final PCollection<HealthcareIOError<String>> failedFiles;

            static Result in(Pipeline pipeline, PCollectionTuple bodies) throws IllegalArgumentException {
                if (bodies.has(SUCCESSFUL_BODY) && bodies.has(FAILED_BODY)) {
                    return new Result(pipeline, (PCollection<String>)bodies.get(SUCCESSFUL_BODY), (PCollection<HealthcareIOError<String>>)bodies.get(FAILED_BODY), null);
                }
                throw new IllegalArgumentException("The PCollection tuple bodies must have the FhirIO.Write.SUCCESSFUL_BODY and FhirIO.Write.FAILED_BODY tuple tags.");
            }

            static Result in(Pipeline pipeline, PCollection<HealthcareIOError<String>> failedBodies, PCollection<HealthcareIOError<String>> failedFiles) {
                return new Result(pipeline, null, failedBodies, failedFiles);
            }

            public PCollection<String> getSuccessfulBodies() {
                return this.successfulBodies;
            }

            public PCollection<HealthcareIOError<String>> getFailedBodies() {
                return this.failedBodies;
            }

            public PCollection<HealthcareIOError<String>> getFailedFiles() {
                return this.failedFiles;
            }

            public Pipeline getPipeline() {
                return this.pipeline;
            }

            public Map<TupleTag<?>, PValue> expand() {
                return ImmutableMap.of(SUCCESSFUL_BODY, this.successfulBodies, FAILED_BODY, this.failedBodies, FAILED_FILES, this.failedFiles);
            }

            public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
            }

            private Result(Pipeline pipeline, @Nullable PCollection<String> successfulBodies, PCollection<HealthcareIOError<String>> failedBodies, @Nullable PCollection<HealthcareIOError<String>> failedFiles) {
                this.pipeline = pipeline;
                if (successfulBodies == null) {
                    successfulBodies = (PCollection)pipeline.apply((PTransform)Create.empty((Coder)StringUtf8Coder.of()));
                }
                this.successfulBodies = successfulBodies;
                this.failedBodies = failedBodies;
                if (failedFiles == null) {
                    failedFiles = (PCollection)pipeline.apply((PTransform)Create.empty(HealthcareIOErrorCoder.of(StringUtf8Coder.of())));
                }
                this.failedFiles = failedFiles;
            }
        }

        public static enum WriteMethod {
            EXECUTE_BUNDLE,
            IMPORT;

        }
    }

    public static class Read
    extends PTransform<PCollection<String>, Result> {
        public static final TupleTag<String> OUT = new TupleTag<String>(){};
        public static final TupleTag<HealthcareIOError<String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

        public Result expand(PCollection<String> input) {
            return (Result)input.apply("Fetch Fhir messages", (PTransform)new FetchResourceJsonString());
        }

        static class FetchResourceJsonString
        extends PTransform<PCollection<String>, Result> {
            public Result expand(PCollection<String> resourceIds) {
                return new Result((PCollectionTuple)resourceIds.apply((PTransform)ParDo.of((DoFn)new ReadResourceFn()).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            static class ReadResourceFn
            extends DoFn<String, String> {
                private static final Logger LOG = LoggerFactory.getLogger(ReadResourceFn.class);
                private static final Counter READ_RESOURCE_ERRORS = Metrics.counter(ReadResourceFn.class, (String)"fhirio/read_resource_error_count");
                private static final Counter READ_RESOURCE_SUCCESS = Metrics.counter(ReadResourceFn.class, (String)"fhirio/read_resource_success_count");
                private static final Distribution READ_RESOURCE_LATENCY_MS = Metrics.distribution(ReadResourceFn.class, (String)"fhirio/read_resource_latency_ms");
                private HealthcareApiClient client;
                private ObjectMapper mapper;

                ReadResourceFn() {
                }

                @DoFn.Setup
                public void instantiateHealthcareClient() throws IOException {
                    this.client = new HttpHealthcareApiClient();
                    this.mapper = new ObjectMapper();
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    String resourceId = (String)context.element();
                    try {
                        context.output((Object)this.fetchResource(this.client, resourceId));
                    }
                    catch (Exception e) {
                        READ_RESOURCE_ERRORS.inc();
                        LOG.warn(String.format("Error fetching Fhir message with ID %s writing to Dead Letter Queue. Cause: %s Stack Trace: %s", resourceId, e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                        context.output(DEAD_LETTER, HealthcareIOError.of(resourceId, e));
                    }
                }

                private String fetchResource(HealthcareApiClient client, String resourceId) throws IOException, IllegalArgumentException {
                    long startTime = Instant.now().toEpochMilli();
                    HttpBody resource = client.readFhirResource(resourceId);
                    READ_RESOURCE_LATENCY_MS.update(Instant.now().toEpochMilli() - startTime);
                    if (resource == null) {
                        throw new IOException(String.format("GET request for %s returned null", resourceId));
                    }
                    READ_RESOURCE_SUCCESS.inc();
                    return this.mapper.writeValueAsString((Object)resource);
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private PCollection<String> resources;
            private PCollection<HealthcareIOError<String>> failedReads;
            PCollectionTuple pct;

            static Result of(PCollectionTuple pct) throws IllegalArgumentException {
                if (pct.has(OUT) && pct.has(DEAD_LETTER)) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the FhirIO.Read.OUT and FhirIO.Read.DEAD_LETTER tuple tags");
            }

            private Result(PCollectionTuple pct) {
                this.pct = pct;
                this.resources = pct.get(OUT);
                this.failedReads = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            }

            public PCollection<HealthcareIOError<String>> getFailedReads() {
                return this.failedReads;
            }

            public PCollection<String> getResources() {
                return this.resources;
            }

            public Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public Map<TupleTag<?>, PValue> expand() {
                return ImmutableMap.of(OUT, this.resources);
            }

            public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
            }
        }
    }
}

