/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReader;

class InitialOffsetReaderImpl
implements InitialOffsetReader {
    private final CursorClient client;
    private final SubscriptionPath subscription;
    private final Partition partition;

    InitialOffsetReaderImpl(CursorClient client, SubscriptionPath subscription, Partition partition) {
        this.client = client;
        this.subscription = subscription;
        this.partition = partition;
    }

    @Override
    public Offset read() throws ApiException {
        try {
            Map results = (Map)this.client.listPartitionCursors(this.subscription).get();
            return results.getOrDefault(this.partition, Offset.of((long)0L));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public void close() {
        this.client.close();
    }
}

