/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigtable.CellValueParser;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

public class BeamRowToBigtableMutation
extends PTransform<PCollection<Row>, PCollection<KV<ByteString, Iterable<Mutation>>>>
implements Serializable {
    private final Map<String, String> columnFamilyMapping;

    public BeamRowToBigtableMutation(Map<String, Set<String>> familyColumnMapping) {
        this.columnFamilyMapping = familyColumnMapping.entrySet().stream().flatMap(kv -> ((Set)kv.getValue()).stream().map(column -> KV.of((Object)column, (Object)((String)kv.getKey())))).collect(Collectors.toMap(KV::getKey, KV::getValue));
    }

    public PCollection<KV<ByteString, Iterable<Mutation>>> expand(PCollection<Row> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new ToBigtableRowFn(this.columnFamilyMapping)));
    }

    public static class ToBigtableRowFn
    extends SimpleFunction<Row, KV<ByteString, Iterable<Mutation>>> {
        private final Map<String, String> columnFamilyMapping;
        private final CellValueParser cellValueParser = new CellValueParser();

        public ToBigtableRowFn(Map<String, String> columnFamilyMapping) {
            this.columnFamilyMapping = columnFamilyMapping;
        }

        public KV<ByteString, Iterable<Mutation>> apply(Row row) {
            List mutations = this.columnFamilyMapping.entrySet().stream().map(columnFamily -> this.mutation((String)columnFamily.getValue(), (String)columnFamily.getKey(), row)).collect(Collectors.toList());
            String key = row.getString("key");
            if (key != null) {
                return KV.of((Object)ByteString.copyFromUtf8((String)key), mutations);
            }
            throw new NullPointerException("Null key");
        }

        private Mutation mutation(String family, String column, Row row) {
            return Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setValue(this.convertValueToByteString(row, column)).setColumnQualifier(ByteString.copyFromUtf8((String)column)).setFamilyName(family).build()).build();
        }

        private ByteString convertValueToByteString(Row row, String column) {
            Schema.Field field = row.getSchema().getField(column);
            Schema.TypeName typeName = field.getType().getTypeName();
            Object value = row.getValue(column);
            if (value == null) {
                throw new NullPointerException("Null value at column " + column);
            }
            return this.cellValueParser.valueToByteString(value, typeName);
        }
    }
}

