/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.util.UUID;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
class TagWithUniqueIds<KeyT, ElementT>
extends DoFn<KV<KeyT, ElementT>, KV<KeyT, TableRowInfo<ElementT>>> {
    private transient String randomUUID;
    private transient long sequenceNo = 0L;

    TagWithUniqueIds() {
    }

    @DoFn.StartBundle
    public void startBundle() {
        this.randomUUID = UUID.randomUUID().toString();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) throws IOException {
        String uniqueId = this.randomUUID + this.sequenceNo++;
        context.output((Object)KV.of((Object)((KV)context.element()).getKey(), new TableRowInfo<Object>(((KV)context.element()).getValue(), uniqueId)));
    }
}

