/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.protobuf.ByteString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_Uuid;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidCoder;

@DefaultCoder(value=UuidCoder.class)
@AutoValue
public abstract class Uuid {
    public static final String DEFAULT_ATTRIBUTE = "x-goog-pubsublite-dataflow-uuid";

    public abstract ByteString value();

    public static Uuid of(ByteString value) {
        return new AutoValue_Uuid(value);
    }

    public static Uuid random() {
        UUID uuid = UUID.randomUUID();
        ByteString.Output output = ByteString.newOutput((int)16);
        DataOutputStream stream = new DataOutputStream((OutputStream)output);
        try {
            stream.writeLong(uuid.getMostSignificantBits());
            stream.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException e) {
            throw new RuntimeException("Should never have an IOException since there is no io.", e);
        }
        return Uuid.of(ByteString.copyFrom((ByteBuffer)Base64.getEncoder().encode(output.toByteString().asReadOnlyByteBuffer())));
    }
}

