/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiConvertMessages;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritesShardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiLoads<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    private static final Logger LOG = LoggerFactory.getLogger(StorageApiLoads.class);
    static final int MAX_BATCH_SIZE_BYTES = 0x200000;
    private final Coder<DestinationT> destinationCoder;
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final String kmsKey;
    private final Duration triggeringFrequency;
    private final BigQueryServices bqServices;
    private final int numShards;

    public StorageApiLoads(Coder<DestinationT> destinationCoder, StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey, Duration triggeringFrequency, BigQueryServices bqServices, int numShards) {
        this.destinationCoder = destinationCoder;
        this.dynamicDestinations = dynamicDestinations;
        this.createDisposition = createDisposition;
        this.kmsKey = kmsKey;
        this.triggeringFrequency = triggeringFrequency;
        this.bqServices = bqServices;
        this.numShards = numShards;
    }

    public WriteResult expand(PCollection<KV<DestinationT, ElementT>> input) {
        return this.triggeringFrequency != null ? this.expandTriggered(input) : this.expandUntriggered(input);
    }

    public WriteResult expandTriggered(PCollection<KV<DestinationT, ElementT>> input) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollection shardedRecords = ((PCollection)((PCollection)inputInGlobalWindow.apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations))).apply("AddShard", (PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, byte[]>, KV<ShardedKey<DestinationT>, byte[]>>(){
            int shardNumber;

            @DoFn.Setup
            public void setup() {
                this.shardNumber = ThreadLocalRandom.current().nextInt(StorageApiLoads.this.numShards);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element KV<DestinationT, byte[]> element, DoFn.OutputReceiver<KV<ShardedKey<DestinationT>, byte[]>> o) {
                Object destination = element.getKey();
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.putInt(++this.shardNumber % StorageApiLoads.this.numShards);
                o.output((Object)KV.of((Object)ShardedKey.of((Object)destination, (byte[])buffer.array()), (Object)((byte[])element.getValue())));
            }
        }))).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of(this.destinationCoder), (Coder)ByteArrayCoder.of()));
        PCollection groupedRecords = (PCollection)shardedRecords.apply("GroupIntoBatches", (PTransform)GroupIntoBatches.ofByteSize((long)0x200000L, (SerializableFunction & Serializable)e -> ((byte[])e).length).withMaxBufferingDuration(this.triggeringFrequency));
        groupedRecords.apply("StorageApiWriteSharded", new StorageApiWritesShardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.createDisposition, this.kmsKey, this.bqServices, this.destinationCoder));
        return this.writeResult(input.getPipeline());
    }

    public WriteResult expandUntriggered(PCollection<KV<DestinationT, ElementT>> input) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        inputInGlobalWindow.apply("StorageApiWriteUnsharded", new StorageApiWriteUnshardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.createDisposition, this.kmsKey, this.bqServices, this.destinationCoder));
        return this.writeResult(input.getPipeline());
    }

    private WriteResult writeResult(Pipeline p) {
        PCollection empty = (PCollection)p.apply("CreateEmptyFailedInserts", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(TableRow.class)));
        return WriteResult.in(p, (TupleTag<TableRow>)new TupleTag("failedInserts"), (PCollection<TableRow>)empty);
    }
}

