/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritesShardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiLoads<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    private static final Logger LOG = LoggerFactory.getLogger(StorageApiLoads.class);
    static final int FILE_TRIGGERING_RECORD_COUNT = 100;
    private final Coder<DestinationT> destinationCoder;
    private final Coder<ElementT> elementCoder;
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final String kmsKey;
    private final Duration triggeringFrequency;
    private final BigQueryServices bqServices;
    private final int numShards;

    public StorageApiLoads(Coder<DestinationT> destinationCoder, Coder<ElementT> elementCoder, StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey, Duration triggeringFrequency, BigQueryServices bqServices, int numShards) {
        this.destinationCoder = destinationCoder;
        this.elementCoder = elementCoder;
        this.dynamicDestinations = dynamicDestinations;
        this.createDisposition = createDisposition;
        this.kmsKey = kmsKey;
        this.triggeringFrequency = triggeringFrequency;
        this.bqServices = bqServices;
        this.numShards = numShards;
    }

    public WriteResult expand(PCollection<KV<DestinationT, ElementT>> input) {
        return this.triggeringFrequency != null ? this.expandTriggered(input) : this.expandUntriggered(input);
    }

    public WriteResult expandTriggered(PCollection<KV<DestinationT, ElementT>> input) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.triggeringFrequency), AfterPane.elementCountAtLeast((int)100)}))).discardingFiredPanes());
        PCollection shardedRecords = ((PCollection)inputInGlobalWindow.apply("AddShard", (PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, ElementT>, KV<ShardedKey<DestinationT>, ElementT>>(){
            int shardNumber;

            @DoFn.Setup
            public void setup() {
                this.shardNumber = ThreadLocalRandom.current().nextInt(StorageApiLoads.this.numShards);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element KV<DestinationT, ElementT> element, DoFn.OutputReceiver<KV<ShardedKey<DestinationT>, ElementT>> o) {
                Object destination = element.getKey();
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.putInt(++this.shardNumber % StorageApiLoads.this.numShards);
                o.output((Object)KV.of((Object)ShardedKey.of((Object)destination, (byte[])buffer.array()), (Object)element.getValue()));
            }
        }))).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of(this.destinationCoder), this.elementCoder));
        PCollection groupedRecords = (PCollection)shardedRecords.apply("GroupIntoShards", (PTransform)GroupByKey.create());
        groupedRecords.apply("StorageApiWriteSharded", new StorageApiWritesShardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.createDisposition, this.kmsKey, this.bqServices, this.destinationCoder));
        return this.writeResult(input.getPipeline());
    }

    public WriteResult expandUntriggered(PCollection<KV<DestinationT, ElementT>> input) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        inputInGlobalWindow.apply("StorageApiWriteUnsharded", new StorageApiWriteUnshardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.createDisposition, this.kmsKey, this.bqServices, this.destinationCoder));
        return this.writeResult(input.getPipeline());
    }

    private WriteResult writeResult(Pipeline p) {
        PCollection empty = (PCollection)p.apply("CreateEmptyFailedInserts", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(TableRow.class)));
        return WriteResult.in(p, (TupleTag<TableRow>)new TupleTag("failedInserts"), (PCollection<TableRow>)empty);
    }
}

