/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.GenerateShardedTable;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteFn;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TagWithUniqueIds;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;

public class StreamingWriteTables
extends PTransform<PCollection<KV<TableDestination, TableRow>>, WriteResult> {
    private BigQueryServices bigQueryServices;
    private InsertRetryPolicy retryPolicy;

    public StreamingWriteTables() {
        this(new BigQueryServicesImpl(), InsertRetryPolicy.alwaysRetry());
    }

    private StreamingWriteTables(BigQueryServices bigQueryServices, InsertRetryPolicy retryPolicy) {
        this.bigQueryServices = bigQueryServices;
        this.retryPolicy = retryPolicy;
    }

    StreamingWriteTables withTestServices(BigQueryServices bigQueryServices) {
        return new StreamingWriteTables(bigQueryServices, this.retryPolicy);
    }

    StreamingWriteTables withInsertRetryPolicy(InsertRetryPolicy retryPolicy) {
        return new StreamingWriteTables(this.bigQueryServices, retryPolicy);
    }

    public WriteResult expand(PCollection<KV<TableDestination, TableRow>> input) {
        PCollection tagged = ((PCollection)((PCollection)input.apply("ShardTableWrites", (PTransform)ParDo.of((DoFn)new GenerateShardedTable(50)))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), (Coder)TableRowJsonCoder.of())).apply("TagWithUniqueIds", (PTransform)ParDo.of((DoFn)new TagWithUniqueIds()))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of()));
        TupleTag mainOutputTag = new TupleTag("mainOutput");
        TupleTag failedInsertsTag = new TupleTag("failedInserts");
        PCollectionTuple tuple = (PCollectionTuple)((PCollection)((PCollection)tagged.apply((PTransform)Reshuffle.of())).apply("GlobalWindow", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("StreamingWrite", (PTransform)ParDo.of((DoFn)new StreamingWriteFn(this.bigQueryServices, this.retryPolicy, (TupleTag<TableRow>)failedInsertsTag)).withOutputTags(mainOutputTag, TupleTagList.of((TupleTag)failedInsertsTag)));
        PCollection failedInserts = tuple.get(failedInsertsTag);
        failedInserts.setCoder((Coder)TableRowJsonCoder.of());
        return WriteResult.in(input.getPipeline(), (TupleTag<TableRow>)failedInsertsTag, (PCollection<TableRow>)failedInserts);
    }
}

