/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;

public class BigQueryHelpers {
    private static final String RESOURCE_NOT_FOUND_ERROR = "BigQuery %1$s not found for table \"%2$s\" . Please create the %1$s before pipeline execution. If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";
    private static final String UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR = "Unable to confirm BigQuery %1$s presence for table \"%2$s\". If the %1$s is created by an earlier stage of the pipeline, this validation can be disabled using #withoutValidation.";

    @Nullable
    static ValueProvider<String> displayTable(@Nullable ValueProvider<TableReference> table) {
        if (table == null) {
            return null;
        }
        return ValueProvider.NestedValueProvider.of(table, (SerializableFunction)new TableRefToTableSpec());
    }

    public static String toTableSpec(TableReference ref) {
        StringBuilder sb = new StringBuilder();
        if (ref.getProjectId() != null) {
            sb.append(ref.getProjectId());
            sb.append(":");
        }
        sb.append(ref.getDatasetId()).append('.').append(ref.getTableId());
        return sb.toString();
    }

    static <K, V> List<V> getOrCreateMapListValue(Map<K, List<V>> map, K key) {
        return map.computeIfAbsent(key, k -> new ArrayList());
    }

    public static TableReference parseTableSpec(String tableSpec) {
        Matcher match = BigQueryIO.TABLE_SPEC.matcher(tableSpec);
        if (!match.matches()) {
            throw new IllegalArgumentException("Table reference is not in [project_id]:[dataset_id].[table_id] format: " + tableSpec);
        }
        TableReference ref = new TableReference();
        ref.setProjectId(match.group("PROJECT"));
        return ref.setDatasetId(match.group("DATASET")).setTableId(match.group("TABLE"));
    }

    public static String stripPartitionDecorator(String tableSpec) {
        int index = tableSpec.lastIndexOf(36);
        return index == -1 ? tableSpec : tableSpec.substring(0, index);
    }

    static String jobToPrettyString(@Nullable Job job) throws IOException {
        return job == null ? "null" : job.toPrettyString();
    }

    static String statusToPrettyString(@Nullable JobStatus status) throws IOException {
        return status == null ? "Unknown status: null." : status.toPrettyString();
    }

    static Status parseStatus(@Nullable Job job) {
        if (job == null) {
            return Status.UNKNOWN;
        }
        JobStatus status = job.getStatus();
        if (status.getErrorResult() != null) {
            return Status.FAILED;
        }
        if (status.getErrors() != null && !status.getErrors().isEmpty()) {
            return Status.FAILED;
        }
        return Status.SUCCEEDED;
    }

    @VisibleForTesting
    static String toJsonString(Object item) {
        if (item == null) {
            return null;
        }
        try {
            return BigQueryIO.JSON_FACTORY.toString(item);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot serialize %s to a JSON string.", item.getClass().getSimpleName()), e);
        }
    }

    @VisibleForTesting
    static <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        try {
            return (T)BigQueryIO.JSON_FACTORY.fromString(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot deserialize %s from a JSON string: %s.", clazz, json), e);
        }
    }

    static String randomUUIDString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    static void verifyTableNotExistOrEmpty(BigQueryServices.DatasetService datasetService, TableReference tableRef) {
        try {
            if (datasetService.getTable(tableRef) != null) {
                Preconditions.checkState((boolean)datasetService.isTableEmpty(tableRef), (String)"BigQuery table is not empty: %s.", (Object)BigQueryHelpers.toTableSpec(tableRef));
            }
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("unable to confirm BigQuery table emptiness for table " + BigQueryHelpers.toTableSpec(tableRef), e);
        }
    }

    static void verifyDatasetPresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getDataset(table.getProjectId(), table.getDatasetId());
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "dataset", BigQueryHelpers.toTableSpec(table)), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "dataset", BigQueryHelpers.toTableSpec(table)), e);
        }
    }

    static void verifyTablePresence(BigQueryServices.DatasetService datasetService, TableReference table) {
        try {
            datasetService.getTable(table);
        }
        catch (Exception e) {
            ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
            if (e instanceof IOException && errorExtractor.itemNotFound((IOException)e)) {
                throw new IllegalArgumentException(String.format(RESOURCE_NOT_FOUND_ERROR, "table", BigQueryHelpers.toTableSpec(table)), e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(UNABLE_TO_CONFIRM_PRESENCE_OF_RESOURCE_ERROR, "table", BigQueryHelpers.toTableSpec(table)), e);
        }
    }

    static String createJobId(String prefix, TableDestination tableDestination, int partition, long index) {
        String destinationHash = Hashing.murmur3_128().hashUnencodedChars((CharSequence)tableDestination.toString()).toString();
        String jobId = String.format("%s_%s", prefix, destinationHash);
        if (partition >= 0) {
            jobId = jobId + String.format("_%05d", partition);
        }
        if (index >= 0L) {
            jobId = jobId + String.format("_%05d", index);
        }
        return jobId;
    }

    static String createJobIdToken(String jobName, String stepUuid) {
        return String.format("beam_job_%s_%s", stepUuid, jobName.replaceAll("-", ""));
    }

    static String getExtractJobId(String jobIdToken) {
        return String.format("%s-extract", jobIdToken);
    }

    static TableReference createTempTableReference(String projectId, String jobUuid) {
        String queryTempDatasetId = "temp_dataset_" + jobUuid;
        String queryTempTableId = "temp_table_" + jobUuid;
        TableReference queryTempTableRef = new TableReference().setProjectId(projectId).setDatasetId(queryTempDatasetId).setTableId(queryTempTableId);
        return queryTempTableRef;
    }

    static String resolveTempLocation(String tempLocationDir, String bigQueryOperationName, String stepUuid) {
        return FileSystems.matchNewResource((String)tempLocationDir, (boolean)true).resolve(bigQueryOperationName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(stepUuid, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).toString();
    }

    static class TimePartitioningToJson
    implements SerializableFunction<TimePartitioning, String> {
        TimePartitioningToJson() {
        }

        public String apply(TimePartitioning partitioning) {
            return BigQueryHelpers.toJsonString(partitioning);
        }
    }

    @VisibleForTesting
    static class TableSpecToTableRef
    implements SerializableFunction<String, TableReference> {
        TableSpecToTableRef() {
        }

        public TableReference apply(String from) {
            return BigQueryHelpers.parseTableSpec(from);
        }
    }

    static class TableRefToJson
    implements SerializableFunction<TableReference, String> {
        TableRefToJson() {
        }

        public String apply(TableReference from) {
            return BigQueryHelpers.toJsonString(from);
        }
    }

    static class TableRefToTableSpec
    implements SerializableFunction<TableReference, String> {
        TableRefToTableSpec() {
        }

        public String apply(TableReference from) {
            return BigQueryHelpers.toTableSpec(from);
        }
    }

    static class JsonTableRefToTableSpec
    implements SerializableFunction<String, String> {
        JsonTableRefToTableSpec() {
        }

        public String apply(String from) {
            return BigQueryHelpers.toTableSpec(BigQueryHelpers.fromJsonString(from, TableReference.class));
        }
    }

    static class JsonTableRefToTableRef
    implements SerializableFunction<String, TableReference> {
        JsonTableRefToTableRef() {
        }

        public TableReference apply(String from) {
            return BigQueryHelpers.fromJsonString(from, TableReference.class);
        }
    }

    static class TableSchemaToJsonSchema
    implements SerializableFunction<TableSchema, String> {
        TableSchemaToJsonSchema() {
        }

        public String apply(TableSchema from) {
            return BigQueryHelpers.toJsonString(from);
        }
    }

    @VisibleForTesting
    static class JsonSchemaToTableSchema
    implements SerializableFunction<String, TableSchema> {
        JsonSchemaToTableSchema() {
        }

        public TableSchema apply(String from) {
            return BigQueryHelpers.fromJsonString(from, TableSchema.class);
        }
    }

    static enum Status {
        SUCCEEDED,
        FAILED,
        UNKNOWN;

    }
}

