/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import java.io.Serializable;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReaderImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReaderSettings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class SubscriberOptions
implements Serializable {
    private static final long serialVersionUID = 269598118L;
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private static final long MEBIBYTE = 0x100000L;
    public static final FlowControlSettings DEFAULT_FLOW_CONTROL = FlowControlSettings.builder().setMessagesOutstanding(Long.MAX_VALUE).setBytesOutstanding(0x6400000L).build();

    public abstract SubscriptionPath subscriptionPath();

    public abstract FlowControlSettings flowControlSettings();

    public abstract Set<Partition> partitions();

    abstract @Nullable SubscriberFactory subscriberFactory();

    abstract @Nullable SerializableSupplier<Committer> committerSupplier();

    abstract @Nullable SerializableSupplier<TopicBacklogReader> backlogReaderSupplier();

    abstract @Nullable SerializableSupplier<InitialOffsetReader> offsetReaderSupplier();

    public static Builder newBuilder() {
        AutoValue_SubscriberOptions.Builder builder = new AutoValue_SubscriberOptions.Builder();
        return ((Builder)builder).setPartitions((Set<Partition>)ImmutableSet.of()).setFlowControlSettings(DEFAULT_FLOW_CONTROL);
    }

    public abstract Builder toBuilder();

    SubscriberFactory getSubscriberFactory(Partition partition) {
        SubscriberFactory factory = this.subscriberFactory();
        if (factory != null) {
            return factory;
        }
        return consumer -> SubscriberBuilder.newBuilder().setMessageConsumer(consumer).setSubscriptionPath(this.subscriptionPath()).setPartition(partition).setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK)).build();
    }

    Committer getCommitter(Partition partition) {
        SerializableSupplier<Committer> supplier = this.committerSupplier();
        if (supplier != null) {
            return supplier.get();
        }
        return CommitterBuilder.newBuilder().setSubscriptionPath(this.subscriptionPath()).setPartition(partition).build();
    }

    TopicBacklogReader getBacklogReader(Partition partition) {
        SerializableSupplier<TopicBacklogReader> supplier = this.backlogReaderSupplier();
        if (supplier != null) {
            return supplier.get();
        }
        return TopicBacklogReaderSettings.newBuilder().setTopicPathFromSubscriptionPath(this.subscriptionPath()).setPartition(partition).build().instantiate();
    }

    InitialOffsetReader getInitialOffsetReader(Partition partition) {
        SerializableSupplier<InitialOffsetReader> supplier = this.offsetReaderSupplier();
        if (supplier != null) {
            return supplier.get();
        }
        return new InitialOffsetReaderImpl(CursorClient.create((CursorClientSettings)CursorClientSettings.newBuilder().setRegion(this.subscriptionPath().location().region()).build()), this.subscriptionPath(), partition);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartitions(Set<Partition> var1);

        public abstract Builder setFlowControlSettings(FlowControlSettings var1);

        abstract Builder setSubscriberFactory(SubscriberFactory var1);

        abstract Builder setCommitterSupplier(SerializableSupplier<Committer> var1);

        abstract Builder setBacklogReaderSupplier(SerializableSupplier<TopicBacklogReader> var1);

        abstract Builder setOffsetReaderSupplier(SerializableSupplier<InitialOffsetReader> var1);

        public abstract SubscriberOptions build();
    }
}

