/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class TableContainer {
    @UnknownKeyFor @NonNull @Initialized Table table;
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rows;
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> ids;
    @UnknownKeyFor @NonNull @Initialized Long sizeBytes;

    TableContainer(@UnknownKeyFor @NonNull @Initialized Table table) {
        this.table = table;
        this.rows = new ArrayList<TableRow>();
        this.ids = new ArrayList<String>();
        this.sizeBytes = 0L;
    }

    @UnknownKeyFor @NonNull @Initialized long addRow(@UnknownKeyFor @NonNull @Initialized TableRow row, @UnknownKeyFor @NonNull @Initialized String id) {
        this.rows.add(row);
        if (id != null) {
            this.ids.add(id);
        }
        long tableSize = this.table.getNumBytes() == null ? 0L : this.table.getNumBytes();
        try {
            long rowSize = TableRowJsonCoder.of().getEncodedElementByteSize(row);
            this.table.setNumBytes(Long.valueOf(tableSize + rowSize));
            return rowSize;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to convert the row to JSON", ex);
        }
    }

    @UnknownKeyFor @NonNull @Initialized Table getTable() {
        return this.table;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> getRows() {
        return this.rows;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getIds() {
        return this.ids;
    }
}

