/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

class SpannerAccessor
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SpannerAccessor.class);
    private static final @UnknownKeyFor @NonNull @Initialized String USER_AGENT_PREFIX = "Apache_Beam_Java";
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized SpannerConfig, @UnknownKeyFor @NonNull @Initialized SpannerAccessor> spannerAccessors = new ConcurrentHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized SpannerConfig, @UnknownKeyFor @NonNull @Initialized AtomicInteger> refcounts = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized Spanner spanner;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient;
    private final @UnknownKeyFor @NonNull @Initialized BatchClient batchClient;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient databaseAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig;

    private SpannerAccessor(@UnknownKeyFor @NonNull @Initialized Spanner spanner, @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient, @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient databaseAdminClient, @UnknownKeyFor @NonNull @Initialized BatchClient batchClient, @UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        this.spanner = spanner;
        this.databaseClient = databaseClient;
        this.databaseAdminClient = databaseAdminClient;
        this.batchClient = batchClient;
        this.spannerConfig = spannerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static @UnknownKeyFor @NonNull @Initialized SpannerAccessor getOrCreate(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        SpannerAccessor self = spannerAccessors.get(spannerConfig);
        if (self == null) {
            ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
            synchronized (concurrentHashMap) {
                self = spannerAccessors.get(spannerConfig);
                if (self == null) {
                    LOG.info("Connecting to {}", (Object)spannerConfig);
                    self = SpannerAccessor.createAndConnect(spannerConfig);
                    spannerAccessors.put(spannerConfig, self);
                    refcounts.putIfAbsent(spannerConfig, new AtomicInteger(0));
                }
            }
        }
        int refcount = refcounts.get(spannerConfig).incrementAndGet();
        LOG.debug("getOrCreate(): refcount={} for {}", (Object)refcount, (Object)spannerConfig);
        return self;
    }

    private static @UnknownKeyFor @NonNull @Initialized SpannerAccessor createAndConnect(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        ValueProvider<String> emulatorHost;
        ValueProvider<String> host;
        ServiceFactory<Spanner, SpannerOptions> serviceFactory;
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        ValueProvider<org.joda.time.Duration> commitDeadline = spannerConfig.getCommitDeadline();
        if (commitDeadline != null && ((org.joda.time.Duration)commitDeadline.get()).getMillis() > 0L) {
            UnaryCallSettings.Builder commitSettings = builder.getSpannerStubSettingsBuilder().commitSettings();
            RetrySettings.Builder commitRetrySettings = commitSettings.getRetrySettings().toBuilder();
            commitSettings.setRetrySettings(commitRetrySettings.setTotalTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setMaxRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setInitialRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).build());
        }
        ServerStreamingCallSettings.Builder executeStreamingSqlSettings = builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings();
        RetrySettings.Builder executeSqlStreamingRetrySettings = executeStreamingSqlSettings.getRetrySettings().toBuilder();
        executeStreamingSqlSettings.setRetrySettings(executeSqlStreamingRetrySettings.setInitialRpcTimeout(Duration.ofMinutes((long)120L)).setMaxRpcTimeout(Duration.ofMinutes((long)120L)).setTotalTimeout(Duration.ofMinutes((long)120L)).build());
        ValueProvider<String> projectId = spannerConfig.getProjectId();
        if (projectId != null) {
            builder.setProjectId((String)projectId.get());
        }
        if ((serviceFactory = spannerConfig.getServiceFactory()) != null) {
            builder.setServiceFactory(serviceFactory);
        }
        if ((host = spannerConfig.getHost()) != null) {
            builder.setHost((String)host.get());
        }
        if ((emulatorHost = spannerConfig.getEmulatorHost()) != null) {
            builder.setEmulatorHost((String)emulatorHost.get());
            builder.setCredentials((Credentials)NoCredentials.getInstance());
        }
        String userAgentString = "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion();
        builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"user-agent", userAgentString}));
        SpannerOptions options = builder.build();
        Spanner spanner = (Spanner)options.getService();
        String instanceId = (String)spannerConfig.getInstanceId().get();
        String databaseId = (String)spannerConfig.getDatabaseId().get();
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        BatchClient batchClient = spanner.getBatchClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
        return new SpannerAccessor(spanner, databaseClient, databaseAdminClient, batchClient, spannerConfig);
    }

    public @UnknownKeyFor @NonNull @Initialized DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    public @UnknownKeyFor @NonNull @Initialized BatchClient getBatchClient() {
        return this.batchClient;
    }

    public @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient getDatabaseAdminClient() {
        return this.databaseAdminClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int refcount = refcounts.getOrDefault(this.spannerConfig, new AtomicInteger(0)).decrementAndGet();
        LOG.debug("close(): refcount={} for {}", (Object)refcount, (Object)this.spannerConfig);
        if (refcount == 0) {
            ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
            synchronized (concurrentHashMap) {
                if (refcounts.get(this.spannerConfig).get() <= 0) {
                    spannerAccessors.remove(this.spannerConfig);
                    refcounts.remove(this.spannerConfig);
                    LOG.info("Closing {} ", (Object)this.spannerConfig);
                    this.spanner.close();
                }
            }
        }
    }

    private static class CommitDeadlineSettingInterceptor
    implements ClientInterceptor {
        private final @UnknownKeyFor @NonNull @Initialized long commitDeadlineMilliseconds;

        private CommitDeadlineSettingInterceptor(@UnknownKeyFor @NonNull @Initialized org.joda.time.Duration commitDeadline) {
            this.commitDeadlineMilliseconds = commitDeadline.getMillis();
        }

        public <ReqT, RespT> @UnknownKeyFor @NonNull @Initialized ClientCall<ReqT, RespT> interceptCall(@UnknownKeyFor @NonNull @Initialized MethodDescriptor<ReqT, RespT> method, @UnknownKeyFor @NonNull @Initialized CallOptions callOptions, @UnknownKeyFor @NonNull @Initialized Channel next) {
            if (method.getFullMethodName().equals("google.spanner.v1.Spanner/Commit")) {
                callOptions = callOptions.withDeadlineAfter(this.commitDeadlineMilliseconds, TimeUnit.MILLISECONDS);
            }
            return next.newCall(method, callOptions);
        }
    }
}

