/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Statement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_ReadOperation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class ReadOperation
implements Serializable {
    public static @UnknownKeyFor @NonNull @Initialized ReadOperation create() {
        return new AutoValue_ReadOperation.Builder().setPartitionOptions(PartitionOptions.getDefaultInstance()).setKeySet(KeySet.all()).build();
    }

    public abstract @Nullable @UnknownKeyFor @Initialized Statement getQuery();

    public abstract @Nullable @UnknownKeyFor @Initialized String getTable();

    public abstract @Nullable @UnknownKeyFor @Initialized String getIndex();

    public abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getColumns();

    public abstract @Nullable @UnknownKeyFor @Initialized KeySet getKeySet();

    abstract @Nullable @UnknownKeyFor @Initialized PartitionOptions getPartitionOptions();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withTable(@UnknownKeyFor @NonNull @Initialized String table) {
        return this.toBuilder().setTable(table).build();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withColumns(String ... columns) {
        return this.withColumns(Arrays.asList(columns));
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> columns) {
        return this.toBuilder().setColumns(columns).build();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withQuery(@UnknownKeyFor @NonNull @Initialized Statement statement) {
        return this.toBuilder().setQuery(statement).build();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withQuery(@UnknownKeyFor @NonNull @Initialized String sql) {
        return this.withQuery(Statement.of((String)sql));
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withKeySet(@UnknownKeyFor @NonNull @Initialized KeySet keySet) {
        return this.toBuilder().setKeySet(keySet).build();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withIndex(@UnknownKeyFor @NonNull @Initialized String index) {
        return this.toBuilder().setIndex(index).build();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadOperation withPartitionOptions(@UnknownKeyFor @NonNull @Initialized PartitionOptions partitionOptions) {
        return this.toBuilder().setPartitionOptions(partitionOptions).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized Statement var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTable(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setIndex(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setKeySet(@UnknownKeyFor @NonNull @Initialized KeySet var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionOptions(@UnknownKeyFor @NonNull @Initialized PartitionOptions var1);

        abstract @UnknownKeyFor @NonNull @Initialized ReadOperation build();
    }
}

