/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.TypeToken;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class Publishers {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    private Publishers() {
    }

    static @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized PublishMetadata> newPublisher(@UnknownKeyFor @NonNull @Initialized PublisherOptions options) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        SerializableSupplier<Object> supplier = options.publisherSupplier();
        if (supplier != null) {
            Object supplied = supplier.get();
            TypeToken<Publisher<PublishMetadata>> token = new TypeToken<Publisher<PublishMetadata>>(){};
            UncheckedApiPreconditions.checkArgument((boolean)token.isSupertypeOf(supplied.getClass()));
            return (Publisher)supplied;
        }
        return new PartitionCountWatchingPublisher(PartitionCountWatchingPublisherSettings.newBuilder().setTopic(options.topicPath()).setPublisherFactory(partition -> SinglePartitionPublisherBuilder.newBuilder().setTopic(options.topicPath()).setPartition(partition).setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK)).build()).build());
    }
}

