/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReader;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class InitialOffsetReaderImpl
implements InitialOffsetReader {
    private final @UnknownKeyFor @NonNull @Initialized CursorClient client;
    private final @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription;
    private final @UnknownKeyFor @NonNull @Initialized Partition partition;

    InitialOffsetReaderImpl(@UnknownKeyFor @NonNull @Initialized CursorClient client, @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscription, @UnknownKeyFor @NonNull @Initialized Partition partition) {
        this.client = client;
        this.subscription = subscription;
        this.partition = partition;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Offset read() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        try {
            Map results = (Map)this.client.listPartitionCursors(this.subscription).get();
            return results.getOrDefault(this.partition, Offset.of((long)0L));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public void close() {
        this.client.close();
    }
}

