/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.protobuf.ByteString;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DlqProvider
implements GenericDlqProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "pubsublite";
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure>, @UnknownKeyFor @NonNull @Initialized PDone> newDlqTransform(@UnknownKeyFor @NonNull @Initialized String config) {
        return new DlqTransform(TopicPath.parse((String)config));
    }

    private static class DlqTransform
    extends PTransform<PCollection<Failure>, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized TopicPath topic;

        DlqTransform(@UnknownKeyFor @NonNull @Initialized TopicPath topic) {
            this.topic = topic;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure> input) {
            return (PDone)((PCollection)input.apply("Failure to PubSubMessage", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubSubMessage.class)).via(DlqTransform::getMessage))).apply("Write Failures to Pub/Sub Lite", PubsubLiteIO.write(PublisherOptions.newBuilder().setTopicPath(this.topic).build()));
        }

        private static @UnknownKeyFor @NonNull @Initialized PubSubMessage getMessage(@UnknownKeyFor @NonNull @Initialized Failure failure) {
            PubSubMessage.Builder builder = PubSubMessage.newBuilder();
            builder.putAttributes("beam-dlq-error", AttributeValues.newBuilder().addValues(ByteString.copyFromUtf8((String)failure.getError())).build());
            builder.setData(ByteString.copyFrom((byte[])failure.getPayload()));
            return builder.build();
        }
    }
}

