/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.DropFields;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RowToPubsubMessage
extends PTransform<PCollection<Row>, PCollection<PubsubMessage>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(RowToPubsubMessage.class);
    private final @UnknownKeyFor @NonNull @Initialized boolean useTimestampAttribute;
    private final @UnknownKeyFor @NonNull @Initialized PubsubSchemaIOProvider.PayloadFormat payloadFormat;
    private final @Nullable @UnknownKeyFor @Initialized Schema payloadSchema;

    private RowToPubsubMessage(@UnknownKeyFor @NonNull @Initialized boolean useTimestampAttribute, @UnknownKeyFor @NonNull @Initialized PubsubSchemaIOProvider.PayloadFormat payloadFormat, @Nullable @UnknownKeyFor @Initialized Schema schema) {
        this.useTimestampAttribute = useTimestampAttribute;
        this.payloadFormat = payloadFormat;
        this.payloadSchema = schema == null ? null : this.stripFromTimestampField(schema);
    }

    public static @UnknownKeyFor @NonNull @Initialized RowToPubsubMessage of(@UnknownKeyFor @NonNull @Initialized boolean useTimestampAttribute, @UnknownKeyFor @NonNull @Initialized PubsubSchemaIOProvider.PayloadFormat payloadFormat) {
        return new RowToPubsubMessage(useTimestampAttribute, payloadFormat, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized RowToPubsubMessage of(@UnknownKeyFor @NonNull @Initialized boolean useTimestampAttribute, @UnknownKeyFor @NonNull @Initialized PubsubSchemaIOProvider.PayloadFormat payloadFormat, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new RowToPubsubMessage(useTimestampAttribute, payloadFormat, schema);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        PCollection rows;
        PCollection withTimestamp;
        PCollection pCollection = withTimestamp = this.useTimestampAttribute ? (PCollection)input.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)row -> row.getDateTime("event_timestamp").toInstant())) : input;
        if (withTimestamp.getSchema().hasField("event_timestamp")) {
            if (!this.useTimestampAttribute) {
                LOG.warn(String.format("Dropping output field '%s' before writing to PubSub because this is a read-only column. To preserve this information you must configure a timestamp attribute.", "event_timestamp"));
            }
            rows = (PCollection)withTimestamp.apply((PTransform)DropFields.fields((String[])new String[]{"event_timestamp"}));
        } else {
            rows = withTimestamp;
        }
        switch (this.payloadFormat) {
            case JSON: {
                return (PCollection)((PCollection)((PCollection)rows.apply("MapRowToJsonString", (PTransform)ToJson.of())).apply("MapToJsonBytes", (PTransform)MapElements.via((SimpleFunction)new StringToBytes()))).apply("MapToPubsubMessage", (PTransform)MapElements.via((SimpleFunction)new ToPubsubMessage()));
            }
            case AVRO: {
                return (PCollection)((PCollection)rows.apply("MapRowToAvroBytes", (PTransform)MapElements.via((SimpleFunction)AvroUtils.getRowToAvroBytesFunction((Schema)this.payloadSchema)))).apply("MapToPubsubMessage", (PTransform)MapElements.via((SimpleFunction)new ToPubsubMessage()));
            }
        }
        throw new IllegalArgumentException("Unsupported payload format: " + (Object)((Object)this.payloadFormat));
    }

    private @UnknownKeyFor @NonNull @Initialized Schema stripFromTimestampField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        List<Schema.Field> selectedFields = schema.getFields().stream().filter(field -> !"event_timestamp".equals(field.getName())).collect(Collectors.toList());
        return Schema.of((Schema.Field[])selectedFields.toArray(new Schema.Field[0]));
    }

    private static class ToPubsubMessage
    extends SimpleFunction<byte[], PubsubMessage> {
        private ToPubsubMessage() {
        }

        public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
            return new PubsubMessage(bytes, (Map<String, String>)ImmutableMap.of());
        }
    }

    private static class StringToBytes
    extends SimpleFunction<String, byte[]> {
        private StringToBytes() {
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized String s) {
            return s.getBytes(StandardCharsets.UTF_8);
        }
    }
}

