/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import com.google.auto.value.AutoValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.SizeLimitExceededException;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubIO_Read;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubIO_Write;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubJsonClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessagePayloadOnlyCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesAndMessageIdCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithAttributesCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageWithMessageIdCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubsubIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PubsubIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory FACTORY = PubsubJsonClient.FACTORY;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern PROJECT_ID_REGEXP = Pattern.compile("[a-z][-a-z0-9:.]{4,61}[a-z0-9]");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern SUBSCRIPTION_REGEXP = Pattern.compile("projects/([^/]+)/subscriptions/(.+)");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern TOPIC_REGEXP = Pattern.compile("projects/([^/]+)/topics/(.+)");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern V1BETA1_SUBSCRIPTION_REGEXP = Pattern.compile("/subscriptions/([^/]+)/(.+)");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern V1BETA1_TOPIC_REGEXP = Pattern.compile("/topics/([^/]+)/(.+)");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern PUBSUB_NAME_REGEXP = Pattern.compile("[a-zA-Z][-._~%+a-zA-Z0-9]+");
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_NAME_MIN_LENGTH = 3;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_NAME_MAX_LENGTH = 255;
    private static final @UnknownKeyFor @NonNull @Initialized String SUBSCRIPTION_RANDOM_TEST_PREFIX = "_random/";
    private static final @UnknownKeyFor @NonNull @Initialized String SUBSCRIPTION_STARTING_SIGNAL = "_starting_signal/";
    private static final @UnknownKeyFor @NonNull @Initialized String TOPIC_DEV_NULL_TEST_NAME = "/topics/dev/null";

    private static void validateProjectName(@UnknownKeyFor @NonNull @Initialized String project) {
        Matcher match = PROJECT_ID_REGEXP.matcher(project);
        if (!match.matches()) {
            throw new IllegalArgumentException("Illegal project name specified in Pubsub subscription: " + project);
        }
    }

    private static void validatePubsubName(@UnknownKeyFor @NonNull @Initialized String name) {
        if (name.length() < 3) {
            throw new IllegalArgumentException("Pubsub object name is shorter than 3 characters: " + name);
        }
        if (name.length() > 255) {
            throw new IllegalArgumentException("Pubsub object name is longer than 255 characters: " + name);
        }
        if (name.startsWith("goog")) {
            throw new IllegalArgumentException("Pubsub object name cannot start with goog: " + name);
        }
        Matcher match = PUBSUB_NAME_REGEXP.matcher(name);
        if (!match.matches()) {
            throw new IllegalArgumentException("Illegal Pubsub object name specified: " + name + " Please see Javadoc for naming rules.");
        }
    }

    private static void populateCommonDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder, @UnknownKeyFor @NonNull @Initialized String timestampAttribute, @UnknownKeyFor @NonNull @Initialized String idAttribute, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubTopic> topic) {
        builder.addIfNotNull(DisplayData.item((String)"timestampAttribute", (String)timestampAttribute).withLabel("Timestamp Attribute")).addIfNotNull(DisplayData.item((String)"idAttribute", (String)idAttribute).withLabel("ID Attribute")).addIfNotNull(DisplayData.item((String)"topic", topic).withLabel("Pubsub Topic"));
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> readMessages() {
        return Read.newBuilder().setCoder((Coder<PubsubMessage>)PubsubMessagePayloadOnlyCoder.of()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> readMessagesWithMessageId() {
        return Read.newBuilder().setCoder((Coder<PubsubMessage>)PubsubMessageWithMessageIdCoder.of()).setNeedsMessageId(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> readMessagesWithAttributes() {
        return Read.newBuilder().setCoder((Coder<PubsubMessage>)PubsubMessageWithAttributesCoder.of()).setNeedsAttributes(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> readMessagesWithAttributesAndMessageId() {
        return Read.newBuilder().setCoder((Coder<PubsubMessage>)PubsubMessageWithAttributesAndMessageIdCoder.of()).setNeedsAttributes(true).setNeedsMessageId(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized String> readStrings() {
        return Read.newBuilder((SerializableFunction & Serializable)message -> new String(message.getPayload(), StandardCharsets.UTF_8)).setCoder(StringUtf8Coder.of()).build();
    }

    public static <T extends Message> @UnknownKeyFor @NonNull @Initialized Read<T> readProtos(@UnknownKeyFor @NonNull @Initialized Class<T> messageClass) {
        ProtoCoder coder = ProtoCoder.of(messageClass);
        return Read.newBuilder(PubsubIO.parsePayloadUsingCoder(coder)).setCoder((Coder<T>)coder).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> readAvros(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        AvroCoder coder = AvroCoder.of(clazz);
        return Read.newBuilder(PubsubIO.parsePayloadUsingCoder(coder)).setCoder((Coder<T>)coder).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> readMessagesWithCoderAndParseFn(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, T> parseFn) {
        return Read.newBuilder(parseFn).setCoder(coder).build();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized GenericRecord> readAvroGenericRecords(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema avroSchema) {
        Schema schema = AvroUtils.getSchema(GenericRecord.class, (org.apache.avro.Schema)avroSchema);
        AvroCoder coder = AvroCoder.of(GenericRecord.class, (org.apache.avro.Schema)avroSchema);
        return Read.newBuilder(PubsubIO.parsePayloadUsingCoder(coder)).setCoder((Coder)SchemaCoder.of((Schema)schema, (TypeDescriptor)TypeDescriptor.of(GenericRecord.class), (SerializableFunction)AvroUtils.getToRowFunction(GenericRecord.class, (org.apache.avro.Schema)avroSchema), (SerializableFunction)AvroUtils.getFromRowFunction(GenericRecord.class))).build();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> readAvrosWithBeamSchema(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        if (clazz.equals(GenericRecord.class)) {
            throw new IllegalArgumentException("For GenericRecord, please call readAvroGenericRecords");
        }
        org.apache.avro.Schema avroSchema = ReflectData.get().getSchema(clazz);
        AvroCoder coder = AvroCoder.of(clazz);
        Schema schema = AvroUtils.getSchema(clazz, null);
        return Read.newBuilder(PubsubIO.parsePayloadUsingCoder(coder)).setCoder((Coder<T>)SchemaCoder.of((Schema)schema, (TypeDescriptor)TypeDescriptor.of(clazz), (SerializableFunction)AvroUtils.getToRowFunction(clazz, (org.apache.avro.Schema)avroSchema), (SerializableFunction)AvroUtils.getFromRowFunction(clazz))).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> writeMessages() {
        return Write.newBuilder().build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized String> writeStrings() {
        return Write.newBuilder((SerializableFunction & Serializable)string -> new PubsubMessage(string.getBytes(StandardCharsets.UTF_8), (Map<String, String>)ImmutableMap.of())).build();
    }

    public static <T extends Message> @UnknownKeyFor @NonNull @Initialized Write<T> writeProtos(@UnknownKeyFor @NonNull @Initialized Class<T> messageClass) {
        return Write.newBuilder(PubsubIO.formatPayloadUsingCoder(ProtoCoder.of(messageClass))).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> writeAvros(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return Write.newBuilder(PubsubIO.formatPayloadUsingCoder(AvroCoder.of(clazz))).build();
    }

    private PubsubIO() {
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, T> parsePayloadUsingCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return (SerializableFunction & Serializable)message -> {
            try {
                return CoderUtils.decodeFromByteArray((Coder)coder, (byte[])message.getPayload());
            }
            catch (CoderException e) {
                throw new RuntimeException("Could not decode Pubsub message", e);
            }
        };
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatPayloadUsingCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return (SerializableFunction & Serializable)input -> {
            try {
                return new PubsubMessage(CoderUtils.encodeToByteArray((Coder)coder, (Object)input), (Map<String, String>)ImmutableMap.of());
            }
            catch (CoderException e) {
                throw new RuntimeException("Could not encode Pubsub message", e);
            }
        };
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_PUBLISH_BATCH_BYTE_SIZE_DEFAULT = 7500000;
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_PUBLISH_BATCH_SIZE = 100;

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubTopic> getTopicProvider();

        abstract @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory getPubsubClientFactory();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxBatchSize();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxBatchBytesSize();

        abstract @Nullable @UnknownKeyFor @Initialized String getTimestampAttribute();

        abstract @Nullable @UnknownKeyFor @Initialized String getIdAttribute();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized PubsubMessage> getFormatFn();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> newBuilder(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatFn) {
            AutoValue_PubsubIO_Write.Builder<T> builder = new AutoValue_PubsubIO_Write.Builder<T>();
            ((Builder)builder).setPubsubClientFactory(FACTORY);
            ((Builder)builder).setFormatFn(formatFn);
            return builder;
        }

        static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized PubsubMessage> newBuilder() {
            return Write.newBuilder((SerializableFunction & Serializable)x -> x);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized String topic) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)topic));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> topic) {
            return this.toBuilder().setTopicProvider((ValueProvider<PubsubTopic>)ValueProvider.NestedValueProvider.of(topic, PubsubTopic::fromPath)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClientFactory(@UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory factory) {
            return this.toBuilder().setPubsubClientFactory(factory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
            return this.toBuilder().setMaxBatchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxBatchBytesSize(@UnknownKeyFor @NonNull @Initialized int maxBatchBytesSize) {
            return this.toBuilder().setMaxBatchBytesSize(maxBatchBytesSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTimestampAttribute(@UnknownKeyFor @NonNull @Initialized String timestampAttribute) {
            return this.toBuilder().setTimestampAttribute(timestampAttribute).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withIdAttribute(@UnknownKeyFor @NonNull @Initialized String idAttribute) {
            return this.toBuilder().setIdAttribute(idAttribute).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Write<T> withFormatFn(@UnknownKeyFor @NonNull @Initialized SimpleFunction<T, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatFn) {
            return this.toBuilder().setFormatFn((SerializableFunction<T, PubsubMessage>)formatFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (this.getTopicProvider() == null) {
                throw new IllegalStateException("need to set the topic of a PubsubIO.Write transform");
            }
            switch (input.isBounded()) {
                case BOUNDED: {
                    input.apply((PTransform)ParDo.of((DoFn)new PubsubBoundedWriter((Integer)MoreObjects.firstNonNull((Object)this.getMaxBatchSize(), (Object)100), (Integer)MoreObjects.firstNonNull((Object)this.getMaxBatchBytesSize(), (Object)7500000))));
                    return PDone.in((Pipeline)input.getPipeline());
                }
                case UNBOUNDED: {
                    return (PDone)((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<PubsubMessage>(){}).via(this.getFormatFn()))).apply((PTransform)new PubsubUnboundedSink(this.getPubsubClientFactory(), (ValueProvider<PubsubClient.TopicPath>)ValueProvider.NestedValueProvider.of(this.getTopicProvider(), (SerializableFunction)new TopicPathTranslator()), this.getTimestampAttribute(), this.getIdAttribute(), 100, (Integer)MoreObjects.firstNonNull((Object)this.getMaxBatchSize(), (Object)1000), (Integer)MoreObjects.firstNonNull((Object)this.getMaxBatchBytesSize(), (Object)400000)));
                }
            }
            throw new RuntimeException();
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            PubsubIO.populateCommonDisplayData(builder, this.getTimestampAttribute(), this.getIdAttribute(), (ValueProvider<PubsubTopic>)this.getTopicProvider());
        }

        public class PubsubBoundedWriter
        extends DoFn<T, Void> {
            private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PubsubClient.OutgoingMessage> output;
            private transient @UnknownKeyFor @NonNull @Initialized PubsubClient pubsubClient;
            private transient @UnknownKeyFor @NonNull @Initialized int currentOutputBytes;
            private @UnknownKeyFor @NonNull @Initialized int maxPublishBatchByteSize;
            private @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize;

            PubsubBoundedWriter(@UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize, int maxPublishBatchByteSize) {
                this.maxPublishBatchSize = maxPublishBatchSize;
                this.maxPublishBatchByteSize = maxPublishBatchByteSize;
            }

            PubsubBoundedWriter() {
                this(100, 7500000);
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.output = new ArrayList<PubsubClient.OutgoingMessage>();
                this.currentOutputBytes = 0;
                this.pubsubClient = Write.this.getPubsubClientFactory().newClient(Write.this.getTimestampAttribute(), null, (PubsubOptions)c.getPipelineOptions().as(PubsubOptions.class));
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized SizeLimitExceededException {
                PubsubMessage message = (PubsubMessage)Write.this.getFormatFn().apply(c.element());
                byte[] payload = message.getPayload();
                Map<String, String> attributes = message.getAttributeMap();
                if (payload.length > this.maxPublishBatchByteSize) {
                    String msg = String.format("Pub/Sub message size (%d) exceeded maximum batch size (%d)", payload.length, this.maxPublishBatchByteSize);
                    throw new SizeLimitExceededException(msg);
                }
                if (this.currentOutputBytes + payload.length >= this.maxPublishBatchByteSize || this.output.size() >= this.maxPublishBatchSize) {
                    this.publish();
                }
                this.output.add(PubsubClient.OutgoingMessage.of(com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])payload)).putAllAttributes(attributes).build(), c.timestamp().getMillis(), null));
                this.currentOutputBytes += payload.length;
            }

            @DoFn.FinishBundle
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (!this.output.isEmpty()) {
                    this.publish();
                }
                this.output = null;
                this.currentOutputBytes = 0;
                this.pubsubClient.close();
                this.pubsubClient = null;
            }

            private void publish() throws @UnknownKeyFor @NonNull @Initialized IOException {
                PubsubTopic topic = (PubsubTopic)Write.this.getTopicProvider().get();
                int n = this.pubsubClient.publish(PubsubClient.topicPathFromName(topic.project, topic.topic), this.output);
                Preconditions.checkState((n == this.output.size() ? 1 : 0) != 0);
                this.output.clear();
                this.currentOutputBytes = 0;
            }

            public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.delegate((HasDisplayData)Write.this);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTopicProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubTopic> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPubsubClientFactory(@UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxBatchSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxBatchBytesSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTimestampAttribute(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setIdAttribute(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFormatFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized PubsubMessage> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubTopic> getTopicProvider();

        abstract @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory getPubsubClientFactory();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubSubscription> getSubscriptionProvider();

        abstract @Nullable @UnknownKeyFor @Initialized String getTimestampAttribute();

        abstract @Nullable @UnknownKeyFor @Initialized String getIdAttribute();

        abstract @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, T> getParseFn();

        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract @Nullable @UnknownKeyFor @Initialized Schema getBeamSchema();

        abstract @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> getTypeDescriptor();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFn();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFn();

        abstract @Nullable @UnknownKeyFor @Initialized Clock getClock();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getNeedsAttributes();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getNeedsMessageId();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> newBuilder(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, T> parseFn) {
            AutoValue_PubsubIO_Read.Builder<T> builder = new AutoValue_PubsubIO_Read.Builder<T>();
            ((Builder)builder).setParseFn(parseFn);
            ((Builder)builder).setPubsubClientFactory(FACTORY);
            ((Builder)builder).setNeedsAttributes(false);
            ((Builder)builder).setNeedsMessageId(false);
            return builder;
        }

        static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized PubsubMessage> newBuilder() {
            return Read.newBuilder((SerializableFunction & Serializable)x -> x);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromSubscription(@UnknownKeyFor @NonNull @Initialized String subscription) {
            return this.fromSubscription((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)subscription));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromSubscription(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> subscription) {
            if (subscription.isAccessible()) {
                PubsubSubscription.fromPath((String)subscription.get());
            }
            return this.toBuilder().setSubscriptionProvider((ValueProvider<PubsubSubscription>)ValueProvider.NestedValueProvider.of(subscription, PubsubSubscription::fromPath)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromTopic(@UnknownKeyFor @NonNull @Initialized String topic) {
            return this.fromTopic((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)topic));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> fromTopic(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> topic) {
            if (topic.isAccessible()) {
                PubsubTopic.fromPath((String)topic.get());
            }
            return this.toBuilder().setTopicProvider((ValueProvider<PubsubTopic>)ValueProvider.NestedValueProvider.of(topic, PubsubTopic::fromPath)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withClientFactory(@UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory factory) {
            return this.toBuilder().setPubsubClientFactory(factory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withTimestampAttribute(@UnknownKeyFor @NonNull @Initialized String timestampAttribute) {
            return this.toBuilder().setTimestampAttribute(timestampAttribute).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withIdAttribute(@UnknownKeyFor @NonNull @Initialized String idAttribute) {
            return this.toBuilder().setIdAttribute(idAttribute).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoderAndParseFn(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, T> parseFn) {
            return this.toBuilder().setCoder(coder).setParseFn((SerializableFunction<PubsubMessage, T>)parseFn).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Read<T> withClock(@UnknownKeyFor @NonNull @Initialized Clock clock) {
            return this.toBuilder().setClock(clock).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            if (this.getTopicProvider() == null && this.getSubscriptionProvider() == null) {
                throw new IllegalStateException("Need to set either the topic or the subscription for a PubsubIO.Read transform");
            }
            if (this.getTopicProvider() != null && this.getSubscriptionProvider() != null) {
                throw new IllegalStateException("Can't set both the topic and the subscription for a PubsubIO.Read transform");
            }
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ValueProvider.NestedValueProvider topicPath = this.getTopicProvider() == null ? null : ValueProvider.NestedValueProvider.of(this.getTopicProvider(), (SerializableFunction)new TopicPathTranslator());
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ValueProvider.NestedValueProvider subscriptionPath = this.getSubscriptionProvider() == null ? null : ValueProvider.NestedValueProvider.of(this.getSubscriptionProvider(), (SerializableFunction)new SubscriptionPathTranslator());
            PubsubUnboundedSource source = new PubsubUnboundedSource(this.getClock(), this.getPubsubClientFactory(), null, (ValueProvider<PubsubClient.TopicPath>)topicPath, (ValueProvider<PubsubClient.SubscriptionPath>)subscriptionPath, this.getTimestampAttribute(), this.getIdAttribute(), this.getNeedsAttributes(), this.getNeedsMessageId());
            PCollection read = (PCollection)((PCollection)input.apply((PTransform)source)).apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<T>(){}).via(this.getParseFn()));
            return read.setCoder(this.getCoder());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            PubsubIO.populateCommonDisplayData(builder, this.getTimestampAttribute(), this.getIdAttribute(), (ValueProvider<PubsubTopic>)this.getTopicProvider());
            builder.addIfNotNull(DisplayData.item((String)"subscription", this.getSubscriptionProvider()).withLabel("Pubsub Subscription"));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTopicProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubTopic> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPubsubClientFactory(@UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSubscriptionProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized PubsubSubscription> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTimestampAttribute(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setIdAttribute(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized PubsubMessage, T> var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBeamSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTypeDescriptor(@Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setToRowFn(@Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFromRowFn(@Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNeedsAttributes(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNeedsMessageId(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setClock(@UnknownKeyFor @NonNull @Initialized Clock var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }

    public static class PubsubTopic
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Type type;
        private final @UnknownKeyFor @NonNull @Initialized String project;
        private final @UnknownKeyFor @NonNull @Initialized String topic;

        private PubsubTopic(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String topic) {
            this.type = type;
            this.project = project;
            this.topic = topic;
        }

        public static @UnknownKeyFor @NonNull @Initialized PubsubTopic fromPath(@UnknownKeyFor @NonNull @Initialized String path) {
            String topicName;
            String projectName;
            if (path.equals(PubsubIO.TOPIC_DEV_NULL_TEST_NAME)) {
                return new PubsubTopic(Type.FAKE, "", path);
            }
            Matcher v1beta1Match = V1BETA1_TOPIC_REGEXP.matcher(path);
            if (v1beta1Match.matches()) {
                LOG.warn("Saw topic in v1beta1 format.  Topics should be in the format projects/<project_id>/topics/<topic_name>");
                projectName = v1beta1Match.group(1);
                topicName = v1beta1Match.group(2);
            } else {
                Matcher match = TOPIC_REGEXP.matcher(path);
                if (!match.matches()) {
                    throw new IllegalArgumentException("Pubsub topic is not in projects/<project_id>/topics/<topic_name> format: " + path);
                }
                projectName = match.group(1);
                topicName = match.group(2);
            }
            PubsubIO.validateProjectName(projectName);
            PubsubIO.validatePubsubName(topicName);
            return new PubsubTopic(Type.NORMAL, projectName, topicName);
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized String asV1Beta1Path() {
            if (this.type == Type.NORMAL) {
                return "/topics/" + this.project + "/" + this.topic;
            }
            return this.topic;
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized String asV1Beta2Path() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/topics/" + this.topic;
            }
            return this.topic;
        }

        public @UnknownKeyFor @NonNull @Initialized String asPath() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/topics/" + this.topic;
            }
            return this.topic;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.asPath();
        }

        private static enum Type {
            NORMAL,
            FAKE;

        }
    }

    private static class TopicPathTranslator
    implements SerializableFunction<PubsubTopic, PubsubClient.TopicPath> {
        private TopicPathTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath apply(@UnknownKeyFor @NonNull @Initialized PubsubTopic from) {
            return PubsubClient.topicPathFromName(from.project, from.topic);
        }
    }

    private static class SubscriptionPathTranslator
    implements SerializableFunction<PubsubSubscription, PubsubClient.SubscriptionPath> {
        private SubscriptionPathTranslator() {
        }

        public @UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath apply(@UnknownKeyFor @NonNull @Initialized PubsubSubscription from) {
            return PubsubClient.subscriptionPathFromName(from.project, from.subscription);
        }
    }

    public static class PubsubSubscription
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Type type;
        private final @UnknownKeyFor @NonNull @Initialized String project;
        private final @UnknownKeyFor @NonNull @Initialized String subscription;

        private PubsubSubscription(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String subscription) {
            this.type = type;
            this.project = project;
            this.subscription = subscription;
        }

        public static @UnknownKeyFor @NonNull @Initialized PubsubSubscription fromPath(@UnknownKeyFor @NonNull @Initialized String path) {
            String subscriptionName;
            String projectName;
            if (path.startsWith(PubsubIO.SUBSCRIPTION_RANDOM_TEST_PREFIX) || path.startsWith(PubsubIO.SUBSCRIPTION_STARTING_SIGNAL)) {
                return new PubsubSubscription(Type.FAKE, "", path);
            }
            Matcher v1beta1Match = V1BETA1_SUBSCRIPTION_REGEXP.matcher(path);
            if (v1beta1Match.matches()) {
                LOG.warn("Saw subscription in v1beta1 format. Subscriptions should be in the format projects/<project_id>/subscriptions/<subscription_name>");
                projectName = v1beta1Match.group(1);
                subscriptionName = v1beta1Match.group(2);
            } else {
                Matcher match = SUBSCRIPTION_REGEXP.matcher(path);
                if (!match.matches()) {
                    throw new IllegalArgumentException("Pubsub subscription is not in projects/<project_id>/subscriptions/<subscription_name> format: " + path);
                }
                projectName = match.group(1);
                subscriptionName = match.group(2);
            }
            PubsubIO.validateProjectName(projectName);
            PubsubIO.validatePubsubName(subscriptionName);
            return new PubsubSubscription(Type.NORMAL, projectName, subscriptionName);
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized String asV1Beta1Path() {
            if (this.type == Type.NORMAL) {
                return "/subscriptions/" + this.project + "/" + this.subscription;
            }
            return this.subscription;
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized String asV1Beta2Path() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/subscriptions/" + this.subscription;
            }
            return this.subscription;
        }

        public @UnknownKeyFor @NonNull @Initialized String asPath() {
            if (this.type == Type.NORMAL) {
                return "projects/" + this.project + "/subscriptions/" + this.subscription;
            }
            return this.subscription;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.asPath();
        }

        private static enum Type {
            NORMAL,
            FAKE;

        }
    }
}

