/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

abstract class RowWriterFactory<@UnknownKeyFor ElementT, @UnknownKeyFor DestinationT>
implements Serializable {
    private RowWriterFactory() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized OutputType getOutputType();

    abstract @UnknownKeyFor @NonNull @Initialized String getSourceFormat();

    abstract @UnknownKeyFor @NonNull @Initialized BigQueryRowWriter<ElementT> createRowWriter(@UnknownKeyFor @NonNull @Initialized String var1, DestinationT var2) throws @UnknownKeyFor @NonNull @Initialized Exception;

    static <ElementT, DestinationT> @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> tableRows(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeRow) {
        return new TableRowWriterFactory(toRow, toFailsafeRow);
    }

    static <ElementT, AvroT, DestinationT> @UnknownKeyFor @NonNull @Initialized AvroRowWriterFactory<ElementT, AvroT, DestinationT> avroRecords(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<ElementT>, AvroT> toAvro, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<AvroT>> writerFactory) {
        return new AvroRowWriterFactory(toAvro, writerFactory, null, null);
    }

    static final class AvroRowWriterFactory<@UnknownKeyFor ElementT, @UnknownKeyFor AvroT, @UnknownKeyFor DestinationT>
    extends RowWriterFactory<ElementT, DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<ElementT>, AvroT> toAvro;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<AvroT>> writerFactory;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;

        private AvroRowWriterFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<ElementT>, AvroT> toAvro, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<AvroT>> writerFactory, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations) {
            this.toAvro = toAvro;
            this.writerFactory = writerFactory;
            this.schemaFactory = schemaFactory;
            this.dynamicDestinations = dynamicDestinations;
        }

        @UnknownKeyFor @NonNull @Initialized AvroRowWriterFactory<ElementT, AvroT, DestinationT> prepare(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory) {
            return new AvroRowWriterFactory<ElementT, AvroT, DestinationT>(this.toAvro, this.writerFactory, schemaFactory, dynamicDestinations);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized OutputType getOutputType() {
            return OutputType.AvroGenericRecord;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized BigQueryRowWriter<ElementT> createRowWriter(@UnknownKeyFor @NonNull @Initialized String tempFilePrefix, DestinationT destination) throws @UnknownKeyFor @NonNull @Initialized Exception {
            TableSchema tableSchema = this.dynamicDestinations.getSchema(destination);
            Schema avroSchema = (Schema)this.schemaFactory.apply((Object)tableSchema);
            return new AvroRowWriter<AvroT, ElementT>(tempFilePrefix, avroSchema, this.toAvro, this.writerFactory);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized String getSourceFormat() {
            return "AVRO";
        }
    }

    static final class TableRowWriterFactory<@UnknownKeyFor ElementT, @UnknownKeyFor DestinationT>
    extends RowWriterFactory<ElementT, DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toRow;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeRow;

        private TableRowWriterFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeRow) {
            this.toRow = toRow;
            this.toFailsafeRow = toFailsafeRow;
        }

        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> getToRowFn() {
            return this.toRow;
        }

        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> getToFailsafeRowFn() {
            if (this.toFailsafeRow == null) {
                return this.toRow;
            }
            return this.toFailsafeRow;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OutputType getOutputType() {
            return OutputType.JsonTableRow;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigQueryRowWriter<ElementT> createRowWriter(@UnknownKeyFor @NonNull @Initialized String tempFilePrefix, DestinationT destination) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return new TableRowWriter<ElementT>(tempFilePrefix, this.toRow);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized String getSourceFormat() {
            return "NEWLINE_DELIMITED_JSON";
        }
    }

    static enum OutputType {
        JsonTableRow,
        AvroGenericRecord;

    }
}

