/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQueryHelper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaRetrievalException;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryQuerySourceDef
implements BigQuerySourceDef {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryQuerySourceDef.class);
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query;
    private final @UnknownKeyFor @NonNull @Initialized Boolean flattenResults;
    private final @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority;
    private final @UnknownKeyFor @NonNull @Initialized String location;
    private final @UnknownKeyFor @NonNull @Initialized String tempDatasetId;
    private final @UnknownKeyFor @NonNull @Initialized String kmsKey;
    private transient @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized JobStatistics> dryRunJobStats;

    static @UnknownKeyFor @NonNull @Initialized BigQueryQuerySourceDef create(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql, @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority, @UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized String tempDatasetId, @UnknownKeyFor @NonNull @Initialized String kmsKey) {
        return new BigQueryQuerySourceDef(bqServices, query, flattenResults, useLegacySql, priority, location, tempDatasetId, kmsKey);
    }

    private BigQueryQuerySourceDef(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql, @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority, @UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized String tempDatasetId, @UnknownKeyFor @NonNull @Initialized String kmsKey) {
        this.query = (ValueProvider)Preconditions.checkNotNull(query, (Object)"query");
        this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
        this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
        this.bqServices = bqServices;
        this.priority = priority;
        this.location = location;
        this.tempDatasetId = tempDatasetId;
        this.kmsKey = kmsKey;
        this.dryRunJobStats = new AtomicReference();
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized ClassNotFoundException, @UnknownKeyFor @NonNull @Initialized IOException {
        in.defaultReadObject();
        this.dryRunJobStats = new AtomicReference();
    }

    @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, bqOptions, this.dryRunJobStats, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.location).getQuery().getTotalBytesProcessed();
    }

    @UnknownKeyFor @NonNull @Initialized TableReference getTableReference(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions, @UnknownKeyFor @NonNull @Initialized String stepUuid) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return BigQueryQueryHelper.executeQuery(this.bqServices, bqOptions, this.dryRunJobStats, stepUuid, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.priority, this.location, this.tempDatasetId, this.kmsKey);
    }

    void cleanupTempResource(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions, @UnknownKeyFor @NonNull @Initialized String stepUuid) throws @UnknownKeyFor @NonNull @Initialized Exception {
        boolean datasetCreatedByBeam;
        Optional<String> queryTempDatasetOpt = Optional.ofNullable(this.tempDatasetId);
        TableReference tableToRemove = BigQueryResourceNaming.createTempTableReference(bqOptions.getProject(), BigQueryResourceNaming.createJobIdPrefix(bqOptions.getJobName(), stepUuid, BigQueryResourceNaming.JobType.QUERY), queryTempDatasetOpt);
        BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
        LOG.info("Deleting temporary table with query results {}", (Object)tableToRemove);
        tableService.deleteTable(tableToRemove);
        boolean bl = datasetCreatedByBeam = !queryTempDatasetOpt.isPresent();
        if (datasetCreatedByBeam) {
            LOG.info("Deleting temporary dataset with query results {}", (Object)tableToRemove.getDatasetId());
            tableService.deleteDataset(tableToRemove.getProjectId(), tableToRemove.getDatasetId());
        }
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized BigQuerySourceBase<T> toSource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        return BigQueryQuerySource.create(stepUuid, this, this.bqServices, coder, parseFn, useAvroLogicalTypes);
    }

    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    public @UnknownKeyFor @NonNull @Initialized Schema getBeamSchema(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
        try {
            JobStatistics stats = BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, bqOptions, this.dryRunJobStats, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.location);
            TableSchema tableSchema = stats.getQuery().getSchema();
            return BigQueryUtils.fromTableSchema(tableSchema);
        }
        catch (IOException | InterruptedException | NullPointerException e) {
            throw new BigQuerySchemaRetrievalException("Exception while trying to retrieve schema of query", e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery() {
        return this.query;
    }
}

