/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BigQueryDlqProvider
implements GenericDlqProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "bigquery";
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure>, @UnknownKeyFor @NonNull @Initialized PDone> newDlqTransform(@UnknownKeyFor @NonNull @Initialized String config) {
        return new DlqTransform(config);
    }

    private static class DlqTransform
    extends PTransform<PCollection<Failure>, PDone> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryDlqProvider.class);
        private final @UnknownKeyFor @NonNull @Initialized String tableSpec;

        DlqTransform(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            this.tableSpec = tableSpec;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure> input) {
            ((WriteResult)((PCollection)input.apply("Failure to Row", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TableRow.class)).via(DlqTransform::getTableRow))).apply("Write Failures to BigQuery", BigQueryIO.writeTableRows().to(this.tableSpec))).getFailedInsertsWithErr().apply("Log insert failures", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Void.class)).via((SerializableFunction & Serializable)x -> {
                LOG.error("Failed to insert error into BigQuery table. {}", x);
                return null;
            }));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static @UnknownKeyFor @NonNull @Initialized TableRow getTableRow(@UnknownKeyFor @NonNull @Initialized Failure failure) {
            Row row = Row.withSchema((Schema)Schema.builder().addByteArrayField("payload").addStringField("error").build()).withFieldValue("payload", (Object)failure.getPayload()).withFieldValue("error", (Object)failure.getError()).build();
            return BigQueryUtils.toTableRow(row);
        }
    }
}

