/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsLogger;
import org.apache.beam.sdk.metrics.SinkMetrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

class BatchedStreamingWrite<@UnknownKeyFor ErrorT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<String, TableRowInfo<ElementT>>>, PCollection<ErrorT>> {
    private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @Nullable @Initialized Void> mainOutputTag = new TupleTag("mainOutput");
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<ErrorT> failedOutputTag;
    private final @UnknownKeyFor @NonNull @Initialized AtomicCoder<ErrorT> failedOutputCoder;
    private final @UnknownKeyFor @NonNull @Initialized ErrorContainer<ErrorT> errorContainer;
    private final @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized MetricName> metricFilter;
    private @UnknownKeyFor @NonNull @Initialized Counter byteCounter = SinkMetrics.bytesWritten();
    private final @UnknownKeyFor @NonNull @Initialized boolean batchViaStateful;
    private static final @UnknownKeyFor @NonNull @Initialized Duration BATCH_MAX_BUFFERING_DURATION = Duration.millis((long)200L);

    public BatchedStreamingWrite(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized TupleTag<ErrorT> failedOutputTag, @UnknownKeyFor @NonNull @Initialized AtomicCoder<ErrorT> failedOutputCoder, @UnknownKeyFor @NonNull @Initialized ErrorContainer<ErrorT> errorContainer, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow) {
        this.bqServices = bqServices;
        this.retryPolicy = retryPolicy;
        this.failedOutputTag = failedOutputTag;
        this.failedOutputCoder = failedOutputCoder;
        this.errorContainer = errorContainer;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.metricFilter = BatchedStreamingWrite.getMetricFilter();
        this.batchViaStateful = false;
    }

    private BatchedStreamingWrite(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized TupleTag<ErrorT> failedOutputTag, @UnknownKeyFor @NonNull @Initialized AtomicCoder<ErrorT> failedOutputCoder, @UnknownKeyFor @NonNull @Initialized ErrorContainer<ErrorT> errorContainer, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized TableRow> toFailsafeTableRow, @UnknownKeyFor @NonNull @Initialized boolean batchViaStateful) {
        this.bqServices = bqServices;
        this.retryPolicy = retryPolicy;
        this.failedOutputTag = failedOutputTag;
        this.failedOutputCoder = failedOutputCoder;
        this.errorContainer = errorContainer;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.toTableRow = toTableRow;
        this.toFailsafeTableRow = toFailsafeTableRow;
        this.metricFilter = BatchedStreamingWrite.getMetricFilter();
        this.batchViaStateful = batchViaStateful;
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized MetricName> getMetricFilter() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        setBuilder.add((Object)MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_LATENCIES, BigQueryServicesImpl.API_METRIC_LABEL));
        for (String status : BigQueryServicesImpl.DatasetServiceImpl.CANONICAL_STATUS_MAP.values()) {
            setBuilder.add((Object)MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, (Map)ImmutableMap.builder().putAll(BigQueryServicesImpl.API_METRIC_LABEL).put((Object)"STATUS", (Object)status).build()));
        }
        setBuilder.add((Object)MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, (Map)ImmutableMap.builder().putAll(BigQueryServicesImpl.API_METRIC_LABEL).put((Object)"STATUS", (Object)"unknown").build()));
        return setBuilder.build();
    }

    public @UnknownKeyFor @NonNull @Initialized BatchedStreamingWrite<ErrorT, ElementT> viaDoFnFinalization() {
        return new BatchedStreamingWrite<ErrorT, ElementT>(this.bqServices, this.retryPolicy, this.failedOutputTag, this.failedOutputCoder, this.errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.toTableRow, this.toFailsafeTableRow, false);
    }

    public @UnknownKeyFor @NonNull @Initialized BatchedStreamingWrite<ErrorT, ElementT> viaStateful() {
        return new BatchedStreamingWrite<ErrorT, ElementT>(this.bqServices, this.retryPolicy, this.failedOutputTag, this.failedOutputCoder, this.errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.toTableRow, this.toFailsafeTableRow, true);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input) {
        return this.batchViaStateful ? (PCollection)input.apply((PTransform)new ViaStateful()) : (PCollection)input.apply((PTransform)new ViaBundleFinalization());
    }

    private void flushRows(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>> tableRows, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> uniqueIds, @UnknownKeyFor @NonNull @Initialized BigQueryOptions options, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<ErrorT>> failedInserts) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (!tableRows.isEmpty()) {
            try {
                long totalBytes = this.bqServices.getDatasetService(options).insertAll(tableReference, tableRows, uniqueIds, this.retryPolicy, failedInserts, this.errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds);
                this.byteCounter.inc(totalBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void reportStreamingApiLogging(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) {
        MetricsContainer processWideContainer = MetricsEnvironment.getProcessWideContainer();
        if (processWideContainer instanceof MetricsLogger) {
            MetricsLogger processWideMetricsLogger = (MetricsLogger)processWideContainer;
            processWideMetricsLogger.tryLoggingMetrics("BigQuery HTTP API Metrics: \n", this.metricFilter, (long)options.getBqStreamingApiLoggingFrequencySec().intValue() * 1000L, true);
        }
    }

    private class InsertBatchedElements
    extends DoFn<KV<ShardedKey<String>, Iterable<TableRowInfo<ElementT>>>, Void> {
        private InsertBatchedElements() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver out) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            ArrayList<FailsafeValueInSingleWindow> tableRows = new ArrayList<FailsafeValueInSingleWindow>();
            ArrayList<String> uniqueIds = new ArrayList<String>();
            for (TableRowInfo row : (Iterable)input.getValue()) {
                TableRow tableRow = (TableRow)BatchedStreamingWrite.this.toTableRow.apply(row.tableRow);
                TableRow failsafeTableRow = (TableRow)BatchedStreamingWrite.this.toFailsafeTableRow.apply(row.tableRow);
                tableRows.add(FailsafeValueInSingleWindow.of((Object)tableRow, (Instant)context.timestamp(), (BoundedWindow)window, (PaneInfo)context.pane(), (Object)failsafeTableRow));
                uniqueIds.add(row.uniqueId);
            }
            BigQueryOptions options = (BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class);
            TableReference tableReference = BigQueryHelpers.parseTableSpec((String)((ShardedKey)input.getKey()).getKey());
            ArrayList failedInserts = Lists.newArrayList();
            BatchedStreamingWrite.this.flushRows(tableReference, tableRows, uniqueIds, options, failedInserts);
            for (ValueInSingleWindow row : failedInserts) {
                out.get(BatchedStreamingWrite.this.failedOutputTag).output(row.getValue());
            }
            BatchedStreamingWrite.this.reportStreamingApiLogging(options);
        }
    }

    private class ViaStateful
    extends PTransform<PCollection<KV<String, TableRowInfo<ElementT>>>, PCollection<ErrorT>> {
        private ViaStateful() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input) {
            BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
            KvCoder inputCoder = (KvCoder)input.getCoder();
            TableRowInfoCoder valueCoder = (TableRowInfoCoder)((Object)inputCoder.getCoderArguments().get(1));
            PCollectionTuple result = (PCollectionTuple)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply((PTransform)GroupIntoBatches.ofSize((long)options.getMaxStreamingRowsToBatch()).withMaxBufferingDuration(BATCH_MAX_BUFFERING_DURATION).withShardedKey())).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of((Coder)StringUtf8Coder.of()), (Coder)IterableCoder.of((Coder)valueCoder))).apply((PTransform)ParDo.of((DoFn)new InsertBatchedElements()).withOutputTags(mainOutputTag, TupleTagList.of((TupleTag)BatchedStreamingWrite.this.failedOutputTag)));
            PCollection failedInserts = result.get(BatchedStreamingWrite.this.failedOutputTag);
            failedInserts.setCoder((Coder)BatchedStreamingWrite.this.failedOutputCoder);
            return failedInserts;
        }
    }

    @VisibleForTesting
    private class BatchAndInsertElements
    extends DoFn<KV<String, TableRowInfo<ElementT>>, Void> {
        private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>>> tableRows;
        private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> uniqueIdsForTableRows;

        private BatchAndInsertElements() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.tableRows = new HashMap<String, List<FailsafeValueInSingleWindow<TableRow, TableRow>>>();
            this.uniqueIdsForTableRows = new HashMap<String, List<String>>();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            String tableSpec = (String)element.getKey();
            TableRow tableRow = (TableRow)BatchedStreamingWrite.this.toTableRow.apply(((TableRowInfo)element.getValue()).tableRow);
            TableRow failsafeTableRow = (TableRow)BatchedStreamingWrite.this.toFailsafeTableRow.apply(((TableRowInfo)element.getValue()).tableRow);
            this.tableRows.computeIfAbsent(tableSpec, k -> new ArrayList()).add(FailsafeValueInSingleWindow.of((Object)tableRow, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)pane, (Object)failsafeTableRow));
            this.uniqueIdsForTableRows.computeIfAbsent(tableSpec, k -> new ArrayList()).add(((TableRowInfo)element.getValue()).uniqueId);
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ArrayList failedInserts = Lists.newArrayList();
            BigQueryOptions options = (BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class);
            for (Map.Entry<String, List<FailsafeValueInSingleWindow<TableRow, TableRow>>> entry : this.tableRows.entrySet()) {
                TableReference tableReference = BigQueryHelpers.parseTableSpec(entry.getKey());
                BatchedStreamingWrite.this.flushRows(tableReference, entry.getValue(), this.uniqueIdsForTableRows.get(entry.getKey()), options, failedInserts);
            }
            this.tableRows.clear();
            this.uniqueIdsForTableRows.clear();
            for (ValueInSingleWindow row : failedInserts) {
                context.output(BatchedStreamingWrite.this.failedOutputTag, row.getValue(), row.getTimestamp(), row.getWindow());
            }
            BatchedStreamingWrite.this.reportStreamingApiLogging(options);
        }
    }

    private class ViaBundleFinalization
    extends PTransform<PCollection<KV<String, TableRowInfo<ElementT>>>, PCollection<ErrorT>> {
        private ViaBundleFinalization() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<ErrorT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableRowInfo<ElementT>>> input) {
            PCollectionTuple result = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new BatchAndInsertElements()).withOutputTags(mainOutputTag, TupleTagList.of((TupleTag)BatchedStreamingWrite.this.failedOutputTag)));
            PCollection failedInserts = result.get(BatchedStreamingWrite.this.failedOutputTag);
            failedInserts.setCoder((Coder)BatchedStreamingWrite.this.failedOutputCoder);
            return failedInserts;
        }
    }
}

