/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.ReifyAsIterable;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV3;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WriteGroupedRecordsToFiles;
import org.apache.beam.sdk.io.gcp.bigquery.WritePartition;
import org.apache.beam.sdk.io.gcp.bigquery.WriteRename;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchLoads<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BatchLoads.class);
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_NUM_WRITERS_PER_BUNDLE = 20;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_FILES_PER_PARTITION = 10000;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_MAX_BYTES_PER_PARTITION = 0xB0000000000L;
    static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_MAX_FILE_SIZE = 0x40000000000L;
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_NUM_FILE_SHARDS = 0;
    static final @UnknownKeyFor @NonNull @Initialized int FILE_TRIGGERING_RECORD_COUNT = 500000;
    static final @UnknownKeyFor @NonNull @Initialized int LOAD_JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_RETRY_JOBS = 3;
    private @UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices = new BigQueryServicesImpl();
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private @UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes;
    private final @UnknownKeyFor @NonNull @Initialized boolean singletonTable;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
    private @UnknownKeyFor @NonNull @Initialized int maxNumWritersPerBundle;
    private @UnknownKeyFor @NonNull @Initialized long maxFileSize;
    private @UnknownKeyFor @NonNull @Initialized int maxFilesPerPartition;
    private @UnknownKeyFor @NonNull @Initialized long maxBytesPerPartition;
    private @UnknownKeyFor @NonNull @Initialized int numFileShards;
    private @UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency;
    private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> customGcsTempLocation;
    private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId;
    private final @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder;
    private final @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory;
    private @UnknownKeyFor @NonNull @Initialized String kmsKey;
    private @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled;
    private @UnknownKeyFor @NonNull @Initialized int maxRetryJobs = 3;

    BatchLoads( @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized boolean singletonTable, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> customGcsTempLocation, @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder, @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory, @Nullable @UnknownKeyFor @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized boolean clusteringEnabled, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        this.writeDisposition = writeDisposition;
        this.createDisposition = createDisposition;
        this.singletonTable = singletonTable;
        this.dynamicDestinations = dynamicDestinations;
        this.destinationCoder = destinationCoder;
        this.maxNumWritersPerBundle = 20;
        this.maxFileSize = 0x40000000000L;
        this.numFileShards = 0;
        this.maxFilesPerPartition = 10000;
        this.maxBytesPerPartition = 0xB0000000000L;
        this.triggeringFrequency = null;
        this.customGcsTempLocation = customGcsTempLocation;
        this.loadJobProjectId = loadJobProjectId;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.useAvroLogicalTypes = useAvroLogicalTypes;
        this.elementCoder = elementCoder;
        this.kmsKey = kmsKey;
        this.rowWriterFactory = rowWriterFactory;
        this.clusteringEnabled = clusteringEnabled;
        this.schemaUpdateOptions = Collections.emptySet();
    }

    void setSchemaUpdateOptions(@UnknownKeyFor @NonNull @Initialized Set< @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
        this.schemaUpdateOptions = schemaUpdateOptions;
    }

    void setTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices bigQueryServices) {
        this.bigQueryServices = bigQueryServices;
    }

    public @UnknownKeyFor @NonNull @Initialized int getMaxNumWritersPerBundle() {
        return this.maxNumWritersPerBundle;
    }

    public void setMaxNumWritersPerBundle(@UnknownKeyFor @NonNull @Initialized int maxNumWritersPerBundle) {
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
    }

    public void setTriggeringFrequency(@UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency) {
        this.triggeringFrequency = triggeringFrequency;
    }

    public @UnknownKeyFor @NonNull @Initialized int getMaxRetryJobs() {
        return this.maxRetryJobs;
    }

    public void setMaxRetryJobs(@UnknownKeyFor @NonNull @Initialized int maxRetryJobs) {
        this.maxRetryJobs = maxRetryJobs;
    }

    public void setNumFileShards(@UnknownKeyFor @NonNull @Initialized int numFileShards) {
        this.numFileShards = numFileShards;
    }

    @VisibleForTesting
    void setMaxFileSize(@UnknownKeyFor @NonNull @Initialized long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @VisibleForTesting
    void setMaxFilesPerPartition(@UnknownKeyFor @NonNull @Initialized int maxFilesPerPartition) {
        this.maxFilesPerPartition = maxFilesPerPartition;
    }

    @VisibleForTesting
    void setMaxBytesPerPartition(@UnknownKeyFor @NonNull @Initialized long maxBytesPerPartition) {
        this.maxBytesPerPartition = maxBytesPerPartition;
    }

    public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        String tempLocation;
        if (this.customGcsTempLocation == null) {
            tempLocation = options.getTempLocation();
        } else {
            if (!this.customGcsTempLocation.isAccessible()) {
                return;
            }
            tempLocation = (String)this.customGcsTempLocation.get();
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Write needs a GCS temp location to store temp files.This can be set by withCustomGcsTempLocation() in the Builderor through the fallback pipeline option --tempLocation.");
        if (this.bigQueryServices == null) {
            try {
                GcsPath.fromUri((String)tempLocation);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized WriteResult expandTriggered(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        Preconditions.checkArgument((this.numFileShards > 0 ? 1 : 0) != 0);
        Pipeline p = input.getPipeline();
        PCollectionView<String> loadJobIdPrefixView = this.createJobIdPrefixView(p, BigQueryResourceNaming.JobType.LOAD);
        PCollectionView<String> copyJobIdPrefixView = this.createJobIdPrefixView(p, BigQueryResourceNaming.JobType.COPY);
        PCollectionView<String> tempFilePrefixView = this.createTempFilePrefixView(p, loadJobIdPrefixView);
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.triggeringFrequency), AfterPane.elementCountAtLeast((int)500000)}))).discardingFiredPanes());
        PCollection results = this.writeShardedFiles(inputInGlobalWindow, tempFilePrefixView);
        results = (PCollection)results.apply("applyUserTrigger", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.triggeringFrequency))).discardingFiredPanes());
        TupleTag multiPartitionsTag = new TupleTag("multiPartitionsTag");
        TupleTag singlePartitionTag = new TupleTag("singlePartitionTag");
        PCollectionTuple partitions = (PCollectionTuple)((PCollection)((PCollection)((PCollection)results.apply("AttachSingletonKey", (PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), WriteBundlesToFiles.ResultCoder.of(this.destinationCoder))).apply("GroupOntoSingleton", (PTransform)GroupByKey.create())).apply("ExtractResultValues", (PTransform)Values.create())).apply("WritePartitionTriggered", (PTransform)ParDo.of(new WritePartition<DestinationT>(this.singletonTable, this.dynamicDestinations, tempFilePrefixView, this.maxFilesPerPartition, this.maxBytesPerPartition, multiPartitionsTag, singlePartitionTag, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefixView}).withOutputTags(multiPartitionsTag, TupleTagList.of((TupleTag)singlePartitionTag)));
        PCollection<KV<TableDestination, String>> tempTables = this.writeTempTables(partitions.get(multiPartitionsTag), loadJobIdPrefixView);
        ((PCollection)((PCollection)((PCollection)((PCollection)tempTables.apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))))).apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)tempTables.getCoder())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply("WriteRenameTriggered", (PTransform)ParDo.of((DoFn)new WriteRename(this.bigQueryServices, copyJobIdPrefixView, this.writeDisposition, this.createDisposition, this.maxRetryJobs, this.kmsKey)).withSideInputs(new PCollectionView[]{copyJobIdPrefixView}));
        this.writeSinglePartition(partitions.get(singlePartitionTag), loadJobIdPrefixView);
        return this.writeResult(p);
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expandUntriggered(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        Pipeline p = input.getPipeline();
        PCollectionView<String> loadJobIdPrefixView = this.createJobIdPrefixView(p, BigQueryResourceNaming.JobType.LOAD);
        PCollectionView<String> tempFilePrefixView = this.createTempFilePrefixView(p, loadJobIdPrefixView);
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes());
        PCollection<WriteBundlesToFiles.Result<DestinationT>> results = this.numFileShards == 0 ? this.writeDynamicallyShardedFiles(inputInGlobalWindow, tempFilePrefixView) : this.writeShardedFiles(inputInGlobalWindow, tempFilePrefixView);
        TupleTag multiPartitionsTag = new TupleTag<KV<ShardedKey<DestinationT>, List<String>>>("multiPartitionsTag"){};
        TupleTag singlePartitionTag = new TupleTag<KV<ShardedKey<DestinationT>, List<String>>>("singlePartitionTag"){};
        PCollectionTuple partitions = (PCollectionTuple)((PCollection)results.apply("ReifyResults", new ReifyAsIterable())).setCoder((Coder)IterableCoder.of(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder))).apply("WritePartitionUntriggered", (PTransform)ParDo.of(new WritePartition<DestinationT>(this.singletonTable, this.dynamicDestinations, tempFilePrefixView, this.maxFilesPerPartition, this.maxBytesPerPartition, multiPartitionsTag, singlePartitionTag, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefixView}).withOutputTags(multiPartitionsTag, TupleTagList.of((TupleTag)singlePartitionTag)));
        PCollection<KV<TableDestination, String>> tempTables = this.writeTempTables(partitions.get(multiPartitionsTag), loadJobIdPrefixView);
        ((PCollection)tempTables.apply("ReifyRenameInput", new ReifyAsIterable())).apply("WriteRenameUntriggered", (PTransform)ParDo.of((DoFn)new WriteRename(this.bigQueryServices, loadJobIdPrefixView, this.writeDisposition, this.createDisposition, this.maxRetryJobs, this.kmsKey)).withSideInputs(new PCollectionView[]{loadJobIdPrefixView}));
        this.writeSinglePartition(partitions.get(singlePartitionTag), loadJobIdPrefixView);
        return this.writeResult(p);
    }

    private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> createJobIdPrefixView(@UnknownKeyFor @NonNull @Initialized Pipeline p, final @UnknownKeyFor @NonNull @Initialized BigQueryResourceNaming.JobType type) {
        return (PCollectionView)((PCollection)((PCollection)p.apply("JobIdCreationRoot_" + type.toString(), (PTransform)Create.of((Object)null, (Object[])new Void[0]))).apply("CreateJobId_" + type.toString(), (PTransform)ParDo.of((DoFn)new DoFn<Void, String>(){

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                c.output((Object)BigQueryResourceNaming.createJobIdPrefix(c.getPipelineOptions().getJobName(), BigQueryHelpers.randomUUIDString(), type));
            }
        }))).apply("JobIdSideInput_" + type.toString(), (PTransform)View.asSingleton());
    }

    private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> createTempFilePrefixView(@UnknownKeyFor @NonNull @Initialized Pipeline p, final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> jobIdView) {
        return (PCollectionView)((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)"", (Object[])new String[0]))).apply("GetTempFilePrefix", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void getTempFilePrefix(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                String tempLocationRoot = BatchLoads.this.customGcsTempLocation != null ? (String)BatchLoads.this.customGcsTempLocation.get() : c.getPipelineOptions().getTempLocation();
                String tempLocation = BigQueryHelpers.resolveTempLocation(tempLocationRoot, "BigQueryWriteTemp", (String)c.sideInput(jobIdView));
                LOG.info("Writing BigQuery temporary files to {} before loading them.", (Object)tempLocation);
                c.output((Object)tempLocation);
            }
        }).withSideInputs(new PCollectionView[]{jobIdView}))).apply("TempFilePrefixView", (PTransform)View.asSingleton());
    }

    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized WriteBundlesToFiles.Result<DestinationT>> writeDynamicallyShardedFiles(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix) {
        TupleTag writtenFilesTag = new TupleTag<WriteBundlesToFiles.Result<DestinationT>>("writtenFiles"){};
        TupleTag unwrittedRecordsTag = new TupleTag<KV<ShardedKey<DestinationT>, ElementT>>("unwrittenRecords"){};
        PCollectionTuple writeBundlesTuple = (PCollectionTuple)input.apply("WriteBundlesToFiles", (PTransform)ParDo.of(new WriteBundlesToFiles<DestinationT, ElementT>(tempFilePrefix, unwrittedRecordsTag, this.maxNumWritersPerBundle, this.maxFileSize, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefix}).withOutputTags(writtenFilesTag, TupleTagList.of((TupleTag)unwrittedRecordsTag)));
        PCollection writtenFiles = writeBundlesTuple.get(writtenFilesTag).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
        PCollection unwrittenRecords = writeBundlesTuple.get(unwrittedRecordsTag).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of(this.destinationCoder), this.elementCoder));
        PCollection<WriteBundlesToFiles.Result<DestinationT>> writtenFilesGrouped = this.writeShardedRecords(unwrittenRecords, tempFilePrefix);
        return ((PCollection)PCollectionList.of((PCollection)writtenFiles).and(writtenFilesGrouped).apply("FlattenFiles", (PTransform)Flatten.pCollections())).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
    }

    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized WriteBundlesToFiles.Result<DestinationT>> writeShardedFiles(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix) {
        Preconditions.checkState((this.numFileShards > 0 ? 1 : 0) != 0);
        PCollection shardedRecords = ((PCollection)input.apply("AddShard", (PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, ElementT>, KV<ShardedKey<DestinationT>, ElementT>>(){
            @UnknownKeyFor @NonNull @Initialized int shardNumber;

            @DoFn.Setup
            public void setup() {
                this.shardNumber = ThreadLocalRandom.current().nextInt(BatchLoads.this.numFileShards);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT> element, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, ElementT>> o) {
                Object destination = element.getKey();
                o.output((Object)KV.of((Object)ShardedKey.of((Object)destination, (int)(++this.shardNumber % BatchLoads.this.numFileShards)), (Object)element.getValue()));
            }
        }))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of(this.destinationCoder), this.elementCoder));
        return this.writeShardedRecords(shardedRecords, tempFilePrefix);
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized WriteBundlesToFiles.Result<DestinationT>> writeShardedRecords(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, ElementT>> shardedRecords, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix) {
        return ((PCollection)((PCollection)shardedRecords.apply("GroupByDestination", (PTransform)GroupByKey.create())).apply("WriteGroupedRecords", (PTransform)ParDo.of(new WriteGroupedRecordsToFiles<DestinationT, ElementT>(tempFilePrefix, this.maxFileSize, this.rowWriterFactory)).withSideInputs(new PCollectionView[]{tempFilePrefix}))).setCoder(WriteBundlesToFiles.ResultCoder.of(this.destinationCoder));
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized TableDestination, @UnknownKeyFor @NonNull @Initialized String>> writeTempTables(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> jobIdTokenView) {
        ArrayList sideInputs = Lists.newArrayList((Object[])new PCollectionView[]{jobIdTokenView});
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        KvCoder partitionsCoder = KvCoder.of((Coder)ShardedKeyCoder.of((Coder)NullableCoder.of(this.destinationCoder)), (Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        DynamicDestinations<?, DestinationT> destinations = this.dynamicDestinations;
        if (this.createDisposition.equals((Object)BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED) || this.createDisposition.equals((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER)) {
            destinations = DynamicDestinationsHelpers.matchTableDynamicDestinations(destinations, this.bigQueryServices);
        }
        AtomicCoder tableDestinationCoder = this.clusteringEnabled ? TableDestinationCoderV3.of() : TableDestinationCoderV2.of();
        return ((PCollection)((PCollection)input.setCoder((Coder)partitionsCoder).apply("MultiPartitionsReshuffle", (PTransform)Reshuffle.of())).apply("MultiPartitionsWriteTables", new WriteTables<DestinationT>(true, this.bigQueryServices, jobIdTokenView, BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED, sideInputs, destinations, this.loadJobProjectId, this.maxRetryJobs, this.ignoreUnknownValues, this.kmsKey, this.rowWriterFactory.getSourceFormat(), this.useAvroLogicalTypes, this.schemaUpdateOptions))).setCoder((Coder)KvCoder.of((Coder)tableDestinationCoder, (Coder)StringUtf8Coder.of()));
    }

    void writeSinglePartition(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> loadJobIdPrefixView) {
        ArrayList sideInputs = Lists.newArrayList((Object[])new PCollectionView[]{loadJobIdPrefixView});
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        KvCoder partitionsCoder = KvCoder.of((Coder)ShardedKeyCoder.of((Coder)NullableCoder.of(this.destinationCoder)), (Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        ((PCollection)input.setCoder((Coder)partitionsCoder).apply("SinglePartitionsReshuffle", (PTransform)Reshuffle.of())).apply("SinglePartitionWriteTables", new WriteTables<DestinationT>(false, this.bigQueryServices, loadJobIdPrefixView, this.writeDisposition, this.createDisposition, sideInputs, this.dynamicDestinations, this.loadJobProjectId, this.maxRetryJobs, this.ignoreUnknownValues, this.kmsKey, this.rowWriterFactory.getSourceFormat(), this.useAvroLogicalTypes, this.schemaUpdateOptions));
    }

    private @UnknownKeyFor @NonNull @Initialized WriteResult writeResult(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        PCollection empty = (PCollection)p.apply("CreateEmptyFailedInserts", (PTransform)Create.empty((TypeDescriptor)TypeDescriptor.of(TableRow.class)));
        return WriteResult.in(p, (TupleTag<TableRow>)new TupleTag("failedInserts"), (PCollection<TableRow>)empty);
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        return this.triggeringFrequency != null ? this.expandTriggered(input) : this.expandUntriggered(input);
    }
}

