/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.core.ApiFuture;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.PullSubscriber;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteUnboundedReader_PartitionedSequencedMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetCheckpointMark;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetFinalizer;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.base.AbstractInstant;

class PubsubLiteUnboundedReader
extends UnboundedSource.UnboundedReader<SequencedMessage>
implements OffsetFinalizer {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source;
    private final @UnknownKeyFor @NonNull @Initialized CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Partition, @UnknownKeyFor @NonNull @Initialized SubscriberState> subscriberMap;
    private final @UnknownKeyFor @NonNull @Initialized CommitterProxy committerProxy;
    @GuardedBy(value="monitor.monitor")
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized PartitionedSequencedMessage> messages = new ArrayDeque<PartitionedSequencedMessage>();
    @GuardedBy(value="monitor.monitor")
    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized StatusException> permanentError = Optional.empty();

    public PubsubLiteUnboundedReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Partition, @UnknownKeyFor @NonNull @Initialized SubscriberState> subscriberMap) throws @UnknownKeyFor @NonNull @Initialized StatusException {
        this.source = source;
        this.subscriberMap = ImmutableMap.copyOf(subscriberMap);
        this.committerProxy = new CommitterProxy(subscriberMap.values(), error -> {
            CloseableMonitor.Hold h = this.monitor.enter();
            Throwable throwable = null;
            try {
                this.permanentError = Optional.of(this.permanentError.orElse((StatusException)((Object)error)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    PubsubLiteUnboundedReader.$closeResource(throwable, (AutoCloseable)h);
                }
            }
        });
        this.committerProxy.startAsync().awaitRunning();
    }

    @Override
    public void finalizeOffsets(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Partition, @UnknownKeyFor @NonNull @Initialized Offset> offsets) throws @UnknownKeyFor @NonNull @Initialized StatusException {
        ArrayList<ApiFuture> commitFutures = new ArrayList<ApiFuture>();
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            for (Partition partition : offsets.keySet()) {
                if (!this.subscriberMap.containsKey((Object)partition)) {
                    throw Status.INVALID_ARGUMENT.withDescription(String.format("Asked to finalize an offset for partition %s which was not managed by this reader.", partition)).asException();
                }
                commitFutures.add(((SubscriberState)this.subscriberMap.get((Object)partition)).committer.commitOffset(offsets.get(partition)));
            }
        }
        commitFutures.forEach(commitFuture -> ExtractStatus.addFailureHandler((ApiFuture)commitFuture, error -> {
            CloseableMonitor.Hold h = this.monitor.enter();
            Throwable throwable = null;
            try {
                if (!this.permanentError.isPresent()) {
                    this.permanentError = Optional.of(error);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    PubsubLiteUnboundedReader.$closeResource(throwable, (AutoCloseable)h);
                }
            }
        }));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.advance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.permanentError.isPresent()) {
                throw this.permanentError.get();
            }
            if (!this.messages.isEmpty()) {
                PartitionedSequencedMessage partitionedSequencedMessage = this.messages.poll();
            }
            if (!this.messages.isEmpty()) {
                this.setLastDelivered(this.messages.peek());
                boolean bl = true;
                return bl;
            }
            this.pullFromSubscribers();
            if (!this.messages.isEmpty()) {
                this.setLastDelivered(this.messages.peek());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (StatusException e) {
            throw new IOException(e);
        }
    }

    @GuardedBy(value="monitor.monitor")
    private void setLastDelivered(@UnknownKeyFor @NonNull @Initialized PartitionedSequencedMessage message) {
        SubscriberState state = (SubscriberState)this.subscriberMap.get((Object)message.partition());
        state.lastDelivered = Optional.of(Offset.of((long)message.sequencedMessage().getCursor().getOffset()));
        Timestamp timestamp = message.sequencedMessage().getPublishTime();
        state.lastDeliveredPublishTimestamp = new Instant(Timestamps.toMillis((Timestamp)timestamp));
    }

    @GuardedBy(value="monitor.monitor")
    private void pullFromSubscribers() throws @UnknownKeyFor @NonNull @Initialized StatusException {
        for (Map.Entry entry : this.subscriberMap.entrySet()) {
            for (SequencedMessage message : ((SubscriberState)entry.getValue()).subscriber.pull()) {
                this.messages.add(PartitionedSequencedMessage.of((Partition)entry.getKey(), message));
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized SequencedMessage getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.messages.isEmpty()) {
                throw new NoSuchElementException();
            }
            SequencedMessage sequencedMessage = this.messages.peek().sequencedMessage();
            return sequencedMessage;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.messages.isEmpty()) {
                throw new NoSuchElementException();
            }
            Instant instant = new Instant(Timestamps.toMillis((Timestamp)this.messages.peek().sequencedMessage().getPublishTime()));
            return instant;
        }
    }

    /*
     * Exception decompiling
     */
    public void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Instant instant = this.subscriberMap.values().stream().map(state -> state.lastDeliveredPublishTimestamp).min(AbstractInstant::compareTo).get();
            return instant;
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.subscriberMap.forEach((partition, subscriberState) -> subscriberState.lastDelivered.ifPresent(offset -> builder.put(partition, offset)));
            OffsetCheckpointMark offsetCheckpointMark = new OffsetCheckpointMark(this, (Map<Partition, Offset>)builder.build());
            return offsetCheckpointMark;
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized SequencedMessage, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
        return this.source;
    }

    @AutoValue
    static abstract class PartitionedSequencedMessage {
        PartitionedSequencedMessage() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Partition partition();

        abstract @UnknownKeyFor @NonNull @Initialized SequencedMessage sequencedMessage();

        private static @UnknownKeyFor @NonNull @Initialized PartitionedSequencedMessage of(@UnknownKeyFor @NonNull @Initialized Partition partition, @UnknownKeyFor @NonNull @Initialized SequencedMessage sequencedMessage) {
            return new AutoValue_PubsubLiteUnboundedReader_PartitionedSequencedMessage(partition, sequencedMessage);
        }
    }

    static class SubscriberState {
        @UnknownKeyFor @NonNull @Initialized Instant lastDeliveredPublishTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
        @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Offset> lastDelivered = Optional.empty();
        @UnknownKeyFor @NonNull @Initialized PullSubscriber<@UnknownKeyFor @NonNull @Initialized SequencedMessage> subscriber;
        @UnknownKeyFor @NonNull @Initialized Committer committer;

        SubscriberState() {
        }
    }

    private static class CommitterProxy
    extends ProxyService {
        private final @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized StatusException> permanentErrorSetter;

        CommitterProxy(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SubscriberState> states, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized StatusException> permanentErrorSetter) throws @UnknownKeyFor @NonNull @Initialized StatusException {
            this.permanentErrorSetter = permanentErrorSetter;
            this.addServices(states.stream().map(state -> state.committer).collect(Collectors.toList()));
        }

        protected void start() {
        }

        protected void stop() {
        }

        protected void handlePermanentError(@UnknownKeyFor @NonNull @Initialized StatusException error) {
            this.permanentErrorSetter.accept(error);
        }
    }
}

