/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.StatusException;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PublisherCache {
    private final @UnknownKeyFor @NonNull @Initialized CloseableMonitor monitor = new CloseableMonitor();
    private final @UnknownKeyFor @NonNull @Initialized Executor listenerExecutor = Executors.newSingleThreadExecutor();
    @GuardedBy(value="monitor.monitor")
    private final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized PublisherOptions, @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized PublishMetadata>> livePublishers = new HashMap();

    PublisherCache() {
    }

    @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized PublishMetadata> get(final @UnknownKeyFor @NonNull @Initialized PublisherOptions options) throws @UnknownKeyFor @NonNull @Initialized StatusException {
        Preconditions.checkArgument((boolean)options.usesCache());
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Publisher<PublishMetadata> publisher = this.livePublishers.get(options);
            if (publisher != null) {
                Publisher<PublishMetadata> publisher2 = publisher;
                return publisher2;
            }
            publisher = options.getPublisher();
            this.livePublishers.put(options, publisher);
            publisher.addListener(new ApiService.Listener(){

                public void failed(// Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized ApiService.State s, @UnknownKeyFor @NonNull @Initialized Throwable t) {
                    try (CloseableMonitor.Hold h = PublisherCache.this.monitor.enter();){
                        PublisherCache.this.livePublishers.remove(options);
                    }
                }
            }, this.listenerExecutor);
            publisher.startAsync();
            Publisher<PublishMetadata> publisher3 = publisher;
            return publisher3;
        }
    }

    @VisibleForTesting
    void set(@UnknownKeyFor @NonNull @Initialized PublisherOptions options, @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized PublishMetadata> toCache) {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.livePublishers.put(options, toCache);
        }
    }
}

