/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_TypedRead;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_Write;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BatchLoads;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.PassThroughThenCleanup;
import org.apache.beam.sdk.io.gcp.bigquery.PrepareWrite;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingInserts;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    public static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_JOB_TEMPLATE = "beam_bq_job_{TYPE}_{JOB_ID}_{STEP}_{RANDOM}";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    static final @UnknownKeyFor @NonNull @Initialized JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final @UnknownKeyFor @NonNull @Initialized String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final @UnknownKeyFor @NonNull @Initialized String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_REGEXP = "[-\\w$@]{1,1024}";
    private static final @UnknownKeyFor @NonNull @Initialized String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s):)?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{4,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@]{1,1024}");
    static final @UnknownKeyFor @NonNull @Initialized Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow> IDENTITY_FORMATTER = (SerializableFunction & Serializable)input -> input;
    static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<@UnknownKeyFor @NonNull @Initialized GenericRecord>> GENERIC_DATUM_WRITER_FACTORY = (SerializableFunction & Serializable)schema -> new GenericDatumWriter();
    private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> DEFAULT_AVRO_SCHEMA_FACTORY = new SerializableFunction<TableSchema, org.apache.avro.Schema>(){

        public @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema apply(@UnknownKeyFor @NonNull @Initialized TableSchema input) {
            return BigQueryAvroUtils.toGenericAvroSchema("root", input.getFields());
        }
    };

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new Read();
    }

    public static @UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> readTableRows() {
        return BigQueryIO.read(new TableRowParser()).withCoder((Coder<TableRow>)TableRowJsonCoder.of());
    }

    public static @UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> readTableRowsWithSchema() {
        return BigQueryIO.read(new TableRowParser()).withCoder((Coder<TableRow>)TableRowJsonCoder.of()).withBeamRowConverters((TypeDescriptor<TableRow>)TypeDescriptor.of(TableRow.class), BigQueryUtils.tableRowToBeamRow(), BigQueryUtils.tableRowFromBeamRow());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypedRead<T> read(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn) {
        return new AutoValue_BigQueryIO_TypedRead.Builder().setValidate(true).setWithTemplateCompatibility(false).setBigQueryServices(new BigQueryServicesImpl()).setParseFn(parseFn).setMethod(TypedRead.Method.DEFAULT).setUseAvroLogicalTypes(false).build();
    }

    static @UnknownKeyFor @NonNull @Initialized String getExtractDestinationUri(@UnknownKeyFor @NonNull @Initialized String extractDestinationDir) {
        return String.format("%s/%s", extractDestinationDir, "*.avro");
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> getExtractFilePaths(@UnknownKeyFor @NonNull @Initialized String extractDestinationDir, @UnknownKeyFor @NonNull @Initialized Job extractJob) throws @UnknownKeyFor @NonNull @Initialized IOException {
        JobStatistics jobStats = extractJob.getStatistics();
        List counts = jobStats.getExtract().getDestinationUriFileCounts();
        if (counts.size() != 1) {
            String errorMessage = counts.isEmpty() ? "No destination uri file count received." : String.format("More than one destination uri file count received. First two are %s, %s", counts.get(0), counts.get(1));
            throw new RuntimeException(errorMessage);
        }
        long filesCount = (Long)counts.get(0);
        ImmutableList.Builder paths = ImmutableList.builder();
        ResourceId extractDestinationDirResourceId = FileSystems.matchNewResource((String)extractDestinationDir, (boolean)true);
        for (long i = 0L; i < filesCount; ++i) {
            ResourceId filePath = extractDestinationDirResourceId.resolve(String.format("%012d%s", i, ".avro"), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            paths.add((Object)filePath);
        }
        return paths.build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_BigQueryIO_Write.Builder().setValidate(true).setBigQueryServices(new BigQueryServicesImpl()).setCreateDisposition(Write.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(Write.WriteDisposition.WRITE_EMPTY).setSchemaUpdateOptions(Collections.emptySet()).setNumFileShards(0).setMethod(Write.Method.DEFAULT).setExtendedErrorInfo(false).setSkipInvalidRows(false).setIgnoreUnknownValues(false).setIgnoreInsertIds(false).setUseAvroLogicalTypes(false).setMaxFilesPerPartition(10000).setMaxBytesPerPartition(0xB0000000000L).setOptimizeWrites(false).setUseBeamSchema(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized TableRow> writeTableRows() {
        return BigQueryIO.write().withFormatFunction(IDENTITY_FORMATTER);
    }

    @VisibleForTesting
    static void clearCreatedTables() {
        CreateTables.clearCreatedTables();
    }

    private BigQueryIO() {
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, WriteResult> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTableRef();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> getTableFunction();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> getFormatFunction();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> getFormatRecordOnFailureFunction();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized RowWriterFactory.AvroRowWriterFactory<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getAvroRowWriterFactory();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> getAvroSchemaFactory();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getUseAvroLogicalTypes();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized DynamicDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDynamicDestinations();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> getSchemaFromView();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonSchema();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTimePartitioning();

        abstract @Nullable @UnknownKeyFor @Initialized Clustering getClustering();

        abstract @UnknownKeyFor @NonNull @Initialized CreateDisposition getCreateDisposition();

        abstract @UnknownKeyFor @NonNull @Initialized WriteDisposition getWriteDisposition();

        abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaUpdateOption> getSchemaUpdateOptions();

        abstract @Nullable @UnknownKeyFor @Initialized String getTableDescription();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

        abstract @UnknownKeyFor @NonNull @Initialized BigQueryServices getBigQueryServices();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxFilesPerBundle();

        abstract @Nullable @UnknownKeyFor @Initialized Long getMaxFileSize();

        abstract @UnknownKeyFor @NonNull @Initialized int getNumFileShards();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxFilesPerPartition();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxBytesPerPartition();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getTriggeringFrequency();

        abstract @UnknownKeyFor @NonNull @Initialized Method getMethod();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getLoadJobProjectId();

        abstract @Nullable @UnknownKeyFor @Initialized InsertRetryPolicy getFailedInsertRetryPolicy();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getCustomGcsTempLocation();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getExtendedErrorInfo();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getSkipInvalidRows();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getIgnoreUnknownValues();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getIgnoreInsertIds();

        abstract @Nullable @UnknownKeyFor @Initialized String getKmsKey();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getOptimizeWrites();

        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract @UnknownKeyFor @NonNull @Initialized Boolean getUseBeamSchema();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized TableReference table) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec) {
            Preconditions.checkArgument((tableSpec != null ? 1 : 0) != 0, (Object)"tableSpec can not be null");
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> tableFunction) {
            Preconditions.checkArgument((tableFunction != null ? 1 : 0) != 0, (Object)"tableFunction can not be null");
            return this.toBuilder().setTableFunction(tableFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dynamicDestinations) {
            Preconditions.checkArgument((dynamicDestinations != null ? 1 : 0) != 0, (Object)"dynamicDestinations can not be null");
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFormatFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFormatRecordOnFailureFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> formatFunction) {
            return this.toBuilder().setFormatRecordOnFailureFunction(formatFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAvroFormatFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, @UnknownKeyFor @NonNull @Initialized GenericRecord> avroFormatFunction) {
            return this.withAvroWriter(avroFormatFunction, GENERIC_DATUM_WRITER_FACTORY);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAvroWriter(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<T>> writerFactory) {
            return this.withAvroWriter(AvroWriteRequest::getElement, writerFactory);
        }

        public <AvroT> @UnknownKeyFor @NonNull @Initialized Write<T> withAvroWriter(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, AvroT> avroFormatFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<AvroT>> writerFactory) {
            return this.toBuilder().setOptimizeWrites(true).setAvroRowWriterFactory(RowWriterFactory.avroRecords(avroFormatFunction, writerFactory)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAvroSchemaFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> avroSchemaFactory) {
            return this.toBuilder().setAvroSchemaFactory(avroSchemaFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchema(@UnknownKeyFor @NonNull @Initialized TableSchema schema) {
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(schema)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableSchema> schema) {
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.NestedValueProvider.of(schema, (SerializableFunction)new BigQueryHelpers.TableSchemaToJsonSchema()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonSchema(@UnknownKeyFor @NonNull @Initialized String jsonSchema) {
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonSchema));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonSchema) {
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return this.toBuilder().setJsonSchema(jsonSchema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchemaFromView(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> view) {
            Preconditions.checkArgument((view != null ? 1 : 0) != 0, (Object)"view can not be null");
            return this.toBuilder().setSchemaFromView(view).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTimePartitioning(@UnknownKeyFor @NonNull @Initialized TimePartitioning partitioning) {
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.withJsonTimePartitioning((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(partitioning)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTimePartitioning(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TimePartitioning> partitioning) {
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.withJsonTimePartitioning((ValueProvider<String>)ValueProvider.NestedValueProvider.of(partitioning, (SerializableFunction)new BigQueryHelpers.TimePartitioningToJson()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonTimePartitioning(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> partitioning) {
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.toBuilder().setJsonTimePartitioning(partitioning).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClustering(@UnknownKeyFor @NonNull @Initialized Clustering clustering) {
            Preconditions.checkArgument((clustering != null ? 1 : 0) != 0, (Object)"clustering can not be null");
            return this.toBuilder().setClustering(clustering).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClustering() {
            return this.toBuilder().setClustering(new Clustering()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCreateDisposition(@UnknownKeyFor @NonNull @Initialized CreateDisposition createDisposition) {
            Preconditions.checkArgument((createDisposition != null ? 1 : 0) != 0, (Object)"createDisposition can not be null");
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteDisposition(@UnknownKeyFor @NonNull @Initialized WriteDisposition writeDisposition) {
            Preconditions.checkArgument((writeDisposition != null ? 1 : 0) != 0, (Object)"writeDisposition can not be null");
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchemaUpdateOptions(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaUpdateOption> schemaUpdateOptions) {
            Preconditions.checkArgument((schemaUpdateOptions != null ? 1 : 0) != 0, (Object)"schemaUpdateOptions can not be null");
            return this.toBuilder().setSchemaUpdateOptions(schemaUpdateOptions).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTableDescription(@UnknownKeyFor @NonNull @Initialized String tableDescription) {
            Preconditions.checkArgument((tableDescription != null ? 1 : 0) != 0, (Object)"tableDescription can not be null");
            return this.toBuilder().setTableDescription(tableDescription).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFailedInsertRetryPolicy(@UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy) {
            Preconditions.checkArgument((retryPolicy != null ? 1 : 0) != 0, (Object)"retryPolicy can not be null");
            return this.toBuilder().setFailedInsertRetryPolicy(retryPolicy).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
            Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"method can not be null");
            return this.toBuilder().setMethod(method).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLoadJobProjectId(@UnknownKeyFor @NonNull @Initialized String loadJobProjectId) {
            return this.withLoadJobProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)loadJobProjectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLoadJobProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId) {
            Preconditions.checkArgument((loadJobProjectId != null ? 1 : 0) != 0, (Object)"loadJobProjectId can not be null");
            return this.toBuilder().setLoadJobProjectId(loadJobProjectId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTriggeringFrequency(@UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency) {
            Preconditions.checkArgument((triggeringFrequency != null ? 1 : 0) != 0, (Object)"triggeringFrequency can not be null");
            return this.toBuilder().setTriggeringFrequency(triggeringFrequency).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withNumFileShards(@UnknownKeyFor @NonNull @Initialized int numFileShards) {
            Preconditions.checkArgument((numFileShards > 0 ? 1 : 0) != 0, (String)"numFileShards must be > 0, but was: %s", (int)numFileShards);
            return this.toBuilder().setNumFileShards(numFileShards).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCustomGcsTempLocation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> customGcsTempLocation) {
            Preconditions.checkArgument((customGcsTempLocation != null ? 1 : 0) != 0, (Object)"customGcsTempLocation can not be null");
            return this.toBuilder().setCustomGcsTempLocation(customGcsTempLocation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withExtendedErrorInfo() {
            return this.toBuilder().setExtendedErrorInfo(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> skipInvalidRows() {
            return this.toBuilder().setSkipInvalidRows(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> ignoreUnknownValues() {
            return this.toBuilder().setIgnoreUnknownValues(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> useAvroLogicalTypes() {
            return this.toBuilder().setUseAvroLogicalTypes(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> ignoreInsertIds() {
            return this.toBuilder().setIgnoreInsertIds(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
            return this.toBuilder().setKmsKey(kmsKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> optimizedWrites() {
            return this.toBuilder().setOptimizeWrites(true).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public @UnknownKeyFor @NonNull @Initialized Write<T> useBeamSchema() {
            return this.toBuilder().setUseBeamSchema(true).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Write<T> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testServices) {
            Preconditions.checkArgument((testServices != null ? 1 : 0) != 0, (Object)"testServices can not be null");
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxFilesPerBundle(@UnknownKeyFor @NonNull @Initialized int maxFilesPerBundle) {
            Preconditions.checkArgument((maxFilesPerBundle > 0 ? 1 : 0) != 0, (String)"maxFilesPerBundle must be > 0, but was: %s", (int)maxFilesPerBundle);
            return this.toBuilder().setMaxFilesPerBundle(maxFilesPerBundle).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Write<T> withMaxFileSize(@UnknownKeyFor @NonNull @Initialized long maxFileSize) {
            Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0, (String)"maxFileSize must be > 0, but was: %s", (long)maxFileSize);
            return this.toBuilder().setMaxFileSize(maxFileSize).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Write<T> withMaxFilesPerPartition(@UnknownKeyFor @NonNull @Initialized int maxFilesPerPartition) {
            Preconditions.checkArgument((maxFilesPerPartition > 0 ? 1 : 0) != 0, (String)"maxFilesPerPartition must be > 0, but was: %s", (int)maxFilesPerPartition);
            return this.toBuilder().setMaxFilesPerPartition(maxFilesPerPartition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxBytesPerPartition(@UnknownKeyFor @NonNull @Initialized long maxBytesPerPartition) {
            Preconditions.checkArgument((maxBytesPerPartition > 0L ? 1 : 0) != 0, (String)"maxBytesPerPartition must be > 0, but was: %s", (long)maxBytesPerPartition);
            return this.toBuilder().setMaxBytesPerPartition(maxBytesPerPartition).build();
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            BigQueryOptions options = (BigQueryOptions)pipelineOptions.as(BigQueryOptions.class);
            if (this.getJsonTableRef() != null && this.getJsonTableRef().isAccessible() && this.getValidate()) {
                TableReference table = (TableReference)this.getTableWithDefaultProject(options).get();
                BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                BigQueryHelpers.verifyDatasetPresence(datasetService, table);
                if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                    BigQueryHelpers.verifyTablePresence(datasetService, table);
                }
                if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                    BigQueryHelpers.verifyTableNotExistOrEmpty(datasetService, table);
                }
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Method resolveMethod(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (this.getMethod() != Method.DEFAULT) {
                return this.getMethod();
            }
            return input.isBounded() == PCollection.IsBounded.UNBOUNDED ? Method.STREAMING_INSERTS : Method.FILE_LOADS;
        }

        public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            DynamicDestinations<T, ?> dynamicDestinations;
            Preconditions.checkArgument((this.getTableFunction() != null || this.getJsonTableRef() != null || this.getDynamicDestinations() != null ? 1 : 0) != 0, (Object)"must set the table reference of a BigQueryIO.Write transform");
            ArrayList allToArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonTableRef(), this.getTableFunction(), this.getDynamicDestinations()});
            Preconditions.checkArgument((1 == Iterables.size((Iterable)allToArgs.stream().filter(arg_0 -> ((Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"Exactly one of jsonTableRef, tableFunction, or dynamicDestinations must be set");
            ArrayList allSchemaArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonSchema(), this.getSchemaFromView(), this.getDynamicDestinations()});
            Preconditions.checkArgument((2 > Iterables.size((Iterable)allSchemaArgs.stream().filter(arg_0 -> ((Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"No more than one of jsonSchema, schemaFromView, or dynamicDestinations may be set");
            Method method = this.resolveMethod(input);
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED && method == Method.FILE_LOADS) {
                Preconditions.checkArgument((this.getTriggeringFrequency() != null ? 1 : 0) != 0, (Object)"When writing an unbounded PCollection via FILE_LOADS, triggering frequency must be specified");
            } else {
                Preconditions.checkArgument((this.getTriggeringFrequency() == null && this.getNumFileShards() == 0 ? 1 : 0) != 0, (String)"Triggering frequency or number of file shards can be specified only when writing an unbounded PCollection via FILE_LOADS, but: the collection was %s and the method was %s", (Object)input.isBounded(), (Object)((Object)method));
            }
            if (method != Method.FILE_LOADS) {
                Preconditions.checkArgument((this.getAvroRowWriterFactory() == null ? 1 : 0) != 0, (String)"Writing avro formatted data is only supported for FILE_LOADS, however the method was %s", (Object)((Object)method));
            }
            if (this.getJsonTimePartitioning() != null) {
                Preconditions.checkArgument((this.getDynamicDestinations() == null ? 1 : 0) != 0, (Object)"The supplied DynamicDestinations object can directly set TimePartitioning. There is no need to call BigQueryIO.Write.withTimePartitioning.");
                Preconditions.checkArgument((this.getTableFunction() == null ? 1 : 0) != 0, (Object)"The supplied getTableFunction object can directly set TimePartitioning. There is no need to call BigQueryIO.Write.withTimePartitioning.");
            }
            if (this.getClustering() != null && this.getClustering().getFields() != null) {
                Preconditions.checkArgument((this.getJsonTimePartitioning() != null ? 1 : 0) != 0, (Object)"Clustering fields can only be set when TimePartitioning is set.");
            }
            if ((dynamicDestinations = this.getDynamicDestinations()) == null) {
                if (this.getJsonTableRef() != null) {
                    dynamicDestinations = DynamicDestinationsHelpers.ConstantTableDestinations.fromJsonTableRef(this.getJsonTableRef(), this.getTableDescription());
                } else if (this.getTableFunction() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.TableFunctionDestinations<T>(this.getTableFunction(), this.getClustering() != null);
                }
                if (this.getJsonSchema() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations(dynamicDestinations, this.getJsonSchema());
                } else if (this.getSchemaFromView() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.SchemaFromViewDestinations<T>(dynamicDestinations, this.getSchemaFromView());
                }
                if (this.getJsonTimePartitioning() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantTimePartitioningDestinations<T>(dynamicDestinations, this.getJsonTimePartitioning(), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(this.getClustering())));
                }
            }
            return this.expandTyped(input, dynamicDestinations);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <DestinationT> @UnknownKeyFor @NonNull @Initialized WriteResult expandTyped(@UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> dynamicDestinations) {
            RowWriterFactory rowWriterFactory;
            boolean hasSchema;
            boolean optimizeWrites = this.getOptimizeWrites();
            SerializableFunction<T, TableRow> formatFunction = this.getFormatFunction();
            SerializableFunction<T, TableRow> formatRecordOnFailureFunction = this.getFormatRecordOnFailureFunction();
            RowWriterFactory.AvroRowWriterFactory<T, T, T> avroRowWriterFactory = this.getAvroRowWriterFactory();
            boolean bl = hasSchema = this.getJsonSchema() != null || this.getDynamicDestinations() != null || this.getSchemaFromView() != null;
            if (this.getUseBeamSchema().booleanValue()) {
                Preconditions.checkArgument((boolean)input.hasSchema());
                optimizeWrites = true;
                Preconditions.checkArgument((avroRowWriterFactory == null ? 1 : 0) != 0, (Object)"avro avroFormatFunction is unsupported when using Beam schemas.");
                if (formatFunction == null) {
                    formatFunction = BigQueryUtils.toTableRow(input.getToRowFunction());
                }
                TableSchema tableSchema = BigQueryUtils.toTableSchema(input.getSchema());
                dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations<T, DestinationT>(dynamicDestinations, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableSchema)));
            } else {
                Preconditions.checkArgument((this.getCreateDisposition() != CreateDisposition.CREATE_IF_NEEDED || hasSchema ? 1 : 0) != 0, (Object)"CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
            }
            Coder<DestinationT> destinationCoder = null;
            try {
                destinationCoder = dynamicDestinations.getDestinationCoderWithDefault(input.getPipeline().getCoderRegistry());
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(e);
            }
            Method method = this.resolveMethod(input);
            if (optimizeWrites) {
                if (avroRowWriterFactory != null) {
                    Preconditions.checkArgument((formatFunction == null ? 1 : 0) != 0, (Object)"Only one of withFormatFunction or withAvroFormatFunction/withAvroWriter maybe set, not both.");
                    SerializableFunction avroSchemaFactory = this.getAvroSchemaFactory();
                    if (avroSchemaFactory == null) {
                        Preconditions.checkArgument((boolean)hasSchema, (Object)"A schema must be provided if an avroFormatFunction is set but no avroSchemaFactory is defined.");
                        avroSchemaFactory = DEFAULT_AVRO_SCHEMA_FACTORY;
                    }
                    rowWriterFactory = avroRowWriterFactory.prepare(dynamicDestinations, avroSchemaFactory);
                } else {
                    if (formatFunction == null) throw new IllegalArgumentException("A function must be provided to convert the input type into a TableRow or GenericRecord. Use BigQueryIO.Write.withFormatFunction or BigQueryIO.Write.withAvroFormatFunction to provide a formatting function. A format function is not required if Beam schemas are used.");
                    rowWriterFactory = RowWriterFactory.tableRows(formatFunction, formatRecordOnFailureFunction);
                }
            } else {
                Preconditions.checkArgument((avroRowWriterFactory == null ? 1 : 0) != 0);
                Preconditions.checkArgument((formatFunction != null ? 1 : 0) != 0, (Object)"A function must be provided to convert the input type into a TableRow or GenericRecord. Use BigQueryIO.Write.withFormatFunction or BigQueryIO.Write.withAvroFormatFunction to provide a formatting function. A format function is not required if Beam schemas are used.");
                rowWriterFactory = RowWriterFactory.tableRows(formatFunction, formatRecordOnFailureFunction);
            }
            PCollection rowsWithDestination = ((PCollection)input.apply("PrepareWrite", new PrepareWrite(dynamicDestinations, SerializableFunctions.identity()))).setCoder((Coder)KvCoder.of(destinationCoder, (Coder)input.getCoder()));
            return this.continueExpandTyped(rowsWithDestination, input.getCoder(), destinationCoder, dynamicDestinations, rowWriterFactory, method);
        }

        private <DestinationT, ElementT> @UnknownKeyFor @NonNull @Initialized WriteResult continueExpandTyped(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input, @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder, @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory, @UnknownKeyFor @NonNull @Initialized Method method) {
            if (method == Method.STREAMING_INSERTS) {
                Preconditions.checkArgument((this.getWriteDisposition() != WriteDisposition.WRITE_TRUNCATE ? 1 : 0) != 0, (Object)"WriteDisposition.WRITE_TRUNCATE is not supported for an unbounded PCollection.");
                InsertRetryPolicy retryPolicy = (InsertRetryPolicy)MoreObjects.firstNonNull((Object)this.getFailedInsertRetryPolicy(), (Object)InsertRetryPolicy.alwaysRetry());
                Preconditions.checkArgument((rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.JsonTableRow ? 1 : 0) != 0, (Object)"Avro output is not supported when method == STREAMING_INSERTS");
                RowWriterFactory.TableRowWriterFactory tableRowWriterFactory = (RowWriterFactory.TableRowWriterFactory)rowWriterFactory;
                StreamingInserts<DestinationT, ElementT> streamingInserts = new StreamingInserts<DestinationT, ElementT>(this.getCreateDisposition(), dynamicDestinations, elementCoder, tableRowWriterFactory.getToRowFn(), tableRowWriterFactory.getToFailsafeRowFn()).withInsertRetryPolicy(retryPolicy).withTestServices(this.getBigQueryServices()).withExtendedErrorInfo(this.getExtendedErrorInfo()).withSkipInvalidRows(this.getSkipInvalidRows()).withIgnoreUnknownValues(this.getIgnoreUnknownValues()).withIgnoreInsertIds(this.getIgnoreInsertIds()).withKmsKey(this.getKmsKey());
                return (WriteResult)input.apply(streamingInserts);
            }
            Preconditions.checkArgument((this.getFailedInsertRetryPolicy() == null ? 1 : 0) != 0, (Object)"Record-insert retry policies are not supported when using BigQuery load jobs.");
            if (this.getUseAvroLogicalTypes()) {
                Preconditions.checkArgument((rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.AvroGenericRecord ? 1 : 0) != 0, (Object)"useAvroLogicalTypes can only be set with Avro output.");
            }
            BatchLoads<DestinationT, ElementT> batchLoads = new BatchLoads<DestinationT, ElementT>(this.getWriteDisposition(), this.getCreateDisposition(), this.getJsonTableRef() != null, dynamicDestinations, destinationCoder, this.getCustomGcsTempLocation(), this.getLoadJobProjectId(), this.getIgnoreUnknownValues(), elementCoder, rowWriterFactory, this.getKmsKey(), this.getClustering() != null, this.getUseAvroLogicalTypes());
            batchLoads.setTestServices(this.getBigQueryServices());
            if (this.getSchemaUpdateOptions() != null) {
                batchLoads.setSchemaUpdateOptions(this.getSchemaUpdateOptions());
            }
            if (this.getMaxFilesPerBundle() != null) {
                batchLoads.setMaxNumWritersPerBundle(this.getMaxFilesPerBundle());
            }
            if (this.getMaxFileSize() != null) {
                batchLoads.setMaxFileSize(this.getMaxFileSize());
            }
            batchLoads.setMaxFilesPerPartition(this.getMaxFilesPerPartition());
            batchLoads.setMaxBytesPerPartition(this.getMaxBytesPerPartition());
            if (PCollection.IsBounded.UNBOUNDED.equals((Object)input.isBounded())) {
                batchLoads.setMaxRetryJobs(1000);
            }
            batchLoads.setTriggeringFrequency(this.getTriggeringFrequency());
            batchLoads.setNumFileShards(this.getNumFileShards());
            return (WriteResult)input.apply(batchLoads);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", this.getJsonTableRef()).withLabel("Table Reference"));
            if (this.getJsonSchema() != null) {
                builder.addIfNotNull(DisplayData.item((String)"schema", this.getJsonSchema()).withLabel("Table Schema"));
            } else {
                builder.add(DisplayData.item((String)"schema", (String)"Custom Schema Function").withLabel("Table Schema"));
            }
            if (this.getTableFunction() != null) {
                builder.add(DisplayData.item((String)"tableFn", this.getTableFunction().getClass()).withLabel("Table Reference Function"));
            }
            builder.add(DisplayData.item((String)"createDisposition", (String)this.getCreateDisposition().toString()).withLabel("Table CreateDisposition")).add(DisplayData.item((String)"writeDisposition", (String)this.getWriteDisposition().toString()).withLabel("Table WriteDisposition")).add(DisplayData.item((String)"schemaUpdateOptions", (String)this.getSchemaUpdateOptions().toString()).withLabel("Table SchemaUpdateOptions")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true).addIfNotNull(DisplayData.item((String)"tableDescription", (String)this.getTableDescription()).withLabel("Table Description"));
        }

        @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTableWithDefaultProject(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
            ValueProvider<TableReference> table = this.getTable();
            if (table == null) {
                return table;
            }
            if (!table.isAccessible()) {
                LOG.info("Using a dynamic value for table input. This must contain a project in the table reference: {}", table);
                return table;
            }
            if (Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                TableReference tableRef = (TableReference)table.get();
                tableRef.setProjectId(bqOptions.getProject());
                return ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableRef)), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
            }
            return table;
        }

        public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTable() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        public static enum SchemaUpdateOption {
            ALLOW_FIELD_ADDITION,
            ALLOW_FIELD_RELAXATION;

        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonTableRef(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTableFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFormatFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFormatRecordOnFailureFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAvroRowWriterFactory(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RowWriterFactory.AvroRowWriterFactory<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAvroSchemaFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseAvroLogicalTypes(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDynamicDestinations(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchemaFromView(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonTimePartitioning(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setClustering(@UnknownKeyFor @NonNull @Initialized Clustering var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCreateDisposition(@UnknownKeyFor @NonNull @Initialized CreateDisposition var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteDisposition(@UnknownKeyFor @NonNull @Initialized WriteDisposition var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchemaUpdateOptions(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaUpdateOption> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTableDescription(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxFilesPerBundle(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxFileSize(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNumFileShards(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxFilesPerPartition(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxBytesPerPartition(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTriggeringFrequency(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMethod(@UnknownKeyFor @NonNull @Initialized Method var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLoadJobProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFailedInsertRetryPolicy(@UnknownKeyFor @NonNull @Initialized InsertRetryPolicy var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCustomGcsTempLocation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setExtendedErrorInfo(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSkipInvalidRows(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setIgnoreUnknownValues(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setIgnoreInsertIds(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKmsKey(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setOptimizeWrites(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseBeamSchema(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }

        public static enum Method {
            DEFAULT,
            FILE_LOADS,
            STREAMING_INSERTS;

        }
    }

    @AutoValue
    public static abstract class TypedRead<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private static final @UnknownKeyFor @NonNull @Initialized String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTableRef();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getFlattenResults();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getUseLegacySql();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getWithTemplateCompatibility();

        abstract @UnknownKeyFor @NonNull @Initialized BigQueryServices getBigQueryServices();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> getParseFn();

        abstract @Nullable @UnknownKeyFor @Initialized QueryPriority getQueryPriority();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueryLocation();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueryTempDataset();

        abstract @UnknownKeyFor @NonNull @Initialized Method getMethod();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> getSelectedFields();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getRowRestriction();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @Nullable @UnknownKeyFor @Initialized String getKmsKey();

        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> getTypeDescriptor();

        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract @Nullable @UnknownKeyFor @Initialized ToBeamRowFunction<T> getToBeamRowFn();

        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract @Nullable @UnknownKeyFor @Initialized FromBeamRowFunction<T> getFromBeamRowFn();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getUseAvroLogicalTypes();

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Coder<T> inferCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
            if (this.getCoder() != null) {
                return this.getCoder();
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(this.getParseFn()));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using withCoder().", e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized BigQuerySourceDef createSourceDef() {
            BigQuerySourceDef sourceDef = this.getQuery() == null ? BigQueryTableSourceDef.create(this.getBigQueryServices(), this.getTableProvider()) : BigQueryQuerySourceDef.create(this.getBigQueryServices(), this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), (QueryPriority)((Object)MoreObjects.firstNonNull((Object)((Object)this.getQueryPriority()), (Object)((Object)QueryPriority.BATCH))), this.getQueryLocation(), this.getQueryTempDataset(), this.getKmsKey());
            return sourceDef;
        }

        private @UnknownKeyFor @NonNull @Initialized BigQueryStorageQuerySource<T> createStorageQuerySource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder) {
            return BigQueryStorageQuerySource.create(stepUuid, this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), (QueryPriority)((Object)MoreObjects.firstNonNull((Object)((Object)this.getQueryPriority()), (Object)((Object)QueryPriority.BATCH))), this.getQueryLocation(), this.getQueryTempDataset(), this.getKmsKey(), this.getParseFn(), outputCoder, this.getBigQueryServices());
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            if (this.getMethod() != Method.DIRECT_READ) {
                String tempLocation = bqOptions.getTempLocation();
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Read needs a GCS temp location to store temp files.This can be set with option --tempLocation.");
                if (this.getBigQueryServices() == null) {
                    try {
                        GcsPath.fromUri((String)tempLocation);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                    }
                }
            }
            ValueProvider<TableReference> table = this.getTableProvider();
            if (this.getValidate()) {
                if (table != null) {
                    Preconditions.checkArgument((boolean)table.isAccessible(), (Object)"Cannot call validate if table is dynamically set.");
                }
                if (table != null && ((TableReference)table.get()).getProjectId() != null) {
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(bqOptions);
                    BigQueryHelpers.verifyDatasetPresence(datasetService, (TableReference)table.get());
                    BigQueryHelpers.verifyTablePresence(datasetService, (TableReference)table.get());
                } else if (this.getQuery() != null) {
                    Preconditions.checkArgument((boolean)this.getQuery().isAccessible(), (Object)"Cannot call validate if query is dynamically set.");
                    BigQueryServices.JobService jobService = this.getBigQueryServices().getJobService(bqOptions);
                    try {
                        jobService.dryRunQuery(bqOptions.getProject(), new JobConfigurationQuery().setQuery((String)this.getQuery().get()).setFlattenResults(this.getFlattenResults()).setUseLegacySql(this.getUseLegacySql()), this.getQueryLocation());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, this.getQuery().get()), e);
                    }
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(bqOptions);
                    if (this.getQueryTempDataset() != null) {
                        TableReference tempTable = new TableReference().setProjectId(bqOptions.getProject()).setDatasetId(this.getQueryTempDataset()).setTableId("dummy table");
                        BigQueryHelpers.verifyDatasetPresence(datasetService, tempTable);
                    }
                }
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            PCollection rows;
            PCollectionView jobIdTokenView;
            ValueProvider<TableReference> table = this.getTableProvider();
            if (table != null) {
                Preconditions.checkArgument((this.getQuery() == null ? 1 : 0) != 0, (Object)"from() and fromQuery() are exclusive");
                Preconditions.checkArgument((this.getQueryPriority() == null ? 1 : 0) != 0, (Object)"withQueryPriority() can only be specified when using fromQuery()");
                Preconditions.checkArgument((this.getFlattenResults() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
                Preconditions.checkArgument((this.getUseLegacySql() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
                Preconditions.checkArgument((this.getQueryTempDataset() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a temp dataset, which can only be specified when using fromQuery()");
                if (table.isAccessible() && Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    LOG.info("Project of {} not set. The value of {}.getProject() at execution time will be used.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
                }
            } else {
                Preconditions.checkArgument((this.getQuery() != null ? 1 : 0) != 0, (Object)"Either from() or fromQuery() is required");
                Preconditions.checkArgument((this.getFlattenResults() != null ? 1 : 0) != 0, (Object)"flattenResults should not be null if query is set");
                Preconditions.checkArgument((this.getUseLegacySql() != null ? 1 : 0) != 0, (Object)"useLegacySql should not be null if query is set");
            }
            Preconditions.checkArgument((this.getParseFn() != null ? 1 : 0) != 0, (Object)"A parseFn is required");
            boolean beamSchemaEnabled = false;
            if (this.getTypeDescriptor() != null && this.getToBeamRowFn() != null && this.getFromBeamRowFn() != null) {
                beamSchemaEnabled = true;
            }
            Pipeline p = input.getPipeline();
            final Coder<T> coder = this.inferCoder(p.getCoderRegistry());
            if (this.getMethod() == Method.DIRECT_READ) {
                return this.expandForDirectRead(input, coder);
            }
            Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies selected fields, which only applies when using Method.DIRECT_READ");
            Preconditions.checkArgument((this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies row restriction, which only applies when using Method.DIRECT_READ");
            final BigQuerySourceDef sourceDef = this.createSourceDef();
            if (!this.getWithTemplateCompatibility().booleanValue()) {
                String staticJobUuid = BigQueryHelpers.randomUUIDString();
                jobIdTokenView = (PCollectionView)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)staticJobUuid, (Object[])new String[0]))).apply("ViewId", (PTransform)View.asSingleton());
                rows = (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(sourceDef.toSource(staticJobUuid, coder, this.getParseFn(), this.getUseAvroLogicalTypes())));
            } else {
                PCollection jobIdTokenCollection = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                    public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized String input) {
                        return BigQueryHelpers.randomUUIDString();
                    }
                }));
                jobIdTokenView = (PCollectionView)jobIdTokenCollection.apply("ViewId", (PTransform)View.asSingleton());
                TupleTag filesTag = new TupleTag();
                final TupleTag tableSchemaTag = new TupleTag();
                PCollectionTuple tuple = (PCollectionTuple)jobIdTokenCollection.apply("RunCreateJob", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                    @DoFn.ProcessElement
                    public void processElement(/*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        String jobUuid = (String)c.element();
                        BigQuerySourceBase source = sourceDef.toSource(jobUuid, coder, this.getParseFn(), this.getUseAvroLogicalTypes());
                        BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                        BigQuerySourceBase.ExtractResult res = source.extractFiles(options);
                        LOG.info("Extract job produced {} files", (Object)res.extractedFiles.size());
                        source.cleanupTempResource(options);
                        for (ResourceId file : res.extractedFiles) {
                            c.output((Object)file.toString());
                        }
                        c.output(tableSchemaTag, (Object)BigQueryHelpers.toJsonString(res.schema));
                    }
                }).withOutputTags(filesTag, TupleTagList.of((TupleTag)tableSchemaTag)));
                tuple.get(filesTag).setCoder((Coder)StringUtf8Coder.of());
                tuple.get(tableSchemaTag).setCoder((Coder)StringUtf8Coder.of());
                final PCollectionView schemaView = (PCollectionView)tuple.get(tableSchemaTag).apply((PTransform)View.asSingleton());
                rows = ((PCollection)((PCollection)tuple.get(filesTag).apply((PTransform)Reshuffle.viaRandomKey())).apply("ReadFiles", (PTransform)ParDo.of((DoFn)new DoFn<String, T>(){

                    @DoFn.ProcessElement
                    public void processElement(/*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        TableSchema schema = BigQueryHelpers.fromJsonString((String)c.sideInput(schemaView), TableSchema.class);
                        String jobUuid = (String)c.sideInput(jobIdTokenView);
                        BigQuerySourceBase source = sourceDef.toSource(jobUuid, coder, this.getParseFn(), this.getUseAvroLogicalTypes());
                        List sources = source.createSources((List<ResourceId>)ImmutableList.of((Object)FileSystems.matchNewResource((String)((String)c.element()), (boolean)false)), schema, null);
                        Preconditions.checkArgument((sources.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one source.");
                        BoundedSource avroSource = sources.get(0);
                        BoundedSource.BoundedReader reader = avroSource.createReader(c.getPipelineOptions());
                        boolean more = reader.start();
                        while (more) {
                            c.output(reader.getCurrent());
                            more = reader.advance();
                        }
                    }
                }).withSideInputs(new PCollectionView[]{schemaView, jobIdTokenView}))).setCoder(coder);
            }
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(@UnknownKeyFor @NonNull @Initialized PassThroughThenCleanup.ContextContainer c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    List<ResourceId> extractFiles;
                    PipelineOptions options = c.getPipelineOptions();
                    BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                    String jobUuid = c.getJobId();
                    String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", jobUuid);
                    String executingProject = bqOptions.getProject();
                    JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(BigQueryResourceNaming.createJobIdPrefix(bqOptions.getJobName(), jobUuid, BigQueryResourceNaming.JobType.EXPORT));
                    Job extractJob = this.getBigQueryServices().getJobService(bqOptions).getJob(jobRef);
                    if (extractJob != null && (extractFiles = BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob)) != null && !extractFiles.isEmpty()) {
                        FileSystems.delete(extractFiles, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                    }
                }
            };
            rows = (PCollection)rows.apply(new PassThroughThenCleanup(cleanupOperation, (PCollectionView<String>)jobIdTokenView));
            if (beamSchemaEnabled) {
                BigQueryOptions bqOptions = (BigQueryOptions)p.getOptions().as(BigQueryOptions.class);
                Schema beamSchema = sourceDef.getBeamSchema(bqOptions);
                SerializableFunction toBeamRow = (SerializableFunction)this.getToBeamRowFn().apply(beamSchema);
                SerializableFunction fromBeamRow = (SerializableFunction)this.getFromBeamRowFn().apply(beamSchema);
                rows.setSchema(beamSchema, this.getTypeDescriptor(), toBeamRow, fromBeamRow);
            }
            return rows;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<T> expandForDirectRead(@UnknownKeyFor @NonNull @Initialized PBegin input, final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder) {
            PCollection rows;
            PCollectionView jobIdTokenView;
            ValueProvider<TableReference> tableProvider = this.getTableProvider();
            Pipeline p = input.getPipeline();
            if (tableProvider != null) {
                return (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(BigQueryStorageTableSource.create(tableProvider, this.getSelectedFields(), this.getRowRestriction(), this.getParseFn(), outputCoder, this.getBigQueryServices())));
            }
            Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies selected fields, which only applies when reading from a table");
            Preconditions.checkArgument((this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies row restriction, which only applies when reading from a table");
            if (!this.getWithTemplateCompatibility().booleanValue()) {
                String staticJobUuid = BigQueryHelpers.randomUUIDString();
                jobIdTokenView = (PCollectionView)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)staticJobUuid, (Object[])new String[0]))).apply("ViewId", (PTransform)View.asSingleton());
                rows = (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(this.createStorageQuerySource(staticJobUuid, outputCoder)));
            } else {
                PCollection jobIdTokenCollection = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                    public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized String input) {
                        return BigQueryHelpers.randomUUIDString();
                    }
                }));
                jobIdTokenView = (PCollectionView)jobIdTokenCollection.apply("ViewId", (PTransform)View.asSingleton());
                TupleTag readStreamsTag = new TupleTag();
                final TupleTag readSessionTag = new TupleTag();
                final TupleTag tableSchemaTag = new TupleTag();
                PCollectionTuple tuple = (PCollectionTuple)jobIdTokenCollection.apply("RunQueryJob", (PTransform)ParDo.of((DoFn)new DoFn<String, ReadStream>(){

                    @DoFn.ProcessElement
                    public void processElement(/*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        ReadSession readSession;
                        BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                        String jobUuid = (String)c.element();
                        BigQueryStorageQuerySource querySource = this.createStorageQuerySource(jobUuid, outputCoder);
                        Table queryResultTable = querySource.getTargetTable(options);
                        CreateReadSessionRequest request = CreateReadSessionRequest.newBuilder().setParent(BigQueryHelpers.toProjectResourceName(options.getProject())).setReadSession(ReadSession.newBuilder().setTable(BigQueryHelpers.toTableResourceName(queryResultTable.getTableReference())).setDataFormat(DataFormat.AVRO)).setMaxStreamCount(0).build();
                        try (BigQueryServices.StorageClient storageClient = this.getBigQueryServices().getStorageClient(options);){
                            readSession = storageClient.createReadSession(request);
                        }
                        for (ReadStream readStream : readSession.getStreamsList()) {
                            c.output((Object)readStream);
                        }
                        c.output(readSessionTag, (Object)readSession);
                        c.output(tableSchemaTag, (Object)BigQueryHelpers.toJsonString(queryResultTable.getSchema()));
                    }
                }).withOutputTags(readStreamsTag, TupleTagList.of((TupleTag)readSessionTag).and(tableSchemaTag)));
                tuple.get(readStreamsTag).setCoder((Coder)ProtoCoder.of(ReadStream.class));
                tuple.get(readSessionTag).setCoder((Coder)ProtoCoder.of(ReadSession.class));
                tuple.get(tableSchemaTag).setCoder((Coder)StringUtf8Coder.of());
                final PCollectionView readSessionView = (PCollectionView)tuple.get(readSessionTag).apply("ReadSessionView", (PTransform)View.asSingleton());
                final PCollectionView tableSchemaView = (PCollectionView)tuple.get(tableSchemaTag).apply("TableSchemaView", (PTransform)View.asSingleton());
                rows = ((PCollection)((PCollection)tuple.get(readStreamsTag).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)ParDo.of((DoFn)new DoFn<ReadStream, T>(){

                    @DoFn.ProcessElement
                    public void processElement(/*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        ReadSession readSession = (ReadSession)c.sideInput(readSessionView);
                        TableSchema tableSchema = BigQueryHelpers.fromJsonString((String)c.sideInput(tableSchemaView), TableSchema.class);
                        ReadStream readStream = (ReadStream)c.element();
                        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create(readSession, readStream, tableSchema, this.getParseFn(), outputCoder, this.getBigQueryServices());
                        BoundedSource.BoundedReader reader = streamSource.createReader(c.getPipelineOptions());
                        boolean more = reader.start();
                        while (more) {
                            c.output(reader.getCurrent());
                            more = reader.advance();
                        }
                    }
                }).withSideInputs(new PCollectionView[]{readSessionView, tableSchemaView}))).setCoder(outputCoder);
            }
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(@UnknownKeyFor @NonNull @Initialized PassThroughThenCleanup.ContextContainer c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    boolean datasetCreatedByBeam;
                    BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                    String jobUuid = c.getJobId();
                    Optional<String> queryTempDataset = Optional.ofNullable(this.getQueryTempDataset());
                    TableReference tempTable = BigQueryResourceNaming.createTempTableReference(options.getProject(), BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), jobUuid, BigQueryResourceNaming.JobType.QUERY), queryTempDataset);
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                    LOG.info("Deleting temporary table with query results {}", (Object)tempTable);
                    datasetService.deleteTable(tempTable);
                    boolean bl = datasetCreatedByBeam = !queryTempDataset.isPresent();
                    if (datasetCreatedByBeam) {
                        LOG.info("Deleting temporary dataset with query results {}", (Object)tempTable.getDatasetId());
                        datasetService.deleteDataset(tempTable.getProjectId(), tempTable.getDatasetId());
                    }
                }
            };
            return (PCollection)rows.apply(new PassThroughThenCleanup(cleanupOperation, (PCollectionView<String>)jobIdTokenView));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTable(this.getTableProvider())).withLabel("Table")).addIfNotNull(DisplayData.item((String)"query", this.getQuery()).withLabel("Query")).addIfNotNull(DisplayData.item((String)"flattenResults", (Boolean)this.getFlattenResults()).withLabel("Flatten Query Results")).addIfNotNull(DisplayData.item((String)"useLegacySql", (Boolean)this.getUseLegacySql()).withLabel("Use Legacy SQL Dialect")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true);
        }

        private void ensureFromNotCalledYet() {
            Preconditions.checkState((this.getJsonTableRef() == null && this.getQuery() == null ? 1 : 0) != 0, (Object)"from() or fromQuery() already called");
        }

        public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTableProvider() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        public @Nullable @UnknownKeyFor @Initialized TableReference getTable() {
            ValueProvider<TableReference> provider = this.getTableProvider();
            return provider == null ? null : (TableReference)provider.get();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
            return this.toBuilder().setKmsKey(kmsKey).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withBeamRowConverters(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized ToBeamRowFunction<T> toRowFn, @UnknownKeyFor @NonNull @Initialized FromBeamRowFunction<T> fromRowFn) {
            return this.toBuilder().setTypeDescriptor(typeDescriptor).setToBeamRowFn(toRowFn).setFromBeamRowFn(fromRowFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> from(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> fromQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            return this.fromQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> fromQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setQuery(query).setFlattenResults(true).setUseLegacySql(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> from(@UnknownKeyFor @NonNull @Initialized TableReference table) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withoutResultFlattening() {
            return this.toBuilder().setFlattenResults(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> usingStandardSql() {
            return this.toBuilder().setUseLegacySql(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryPriority(@UnknownKeyFor @NonNull @Initialized QueryPriority priority) {
            return this.toBuilder().setQueryPriority(priority).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryLocation(@UnknownKeyFor @NonNull @Initialized String location) {
            return this.toBuilder().setQueryLocation(location).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryTempDataset(@UnknownKeyFor @NonNull @Initialized String queryTempDatasetRef) {
            return this.toBuilder().setQueryTempDataset(queryTempDatasetRef).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
            return this.toBuilder().setMethod(method).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withSelectedFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields) {
            return this.withSelectedFields((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(selectedFields));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withSelectedFields(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFields) {
            return this.toBuilder().setSelectedFields(selectedFields).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withRowRestriction(@UnknownKeyFor @NonNull @Initialized String rowRestriction) {
            return this.withRowRestriction((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rowRestriction));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withRowRestriction(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestriction) {
            return this.toBuilder().setRowRestriction(rowRestriction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withTemplateCompatibility() {
            return this.toBuilder().setWithTemplateCompatibility(true).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testServices) {
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> useAvroLogicalTypes() {
            return this.toBuilder().setUseAvroLogicalTypes(true).build();
        }

        public static enum QueryPriority {
            INTERACTIVE,
            BATCH;

        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonTableRef(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFlattenResults(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseLegacySql(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWithTemplateCompatibility(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryPriority(@UnknownKeyFor @NonNull @Initialized QueryPriority var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryTempDataset(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMethod(@UnknownKeyFor @NonNull @Initialized Method var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSelectedFields(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRowRestriction(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized TypedRead<T> build();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKmsKey(@UnknownKeyFor @NonNull @Initialized String var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setToBeamRowFn(@UnknownKeyFor @NonNull @Initialized ToBeamRowFunction<T> var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFromBeamRowFn(@UnknownKeyFor @NonNull @Initialized FromBeamRowFunction<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseAvroLogicalTypes(@UnknownKeyFor @NonNull @Initialized Boolean var1);
        }

        static interface FromBeamRowFunction<@UnknownKeyFor T>
        extends SerializableFunction<Schema, SerializableFunction<Row, T>> {
        }

        static interface ToBeamRowFunction<@UnknownKeyFor T>
        extends SerializableFunction<Schema, SerializableFunction<T, Row>> {
        }

        public static enum Method {
            DEFAULT,
            EXPORT,
            DIRECT_READ;

        }
    }

    public static class Read
    extends PTransform<PBegin, PCollection<TableRow>> {
        private final @UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> inner;

        Read() {
            this(BigQueryIO.read(TableRowParser.INSTANCE).withCoder((Coder<TableRow>)TableRowJsonCoder.of()));
        }

        Read(@UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> inner) {
            this.inner = inner;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PCollection)input.apply(this.inner);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }

        @UnknownKeyFor @NonNull @Initialized boolean getValidate() {
            return this.inner.getValidate();
        }

        @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery() {
            return this.inner.getQuery();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testServices) {
            return new Read(this.inner.withTestServices(testServices));
        }

        public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTableProvider() {
            return this.inner.getTableProvider();
        }

        public @Nullable @UnknownKeyFor @Initialized TableReference getTable() {
            return this.inner.getTable();
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            return new Read(this.inner.from(tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec) {
            return new Read(this.inner.from(tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized TableReference table) {
            return new Read(this.inner.from(table));
        }

        public @UnknownKeyFor @NonNull @Initialized Read fromQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            return new Read(this.inner.fromQuery(query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read fromQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            return new Read(this.inner.fromQuery(query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withoutValidation() {
            return new Read(this.inner.withoutValidation());
        }

        public @UnknownKeyFor @NonNull @Initialized Read withoutResultFlattening() {
            return new Read(this.inner.withoutResultFlattening());
        }

        public @UnknownKeyFor @NonNull @Initialized Read usingStandardSql() {
            return new Read(this.inner.usingStandardSql());
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTemplateCompatibility() {
            return new Read(this.inner.withTemplateCompatibility());
        }
    }

    @VisibleForTesting
    static class TableRowParser
    implements SerializableFunction<SchemaAndRecord, TableRow> {
        public static final @UnknownKeyFor @NonNull @Initialized TableRowParser INSTANCE = new TableRowParser();

        TableRowParser() {
        }

        public @UnknownKeyFor @NonNull @Initialized TableRow apply(@UnknownKeyFor @NonNull @Initialized SchemaAndRecord schemaAndRecord) {
            return BigQueryAvroUtils.convertGenericRecordToTableRow(schemaAndRecord.getRecord(), schemaAndRecord.getTableSchema());
        }
    }
}

