/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

class SpannerAccessor
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerAccessor.class);
    private static final String USER_AGENT_PREFIX = "Apache_Beam_Java";
    private static final ConcurrentHashMap<SpannerConfig, SpannerAccessor> spannerAccessors = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SpannerConfig, AtomicInteger> refcounts = new ConcurrentHashMap();
    private final Spanner spanner;
    private final DatabaseClient databaseClient;
    private final BatchClient batchClient;
    private final DatabaseAdminClient databaseAdminClient;
    private final SpannerConfig spannerConfig;

    private SpannerAccessor(Spanner spanner, DatabaseClient databaseClient, DatabaseAdminClient databaseAdminClient, BatchClient batchClient, SpannerConfig spannerConfig) {
        this.spanner = spanner;
        this.databaseClient = databaseClient;
        this.databaseAdminClient = databaseAdminClient;
        this.batchClient = batchClient;
        this.spannerConfig = spannerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SpannerAccessor getOrCreate(SpannerConfig spannerConfig) {
        SpannerAccessor self = spannerAccessors.get(spannerConfig);
        if (self == null) {
            ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
            synchronized (concurrentHashMap) {
                self = spannerAccessors.get(spannerConfig);
                if (self == null) {
                    LOG.info("Connecting to {}", (Object)spannerConfig);
                    self = SpannerAccessor.createAndConnect(spannerConfig);
                    spannerAccessors.put(spannerConfig, self);
                    refcounts.putIfAbsent(spannerConfig, new AtomicInteger(0));
                }
            }
        }
        int refcount = refcounts.get(spannerConfig).incrementAndGet();
        LOG.debug("getOrCreate(): refcount={} for {}", (Object)refcount, (Object)spannerConfig);
        return self;
    }

    private static SpannerAccessor createAndConnect(SpannerConfig spannerConfig) {
        ValueProvider<String> host;
        ServiceFactory<Spanner, SpannerOptions> serviceFactory;
        ValueProvider<String> projectId;
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        ValueProvider<org.joda.time.Duration> commitDeadline = spannerConfig.getCommitDeadline();
        if (commitDeadline != null && ((org.joda.time.Duration)commitDeadline.get()).getMillis() > 0L) {
            UnaryCallSettings.Builder commitSettings = builder.getSpannerStubSettingsBuilder().commitSettings();
            RetrySettings.Builder commitRetrySettings = commitSettings.getRetrySettings().toBuilder();
            commitSettings.setRetrySettings(commitRetrySettings.setTotalTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setMaxRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setInitialRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).build());
        }
        if ((projectId = spannerConfig.getProjectId()) != null) {
            builder.setProjectId((String)projectId.get());
        }
        if ((serviceFactory = spannerConfig.getServiceFactory()) != null) {
            builder.setServiceFactory(serviceFactory);
        }
        if ((host = spannerConfig.getHost()) != null) {
            builder.setHost((String)host.get());
        }
        String userAgentString = "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion();
        builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"user-agent", userAgentString}));
        SpannerOptions options = builder.build();
        Spanner spanner = (Spanner)options.getService();
        String instanceId = (String)spannerConfig.getInstanceId().get();
        String databaseId = (String)spannerConfig.getDatabaseId().get();
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        BatchClient batchClient = spanner.getBatchClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
        return new SpannerAccessor(spanner, databaseClient, databaseAdminClient, batchClient, spannerConfig);
    }

    DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    BatchClient getBatchClient() {
        return this.batchClient;
    }

    DatabaseAdminClient getDatabaseAdminClient() {
        return this.databaseAdminClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int refcount = refcounts.getOrDefault(this.spannerConfig, new AtomicInteger(0)).decrementAndGet();
        LOG.debug("close(): refcount={} for {}", (Object)refcount, (Object)this.spannerConfig);
        if (refcount == 0) {
            ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
            synchronized (concurrentHashMap) {
                if (refcounts.get(this.spannerConfig).get() <= 0) {
                    spannerAccessors.remove(this.spannerConfig);
                    refcounts.remove(this.spannerConfig);
                    LOG.info("Closing {} ", (Object)this.spannerConfig);
                    this.spanner.close();
                }
            }
        }
    }

    private static class CommitDeadlineSettingInterceptor
    implements ClientInterceptor {
        private final long commitDeadlineMilliseconds;

        private CommitDeadlineSettingInterceptor(org.joda.time.Duration commitDeadline) {
            this.commitDeadlineMilliseconds = commitDeadline.getMillis();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (method.getFullMethodName().equals("google.spanner.v1.Spanner/Commit")) {
                callOptions = callOptions.withDeadlineAfter(this.commitDeadlineMilliseconds, TimeUnit.MILLISECONDS);
            }
            return next.newCall(method, callOptions);
        }
    }
}

