/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.StatusException;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

class PublisherCache {
    private final CloseableMonitor monitor = new CloseableMonitor();
    private final Executor listenerExecutor = Executors.newSingleThreadExecutor();
    @GuardedBy(value="monitor.monitor")
    private final HashMap<PublisherOptions, Publisher<PublishMetadata>> livePublishers = new HashMap();

    PublisherCache() {
    }

    Publisher<PublishMetadata> get(final PublisherOptions options) throws StatusException {
        Preconditions.checkArgument((boolean)options.usesCache());
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Publisher<PublishMetadata> publisher = this.livePublishers.get(options);
            if (publisher != null) {
                Publisher<PublishMetadata> publisher2 = publisher;
                return publisher2;
            }
            publisher = options.getPublisher();
            this.livePublishers.put(options, publisher);
            publisher.addListener(new ApiService.Listener(){

                public void failed(ApiService.State s, Throwable t) {
                    try (CloseableMonitor.Hold h = PublisherCache.this.monitor.enter();){
                        PublisherCache.this.livePublishers.remove(options);
                    }
                }
            }, this.listenerExecutor);
            publisher.startAsync();
            Publisher<PublishMetadata> publisher3 = publisher;
            return publisher3;
        }
    }

    @VisibleForTesting
    void set(PublisherOptions options, Publisher<PublishMetadata> toCache) {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.livePublishers.put(options, toCache);
        }
    }
}

