/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableStatusFunction;
import org.apache.beam.sdk.io.gcp.pubsublite.Uuid;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationOptions;
import org.apache.beam.sdk.transforms.Deduplicate;

final class AutoValue_UuidDeduplicationOptions
extends UuidDeduplicationOptions {
    private final SerializableStatusFunction<SequencedMessage, Uuid> uuidExtractor;
    private final Deduplicate.KeyedValues<Uuid, SequencedMessage> deduplicate;
    private final int hashPartitions;
    private static final long serialVersionUID = 9837489720893L;

    private AutoValue_UuidDeduplicationOptions(SerializableStatusFunction<SequencedMessage, Uuid> uuidExtractor, Deduplicate.KeyedValues<Uuid, SequencedMessage> deduplicate, int hashPartitions) {
        this.uuidExtractor = uuidExtractor;
        this.deduplicate = deduplicate;
        this.hashPartitions = hashPartitions;
    }

    @Override
    public SerializableStatusFunction<SequencedMessage, Uuid> uuidExtractor() {
        return this.uuidExtractor;
    }

    @Override
    public Deduplicate.KeyedValues<Uuid, SequencedMessage> deduplicate() {
        return this.deduplicate;
    }

    @Override
    public int hashPartitions() {
        return this.hashPartitions;
    }

    public String toString() {
        return "UuidDeduplicationOptions{uuidExtractor=" + this.uuidExtractor + ", deduplicate=" + this.deduplicate + ", hashPartitions=" + this.hashPartitions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UuidDeduplicationOptions) {
            UuidDeduplicationOptions that = (UuidDeduplicationOptions)o;
            return this.uuidExtractor.equals(that.uuidExtractor()) && this.deduplicate.equals(that.deduplicate()) && this.hashPartitions == that.hashPartitions();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.uuidExtractor.hashCode();
        h$ *= 1000003;
        h$ ^= this.deduplicate.hashCode();
        h$ *= 1000003;
        return h$ ^= this.hashPartitions;
    }

    static final class Builder
    extends UuidDeduplicationOptions.Builder {
        private SerializableStatusFunction<SequencedMessage, Uuid> uuidExtractor;
        private Deduplicate.KeyedValues<Uuid, SequencedMessage> deduplicate;
        private Integer hashPartitions;

        Builder() {
        }

        @Override
        public UuidDeduplicationOptions.Builder setUuidExtractor(SerializableStatusFunction<SequencedMessage, Uuid> uuidExtractor) {
            if (uuidExtractor == null) {
                throw new NullPointerException("Null uuidExtractor");
            }
            this.uuidExtractor = uuidExtractor;
            return this;
        }

        @Override
        public UuidDeduplicationOptions.Builder setDeduplicate(Deduplicate.KeyedValues<Uuid, SequencedMessage> deduplicate) {
            if (deduplicate == null) {
                throw new NullPointerException("Null deduplicate");
            }
            this.deduplicate = deduplicate;
            return this;
        }

        @Override
        public UuidDeduplicationOptions.Builder setHashPartitions(int hashPartitions) {
            this.hashPartitions = hashPartitions;
            return this;
        }

        @Override
        public UuidDeduplicationOptions build() {
            String missing = "";
            if (this.uuidExtractor == null) {
                missing = missing + " uuidExtractor";
            }
            if (this.deduplicate == null) {
                missing = missing + " deduplicate";
            }
            if (this.hashPartitions == null) {
                missing = missing + " hashPartitions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_UuidDeduplicationOptions(this.uuidExtractor, this.deduplicate, this.hashPartitions);
        }
    }
}

