/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.joda.time.Instant;

@DefaultCoder(value=HealthcareIOErrorCoder.class)
public class HealthcareIOError<T> {
    private T dataResource;
    private String errorMessage;
    private String stackTrace;
    private Instant observedTime;
    private int statusCode;

    HealthcareIOError(T dataResource, String errorMessage, String stackTrace, @Nullable Instant observedTime, @Nullable Integer statusCode) {
        this.dataResource = dataResource;
        this.errorMessage = errorMessage;
        this.stackTrace = stackTrace;
        if (statusCode != null) {
            this.statusCode = statusCode;
        }
        this.observedTime = observedTime != null ? observedTime : Instant.now();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Instant getObservedTime() {
        return this.observedTime;
    }

    public T getDataResource() {
        return this.dataResource;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    static <T> HealthcareIOError<T> of(T dataResource, Exception error) {
        String msg = error.getMessage();
        String stackTrace = Throwables.getStackTraceAsString((Throwable)error);
        Integer statusCode = null;
        if (error instanceof GoogleJsonResponseException) {
            statusCode = ((GoogleJsonResponseException)((Object)error)).getStatusCode();
        } else if (error instanceof HttpHealthcareApiClient.HealthcareHttpException) {
            statusCode = ((HttpHealthcareApiClient.HealthcareHttpException)error).getStatusCode();
        }
        return new HealthcareIOError<T>(dataResource, msg, stackTrace, null, statusCode);
    }
}

