/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.spi.v1.SpannerInterceptorProvider;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.joda.time.Duration;

class SpannerAccessor
implements AutoCloseable {
    private static final String USER_AGENT_PREFIX = "Apache_Beam_Java";
    private final Spanner spanner;
    private final DatabaseClient databaseClient;
    private final BatchClient batchClient;
    private final DatabaseAdminClient databaseAdminClient;

    private SpannerAccessor(Spanner spanner, DatabaseClient databaseClient, DatabaseAdminClient databaseAdminClient, BatchClient batchClient) {
        this.spanner = spanner;
        this.databaseClient = databaseClient;
        this.databaseAdminClient = databaseAdminClient;
        this.batchClient = batchClient;
    }

    static SpannerAccessor create(SpannerConfig spannerConfig) {
        ValueProvider<String> host;
        ServiceFactory<Spanner, SpannerOptions> serviceFactory;
        ValueProvider<String> projectId;
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        ValueProvider<Duration> commitDeadline = spannerConfig.getCommitDeadline();
        if (commitDeadline != null && ((Duration)commitDeadline.get()).getMillis() > 0L) {
            SpannerInterceptorProvider interceptorProvider = SpannerInterceptorProvider.createDefault().with((ClientInterceptor)new CommitDeadlineSettingInterceptor((Duration)commitDeadline.get()));
            builder.setInterceptorProvider((GrpcInterceptorProvider)interceptorProvider);
        }
        if ((projectId = spannerConfig.getProjectId()) != null) {
            builder.setProjectId((String)projectId.get());
        }
        if ((serviceFactory = spannerConfig.getServiceFactory()) != null) {
            builder.setServiceFactory(serviceFactory);
        }
        if ((host = spannerConfig.getHost()) != null) {
            builder.setHost((String)host.get());
        }
        String userAgentString = "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion();
        builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"user-agent", userAgentString}));
        SpannerOptions options = builder.build();
        Spanner spanner = (Spanner)options.getService();
        String instanceId = (String)spannerConfig.getInstanceId().get();
        String databaseId = (String)spannerConfig.getDatabaseId().get();
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        BatchClient batchClient = spanner.getBatchClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
        return new SpannerAccessor(spanner, databaseClient, databaseAdminClient, batchClient);
    }

    DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    BatchClient getBatchClient() {
        return this.batchClient;
    }

    DatabaseAdminClient getDatabaseAdminClient() {
        return this.databaseAdminClient;
    }

    @Override
    public void close() {
        this.spanner.close();
    }

    private static class CommitDeadlineSettingInterceptor
    implements ClientInterceptor {
        private final long commitDeadlineMilliseconds;

        private CommitDeadlineSettingInterceptor(Duration commitDeadline) {
            this.commitDeadlineMilliseconds = commitDeadline.getMillis();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (method.getFullMethodName().equals("google.spanner.v1.Spanner/Commit")) {
                callOptions = callOptions.withDeadlineAfter(this.commitDeadlineMilliseconds, TimeUnit.MILLISECONDS);
            }
            return next.newCall(method, callOptions);
        }
    }
}

