/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubIO_Write;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Experimental
public final class ExternalWrite
implements ExternalTransformRegistrar {
    public static final String URN = "beam:external:java:pubsub:write:v1";

    public Map<String, Class<? extends ExternalTransformBuilder>> knownBuilders() {
        return ImmutableMap.of((Object)URN, WriteBuilder.class);
    }

    private static class FormatFn
    extends SimpleFunction<byte[], PubsubMessage> {
        private FormatFn() {
        }

        public PubsubMessage apply(byte[] input) {
            try {
                com.google.pubsub.v1.PubsubMessage message = com.google.pubsub.v1.PubsubMessage.parseFrom((byte[])input);
                return new PubsubMessage(message.getData().toByteArray(), message.getAttributesMap());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Could not decode Pubsub message", e);
            }
        }
    }

    public static class WriteBuilder
    implements ExternalTransformBuilder<Configuration, PCollection<byte[]>, PDone> {
        public PTransform<PCollection<byte[]>, PDone> buildExternal(Configuration config) {
            AutoValue_PubsubIO_Write.Builder<byte[]> writeBuilder = new AutoValue_PubsubIO_Write.Builder<byte[]>();
            ((PubsubIO.Write.Builder)writeBuilder).setFormatFn(new FormatFn());
            if (config.topic != null) {
                ValueProvider.StaticValueProvider topic = ValueProvider.StaticValueProvider.of((Object)config.topic);
                ((PubsubIO.Write.Builder)writeBuilder).setTopicProvider((ValueProvider<PubsubIO.PubsubTopic>)ValueProvider.NestedValueProvider.of((ValueProvider)topic, PubsubIO.PubsubTopic::fromPath));
            }
            if (config.idAttribute != null) {
                ((PubsubIO.Write.Builder)writeBuilder).setIdAttribute(config.idAttribute);
            }
            if (config.timestampAttribute != null) {
                ((PubsubIO.Write.Builder)writeBuilder).setTimestampAttribute(config.timestampAttribute);
            }
            return ((PubsubIO.Write.Builder)writeBuilder).build();
        }
    }

    public static class Configuration {
        private String topic;
        @Nullable
        private String idAttribute;
        @Nullable
        private String timestampAttribute;

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setIdLabel(@Nullable String idAttribute) {
            this.idAttribute = idAttribute;
        }

        public void setTimestampAttribute(@Nullable String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
        }
    }
}

