/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubIO_Read;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Experimental
public final class ExternalRead
implements ExternalTransformRegistrar {
    public static final String URN = "beam:external:java:pubsub:read:v1";

    public Map<String, Class<? extends ExternalTransformBuilder>> knownBuilders() {
        return ImmutableMap.of((Object)URN, ReadBuilder.class);
    }

    private static class ParsePayloadAsPubsubMessageProto
    extends SimpleFunction<PubsubMessage, byte[]> {
        private ParsePayloadAsPubsubMessageProto() {
        }

        public byte[] apply(PubsubMessage input) {
            Map<String, String> attributes = input.getAttributeMap();
            PubsubMessage.Builder message = com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])input.getPayload()));
            if (attributes != null) {
                message.putAllAttributes(attributes);
            }
            return message.build().toByteArray();
        }
    }

    public static class ReadBuilder
    implements ExternalTransformBuilder<Configuration, PBegin, PCollection<byte[]>> {
        public PTransform<PBegin, PCollection<byte[]>> buildExternal(Configuration config) {
            AutoValue_PubsubIO_Read.Builder<byte[]> readBuilder = new AutoValue_PubsubIO_Read.Builder<byte[]>();
            ((PubsubIO.Read.Builder)readBuilder).setCoder((Coder<byte[]>)ByteArrayCoder.of());
            if (config.topic != null) {
                ValueProvider.StaticValueProvider topic = ValueProvider.StaticValueProvider.of((Object)config.topic);
                ((PubsubIO.Read.Builder)readBuilder).setTopicProvider((ValueProvider<PubsubIO.PubsubTopic>)ValueProvider.NestedValueProvider.of((ValueProvider)topic, PubsubIO.PubsubTopic::fromPath));
            }
            if (config.subscription != null) {
                ValueProvider.StaticValueProvider subscription = ValueProvider.StaticValueProvider.of((Object)config.subscription);
                ((PubsubIO.Read.Builder)readBuilder).setSubscriptionProvider((ValueProvider<PubsubIO.PubsubSubscription>)ValueProvider.NestedValueProvider.of((ValueProvider)subscription, PubsubIO.PubsubSubscription::fromPath));
            }
            if (config.idAttribute != null) {
                ((PubsubIO.Read.Builder)readBuilder).setIdAttribute(config.idAttribute);
            }
            if (config.timestampAttribute != null) {
                ((PubsubIO.Read.Builder)readBuilder).setTimestampAttribute(config.timestampAttribute);
            }
            ((PubsubIO.Read.Builder)readBuilder).setNeedsAttributes(config.needsAttributes);
            if (config.needsAttributes) {
                ((PubsubIO.Read.Builder)readBuilder).setParseFn(new ParsePayloadAsPubsubMessageProto());
            } else {
                ((PubsubIO.Read.Builder)readBuilder).setParseFn(new SimpleFunction<PubsubMessage, byte[]>(){

                    public byte[] apply(PubsubMessage input) {
                        return input.getPayload();
                    }
                });
            }
            ((PubsubIO.Read.Builder)readBuilder).setNeedsMessageId(false);
            return ((PubsubIO.Read.Builder)readBuilder).build();
        }
    }

    public static class Configuration {
        @Nullable
        private String topic;
        @Nullable
        private String subscription;
        @Nullable
        private String idAttribute;
        @Nullable
        private String timestampAttribute;
        private boolean needsAttributes;

        public void setTopic(@Nullable String topic) {
            this.topic = topic;
        }

        public void setSubscription(@Nullable String subscription) {
            this.subscription = subscription;
        }

        public void setIdLabel(@Nullable String idAttribute) {
            this.idAttribute = idAttribute;
        }

        public void setTimestampAttribute(@Nullable String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
        }

        public void setWithAttributes(Boolean needsAttributes) {
            this.needsAttributes = needsAttributes;
        }
    }
}

