/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableIO_Read;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableIO_Write;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteResult;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTracker;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class BigtableIO {
    private static final Logger LOG = LoggerFactory.getLogger(BigtableIO.class);

    @Experimental
    public static Read read() {
        return Read.create();
    }

    @Experimental
    public static Write write() {
        return Write.create();
    }

    private BigtableIO() {
    }

    private static ByteKey makeByteKey(ByteString key) {
        return ByteKey.copyFrom((ByteBuffer)key.asReadOnlyByteBuffer());
    }

    static void validateTableExists(BigtableConfig config, PipelineOptions options) {
        if (config.getValidate() && config.isDataAccessible()) {
            String tableId = (String)Preconditions.checkNotNull((Object)((String)config.getTableId().get()));
            try {
                Preconditions.checkArgument((boolean)config.getBigtableService(options).tableExists(tableId), (String)"Table %s does not exist", (Object)tableId);
            }
            catch (IOException e) {
                LOG.warn("Error checking whether table {} exists; proceeding.", (Object)tableId, (Object)e);
            }
        }
    }

    static class BigtableWriteException
    extends IOException {
        public BigtableWriteException(KV<ByteString, Iterable<Mutation>> record, Throwable cause) {
            super(String.format("Error mutating row %s with mutations %s", ((ByteString)record.getKey()).toStringUtf8(), record.getValue()), cause);
        }
    }

    private static class BigtableReader
    extends BoundedSource.BoundedReader<Row> {
        private BigtableSource source;
        private BigtableService service;
        private BigtableService.Reader reader;
        private final ByteKeyRangeTracker rangeTracker;
        private long recordsReturned;

        public BigtableReader(BigtableSource source, BigtableService service) {
            Preconditions.checkArgument((source.getRanges().size() == 1 ? 1 : 0) != 0, (Object)"source must have exactly one key range");
            this.source = source;
            this.service = service;
            this.rangeTracker = ByteKeyRangeTracker.of((ByteKeyRange)source.getRanges().get(0));
        }

        public boolean start() throws IOException {
            boolean hasRecord;
            this.reader = this.service.createReader(this.getCurrentSource());
            boolean bl = hasRecord = this.reader.start() && this.rangeTracker.tryReturnRecordAt(true, BigtableIO.makeByteKey(this.reader.getCurrentRow().getKey())) || this.rangeTracker.markDone();
            if (hasRecord) {
                ++this.recordsReturned;
            }
            return hasRecord;
        }

        public synchronized BigtableSource getCurrentSource() {
            return this.source;
        }

        public boolean advance() throws IOException {
            boolean hasRecord;
            boolean bl = hasRecord = this.reader.advance() && this.rangeTracker.tryReturnRecordAt(true, BigtableIO.makeByteKey(this.reader.getCurrentRow().getKey())) || this.rangeTracker.markDone();
            if (hasRecord) {
                ++this.recordsReturned;
            }
            return hasRecord;
        }

        public Row getCurrent() throws NoSuchElementException {
            return this.reader.getCurrentRow();
        }

        public void close() throws IOException {
            LOG.info("Closing reader after reading {} records.", (Object)this.recordsReturned);
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        public final Double getFractionConsumed() {
            return this.rangeTracker.getFractionConsumed();
        }

        public final long getSplitPointsConsumed() {
            return this.rangeTracker.getSplitPointsConsumed();
        }

        @Nullable
        public final synchronized BigtableSource splitAtFraction(double fraction) {
            BigtableSource residual;
            BigtableSource primary;
            ByteKey splitKey;
            ByteKeyRange range = this.rangeTracker.getRange();
            try {
                splitKey = range.interpolateKey(fraction);
            }
            catch (RuntimeException e) {
                LOG.info("{}: Failed to interpolate key for fraction {}.", new Object[]{range, fraction, e});
                return null;
            }
            LOG.info("Proposing to split {} at fraction {} (key {})", new Object[]{this.rangeTracker, fraction, splitKey});
            try {
                primary = this.source.withSingleRange(ByteKeyRange.of((ByteKey)range.getStartKey(), (ByteKey)splitKey));
                residual = this.source.withSingleRange(ByteKeyRange.of((ByteKey)splitKey, (ByteKey)range.getEndKey()));
            }
            catch (RuntimeException e) {
                LOG.info("{}: Interpolating for fraction {} yielded invalid split key {}.", new Object[]{this.rangeTracker.getRange(), fraction, splitKey, e});
                return null;
            }
            if (!this.rangeTracker.trySplitAtPosition(splitKey)) {
                return null;
            }
            this.source = primary;
            return residual;
        }
    }

    static class BigtableSource
    extends BoundedSource<Row> {
        private final BigtableConfig config;
        @Nullable
        private final RowFilter filter;
        private final List<ByteKeyRange> ranges;
        @Nullable
        private Long estimatedSizeBytes;
        @Nullable
        private transient List<SampleRowKeysResponse> sampleRowKeys;
        private static final long MAX_SPLIT_COUNT = 15360L;

        public BigtableSource(BigtableConfig config, @Nullable RowFilter filter, List<ByteKeyRange> ranges, @Nullable Long estimatedSizeBytes) {
            this.config = config;
            this.filter = filter;
            this.ranges = ranges;
            this.estimatedSizeBytes = estimatedSizeBytes;
        }

        public String toString() {
            return MoreObjects.toStringHelper(BigtableSource.class).add("config", (Object)this.config).add("filter", (Object)this.filter).add("ranges", this.ranges).add("estimatedSizeBytes", (Object)this.estimatedSizeBytes).toString();
        }

        protected BigtableSource withSingleRange(ByteKeyRange range) {
            Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"range can not be null");
            return new BigtableSource(this.config, this.filter, Arrays.asList(range), this.estimatedSizeBytes);
        }

        protected BigtableSource withEstimatedSizeBytes(Long estimatedSizeBytes) {
            Preconditions.checkArgument((estimatedSizeBytes != null ? 1 : 0) != 0, (Object)"estimatedSizeBytes can not be null");
            return new BigtableSource(this.config, this.filter, this.ranges, estimatedSizeBytes);
        }

        private List<SampleRowKeysResponse> getSampleRowKeys(PipelineOptions pipelineOptions) throws IOException {
            return this.config.getBigtableService(pipelineOptions).getSampleRowKeys(this);
        }

        public List<BigtableSource> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            long maximumNumberOfSplits = 4000L;
            long sizeEstimate = this.getEstimatedSizeBytes(options);
            desiredBundleSizeBytes = Math.max(sizeEstimate / maximumNumberOfSplits, desiredBundleSizeBytes);
            List<BigtableSource> splits = this.splitBasedOnSamples(desiredBundleSizeBytes, this.getSampleRowKeys(options));
            List<BigtableSource> reduced = this.reduceSplits(splits, options, 15360L);
            Collections.shuffle(reduced);
            return ImmutableList.copyOf(reduced);
        }

        @VisibleForTesting
        protected List<BigtableSource> reduceSplits(List<BigtableSource> splits, PipelineOptions options, long maxSplitCounts) throws IOException {
            int numberToCombine = (int)(((long)splits.size() + maxSplitCounts - 1L) / maxSplitCounts);
            if ((long)splits.size() < maxSplitCounts || numberToCombine < 2) {
                return new ArrayList<BigtableSource>(splits);
            }
            ArrayList<BigtableSource> reducedSplits = new ArrayList<BigtableSource>();
            List<Object> previousSourceRanges = new ArrayList<ByteKeyRange>();
            int counter = 0;
            long size = 0L;
            for (BigtableSource source : splits) {
                if (counter == numberToCombine || !BigtableSource.checkRangeAdjacency(previousSourceRanges, source.getRanges())) {
                    reducedSplits.add(new BigtableSource(this.config, this.filter, previousSourceRanges, size));
                    counter = 0;
                    size = 0L;
                    previousSourceRanges = new ArrayList();
                }
                previousSourceRanges.addAll(source.getRanges());
                previousSourceRanges = BigtableSource.mergeRanges(previousSourceRanges);
                size += source.getEstimatedSizeBytes(options);
                ++counter;
            }
            if (size > 0L) {
                reducedSplits.add(new BigtableSource(this.config, this.filter, previousSourceRanges, size));
            }
            return reducedSplits;
        }

        private static boolean checkRangeAdjacency(List<ByteKeyRange> ranges, List<ByteKeyRange> otherRanges) {
            Preconditions.checkArgument((ranges != null || otherRanges != null ? 1 : 0) != 0, (Object)"Both ranges cannot be null.");
            ImmutableList.Builder mergedRanges = ImmutableList.builder();
            if (ranges != null) {
                mergedRanges.addAll(ranges);
            }
            if (otherRanges != null) {
                mergedRanges.addAll(otherRanges);
            }
            return BigtableSource.checkRangeAdjacency((List<ByteKeyRange>)mergedRanges.build());
        }

        private static boolean checkRangeAdjacency(List<ByteKeyRange> ranges) {
            int index = 0;
            if (ranges.size() < 2) {
                return true;
            }
            ByteKey lastEndKey = ranges.get(index++).getEndKey();
            while (index < ranges.size()) {
                ByteKeyRange currentKeyRange;
                if (!lastEndKey.equals((Object)(currentKeyRange = ranges.get(index++)).getStartKey())) {
                    return false;
                }
                lastEndKey = currentKeyRange.getEndKey();
            }
            return true;
        }

        private static List<ByteKeyRange> mergeRanges(List<ByteKeyRange> ranges) {
            ArrayList<ByteKeyRange> response = new ArrayList<ByteKeyRange>();
            if (ranges.size() < 2) {
                response.add(ranges.get(0));
            } else {
                response.add(ByteKeyRange.of((ByteKey)ranges.get(0).getStartKey(), (ByteKey)ranges.get(ranges.size() - 1).getEndKey()));
            }
            return response;
        }

        private List<BigtableSource> splitBasedOnSamples(long desiredBundleSizeBytes, List<SampleRowKeysResponse> sampleRowKeys) {
            if (sampleRowKeys.isEmpty()) {
                LOG.info("Not splitting source {} because no sample row keys are available.", (Object)this);
                return Collections.singletonList(this);
            }
            LOG.info("About to split into bundles of size {} with sampleRowKeys length {} first element {}", new Object[]{desiredBundleSizeBytes, sampleRowKeys.size(), sampleRowKeys.get(0)});
            ImmutableList.Builder splits = ImmutableList.builder();
            for (ByteKeyRange range : this.ranges) {
                splits.addAll(this.splitRangeBasedOnSamples(desiredBundleSizeBytes, sampleRowKeys, range));
            }
            return splits.build();
        }

        private List<BigtableSource> splitRangeBasedOnSamples(long desiredBundleSizeBytes, List<SampleRowKeysResponse> sampleRowKeys, ByteKeyRange range) {
            ByteKey lastEndKey = ByteKey.EMPTY;
            long lastOffset = 0L;
            ImmutableList.Builder splits = ImmutableList.builder();
            for (SampleRowKeysResponse response : sampleRowKeys) {
                ByteKey splitEndKey;
                ByteKey responseEndKey = BigtableIO.makeByteKey(response.getRowKey());
                long responseOffset = response.getOffsetBytes();
                Preconditions.checkState((responseOffset >= lastOffset ? 1 : 0) != 0, (String)"Expected response byte offset %s to come after the last offset %s", (long)responseOffset, (long)lastOffset);
                if (!range.overlaps(ByteKeyRange.of((ByteKey)lastEndKey, (ByteKey)responseEndKey)).booleanValue()) {
                    lastOffset = responseOffset;
                    lastEndKey = responseEndKey;
                    continue;
                }
                ByteKey splitStartKey = lastEndKey;
                if (splitStartKey.compareTo(range.getStartKey()) < 0) {
                    splitStartKey = range.getStartKey();
                }
                if (!range.containsKey(splitEndKey = responseEndKey).booleanValue()) {
                    splitEndKey = range.getEndKey();
                }
                long sampleSizeBytes = responseOffset - lastOffset;
                List<BigtableSource> subSplits = this.splitKeyRangeIntoBundleSizedSubranges(sampleSizeBytes, desiredBundleSizeBytes, ByteKeyRange.of((ByteKey)splitStartKey, (ByteKey)splitEndKey));
                splits.addAll(subSplits);
                lastEndKey = responseEndKey;
                lastOffset = responseOffset;
            }
            if (!lastEndKey.isEmpty() && (range.getEndKey().isEmpty() || lastEndKey.compareTo(range.getEndKey()) < 0)) {
                splits.add((Object)this.withSingleRange(ByteKeyRange.of((ByteKey)lastEndKey, (ByteKey)range.getEndKey())));
            }
            ImmutableList ret = splits.build();
            LOG.info("Generated {} splits. First split: {}", (Object)ret.size(), ret.get(0));
            return ret;
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws IOException {
            if (this.estimatedSizeBytes == null) {
                this.estimatedSizeBytes = this.getEstimatedSizeBytesBasedOnSamples(this.getSampleRowKeys(options));
            }
            return this.estimatedSizeBytes;
        }

        private long getEstimatedSizeBytesBasedOnSamples(List<SampleRowKeysResponse> samples) {
            long estimatedSizeBytes = 0L;
            long lastOffset = 0L;
            ByteKey currentStartKey = ByteKey.EMPTY;
            for (SampleRowKeysResponse response : samples) {
                ByteKey currentEndKey = BigtableIO.makeByteKey(response.getRowKey());
                long currentOffset = response.getOffsetBytes();
                if (!currentStartKey.isEmpty() && currentStartKey.equals((Object)currentEndKey)) {
                    lastOffset = currentOffset;
                    continue;
                }
                for (ByteKeyRange range : this.ranges) {
                    if (!range.overlaps(ByteKeyRange.of((ByteKey)currentStartKey, (ByteKey)currentEndKey)).booleanValue()) continue;
                    estimatedSizeBytes += currentOffset - lastOffset;
                    break;
                }
                currentStartKey = currentEndKey;
                lastOffset = currentOffset;
            }
            return estimatedSizeBytes;
        }

        public BoundedSource.BoundedReader<Row> createReader(PipelineOptions options) throws IOException {
            return new BigtableReader(this, this.config.getBigtableService(options));
        }

        public void validate() {
            if (!this.config.getValidate()) {
                LOG.debug("Validation is disabled");
                return;
            }
            ValueProvider<String> tableId = this.config.getTableId();
            Preconditions.checkArgument((tableId != null && tableId.isAccessible() && !((String)tableId.get()).isEmpty() ? 1 : 0) != 0, (Object)"tableId was not supplied");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"tableId", this.config.getTableId()).withLabel("Table ID"));
            if (this.filter != null) {
                builder.add(DisplayData.item((String)"rowFilter", (String)this.filter.toString()).withLabel("Table Row Filter"));
            }
        }

        public Coder<Row> getOutputCoder() {
            return ProtoCoder.of(Row.class);
        }

        private List<BigtableSource> splitKeyRangeIntoBundleSizedSubranges(long sampleSizeBytes, long desiredBundleSizeBytes, ByteKeyRange range) {
            LOG.debug("Subsplit for sampleSizeBytes {} and desiredBundleSizeBytes {}", (Object)sampleSizeBytes, (Object)desiredBundleSizeBytes);
            if (sampleSizeBytes <= desiredBundleSizeBytes) {
                return Collections.singletonList(this.withSingleRange(ByteKeyRange.of((ByteKey)range.getStartKey(), (ByteKey)range.getEndKey())));
            }
            Preconditions.checkArgument((sampleSizeBytes > 0L ? 1 : 0) != 0, (String)"Sample size %s bytes must be greater than 0.", (long)sampleSizeBytes);
            Preconditions.checkArgument((desiredBundleSizeBytes > 0L ? 1 : 0) != 0, (String)"Desired bundle size %s bytes must be greater than 0.", (long)desiredBundleSizeBytes);
            int splitCount = (int)Math.ceil((double)sampleSizeBytes / (double)desiredBundleSizeBytes);
            List splitKeys = range.split(splitCount);
            ImmutableList.Builder splits = ImmutableList.builder();
            Iterator keys = splitKeys.iterator();
            ByteKey prev = (ByteKey)keys.next();
            while (keys.hasNext()) {
                ByteKey next = (ByteKey)keys.next();
                splits.add((Object)this.withSingleRange(ByteKeyRange.of((ByteKey)prev, (ByteKey)next)).withEstimatedSizeBytes(sampleSizeBytes / (long)splitCount));
                prev = next;
            }
            return splits.build();
        }

        public List<ByteKeyRange> getRanges() {
            return this.ranges;
        }

        public RowFilter getRowFilter() {
            return this.filter;
        }

        public ValueProvider<String> getTableId() {
            return this.config.getTableId();
        }
    }

    private static class BigtableWriterFn
    extends DoFn<KV<ByteString, Iterable<Mutation>>, BigtableWriteResult> {
        private final BigtableConfig config;
        private BigtableService.Writer bigtableWriter;
        private long recordsWritten;
        private final ConcurrentLinkedQueue<BigtableWriteException> failures;
        private Map<BoundedWindow, Long> seenWindows;

        BigtableWriterFn(BigtableConfig bigtableConfig) {
            this.config = bigtableConfig;
            this.failures = new ConcurrentLinkedQueue();
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.StartBundleContext c) throws IOException {
            if (this.bigtableWriter == null) {
                this.bigtableWriter = this.config.getBigtableService(c.getPipelineOptions()).openForWriting((String)this.config.getTableId().get());
            }
            this.recordsWritten = 0L;
            this.seenWindows = Maps.newHashMapWithExpectedSize((int)1);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) throws Exception {
            this.checkForFailures();
            this.bigtableWriter.writeRecord((KV<ByteString, Iterable<Mutation>>)((KV)c.element())).whenComplete((mutationResult, exception) -> {
                if (exception != null) {
                    this.failures.add(new BigtableWriteException((KV<ByteString, Iterable<Mutation>>)((KV)c.element()), (Throwable)exception));
                }
            });
            ++this.recordsWritten;
            this.seenWindows.compute(window, (key, count) -> (count != null ? count : 0L) + 1L);
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext c) throws Exception {
            this.bigtableWriter.flush();
            this.checkForFailures();
            LOG.debug("Wrote {} records", (Object)this.recordsWritten);
            for (Map.Entry<BoundedWindow, Long> entry : this.seenWindows.entrySet()) {
                c.output((Object)BigtableWriteResult.create(entry.getValue()), entry.getKey().maxTimestamp(), entry.getKey());
            }
        }

        @DoFn.Teardown
        public void tearDown() throws Exception {
            if (this.bigtableWriter != null) {
                this.bigtableWriter.close();
                this.bigtableWriter = null;
            }
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }

        private void checkForFailures() throws IOException {
            int i;
            if (this.failures.isEmpty()) {
                return;
            }
            StringBuilder logEntry = new StringBuilder();
            ArrayList suppressed = Lists.newArrayList();
            for (i = 0; i < 10 && !this.failures.isEmpty(); ++i) {
                BigtableWriteException exc = (BigtableWriteException)this.failures.remove();
                logEntry.append("\n").append(exc.getMessage());
                if (exc.getCause() != null) {
                    logEntry.append(": ").append(exc.getCause().getMessage());
                }
                suppressed.add(exc);
            }
            String message = String.format("At least %d errors occurred writing to Bigtable. First %d errors: %s", i + this.failures.size(), i, logEntry.toString());
            LOG.error(message);
            IOException exception = new IOException(message);
            for (BigtableWriteException e : suppressed) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
    }

    public static class WriteWithResults
    extends PTransform<PCollection<KV<ByteString, Iterable<Mutation>>>, PCollection<BigtableWriteResult>> {
        private final BigtableConfig bigtableConfig;

        WriteWithResults(BigtableConfig bigtableConfig) {
            this.bigtableConfig = bigtableConfig;
        }

        public PCollection<BigtableWriteResult> expand(PCollection<KV<ByteString, Iterable<Mutation>>> input) {
            this.bigtableConfig.validate();
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new BigtableWriterFn(this.bigtableConfig)));
        }

        public void validate(PipelineOptions options) {
            BigtableIO.validateTableExists(this.bigtableConfig, options);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.bigtableConfig.populateDisplayData(builder);
        }

        public String toString() {
            return MoreObjects.toStringHelper(WriteWithResults.class).add("config", (Object)this.bigtableConfig).toString();
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<KV<ByteString, Iterable<Mutation>>>, PDone> {
        static SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> enableBulkApiConfigurator(@Nullable SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> userConfigurator) {
            return (SerializableFunction & Serializable)optionsBuilder -> {
                if (userConfigurator != null) {
                    optionsBuilder = (BigtableOptions.Builder)userConfigurator.apply(optionsBuilder);
                }
                return optionsBuilder.setBulkOptions(optionsBuilder.build().getBulkOptions().toBuilder().setUseBulkApi(true).build());
            };
        }

        abstract BigtableConfig getBigtableConfig();

        @Deprecated
        @Nullable
        public BigtableOptions getBigtableOptions() {
            return this.getBigtableConfig().getBigtableOptions();
        }

        abstract Builder toBuilder();

        static Write create() {
            BigtableConfig config = BigtableConfig.builder().setTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"")).setValidate(true).setBigtableOptionsConfigurator(Write.enableBulkApiConfigurator(null)).build();
            return new AutoValue_BigtableIO_Write.Builder().setBigtableConfig(config).build();
        }

        public Write withProjectId(ValueProvider<String> projectId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withProjectId(projectId)).build();
        }

        public Write withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Write withInstanceId(ValueProvider<String> instanceId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withInstanceId(instanceId)).build();
        }

        public Write withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Write withTableId(ValueProvider<String> tableId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withTableId(tableId)).build();
        }

        public Write withTableId(String tableId) {
            return this.withTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableId));
        }

        @Deprecated
        public Write withBigtableOptions(BigtableOptions options) {
            Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options can not be null");
            return this.withBigtableOptions(options.toBuilder());
        }

        @Deprecated
        public Write withBigtableOptions(BigtableOptions.Builder optionsBuilder) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptions(optionsBuilder.build().toBuilder().build())).build();
        }

        public Write withBigtableOptionsConfigurator(SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> configurator) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptionsConfigurator(Write.enableBulkApiConfigurator(configurator))).build();
        }

        public Write withoutValidation() {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withValidate(false)).build();
        }

        Write withBigtableService(BigtableService bigtableService) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableService(bigtableService)).build();
        }

        @Experimental
        public WriteWithResults withWriteResults() {
            return new WriteWithResults(this.getBigtableConfig());
        }

        public PDone expand(PCollection<KV<ByteString, Iterable<Mutation>>> input) {
            input.apply((PTransform)this.withWriteResults());
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(PipelineOptions options) {
            this.withWriteResults().validate(options);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.withWriteResults().populateDisplayData(builder);
        }

        public String toString() {
            return MoreObjects.toStringHelper(Write.class).add("config", (Object)this.getBigtableConfig()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setBigtableConfig(BigtableConfig var1);

            abstract Write build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Row>> {
        abstract BigtableConfig getBigtableConfig();

        @Nullable
        abstract RowFilter getRowFilter();

        @Nullable
        public abstract List<ByteKeyRange> getKeyRanges();

        @Nullable
        public String getTableId() {
            ValueProvider<String> tableId = this.getBigtableConfig().getTableId();
            return tableId != null && tableId.isAccessible() ? (String)tableId.get() : null;
        }

        @Deprecated
        @Nullable
        public BigtableOptions getBigtableOptions() {
            return this.getBigtableConfig().getBigtableOptions();
        }

        abstract Builder toBuilder();

        static Read create() {
            BigtableConfig config = BigtableConfig.builder().setTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)"")).setValidate(true).build();
            return new AutoValue_BigtableIO_Read.Builder().setBigtableConfig(config).setKeyRanges(Arrays.asList(ByteKeyRange.ALL_KEYS)).build();
        }

        public Read withProjectId(ValueProvider<String> projectId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withProjectId(projectId)).build();
        }

        public Read withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Read withInstanceId(ValueProvider<String> instanceId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withInstanceId(instanceId)).build();
        }

        public Read withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Read withTableId(ValueProvider<String> tableId) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withTableId(tableId)).build();
        }

        public Read withTableId(String tableId) {
            return this.withTableId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableId));
        }

        @Deprecated
        public Read withBigtableOptions(BigtableOptions options) {
            Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options can not be null");
            return this.withBigtableOptions(options.toBuilder());
        }

        @Deprecated
        public Read withBigtableOptions(BigtableOptions.Builder optionsBuilder) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptions(optionsBuilder.build().toBuilder().build())).build();
        }

        public Read withBigtableOptionsConfigurator(SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> configurator) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableOptionsConfigurator(configurator)).build();
        }

        public Read withRowFilter(RowFilter filter) {
            Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"filter can not be null");
            return this.toBuilder().setRowFilter(filter).build();
        }

        public Read withKeyRange(ByteKeyRange keyRange) {
            Preconditions.checkArgument((keyRange != null ? 1 : 0) != 0, (Object)"keyRange can not be null");
            return this.toBuilder().setKeyRanges(Arrays.asList(keyRange)).build();
        }

        public Read withKeyRanges(List<ByteKeyRange> keyRanges) {
            Preconditions.checkArgument((keyRanges != null ? 1 : 0) != 0, (Object)"keyRanges can not be null");
            Preconditions.checkArgument((!keyRanges.isEmpty() ? 1 : 0) != 0, (Object)"keyRanges can not be empty");
            for (ByteKeyRange range : keyRanges) {
                Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"keyRanges cannot hold null range");
            }
            return this.toBuilder().setKeyRanges(keyRanges).build();
        }

        public Read withoutValidation() {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withValidate(false)).build();
        }

        @VisibleForTesting
        Read withBigtableService(BigtableService bigtableService) {
            BigtableConfig config = this.getBigtableConfig();
            return this.toBuilder().setBigtableConfig(config.withBigtableService(bigtableService)).build();
        }

        public PCollection<Row> expand(PBegin input) {
            this.getBigtableConfig().validate();
            BigtableSource source = new BigtableSource(this.getBigtableConfig(), this.getRowFilter(), this.getKeyRanges(), null);
            return (PCollection)input.getPipeline().apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)source));
        }

        public void validate(PipelineOptions options) {
            BigtableIO.validateTableExists(this.getBigtableConfig(), options);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getBigtableConfig().populateDisplayData(builder);
            List<ByteKeyRange> keyRanges = this.getKeyRanges();
            for (int i = 0; i < keyRanges.size() && i < 5; ++i) {
                builder.addIfNotDefault(DisplayData.item((String)("keyRange " + i), (String)keyRanges.get(i).toString()), (Object)ByteKeyRange.ALL_KEYS.toString());
            }
            if (this.getRowFilter() != null) {
                builder.add(DisplayData.item((String)"rowFilter", (String)this.getRowFilter().toString()).withLabel("Table Row Filter"));
            }
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Read.class).add("config", (Object)this.getBigtableConfig());
            for (int i = 0; i < this.getKeyRanges().size(); ++i) {
                helper.add("keyRange " + i, (Object)this.getKeyRanges().get(i));
            }
            return helper.add("filter", (Object)this.getRowFilter()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setBigtableConfig(BigtableConfig var1);

            abstract Builder setRowFilter(RowFilter var1);

            abstract Builder setKeyRanges(List<ByteKeyRange> var1);

            abstract Read build();
        }
    }
}

