/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;

class DynamicDestinationsHelpers {
    DynamicDestinationsHelpers() {
    }

    static class SchemaFromViewDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        PCollectionView<Map<String, String>> schemaView;

        SchemaFromViewDestinations(DynamicDestinations<T, TableDestination> inner, PCollectionView<Map<String, String>> schemaView) {
            super(inner);
            this.schemaView = schemaView;
        }

        @Override
        public List<PCollectionView<?>> getSideInputs() {
            return ImmutableList.builder().add(this.schemaView).build();
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            Map<String, String> mapValue = this.sideInput(this.schemaView);
            return BigQueryHelpers.fromJsonString(mapValue.get(destination.getTableSpec()), TableSchema.class);
        }
    }

    static class ConstantTimePartitioningDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        @Nullable
        private final ValueProvider<String> jsonTimePartitioning;

        ConstantTimePartitioningDestinations(DynamicDestinations<T, TableDestination> inner, ValueProvider<String> jsonTimePartitioning) {
            super(inner);
            this.jsonTimePartitioning = jsonTimePartitioning;
        }

        @Override
        public TableDestination getDestination(ValueInSingleWindow<T> element) {
            TableDestination destination = (TableDestination)super.getDestination(element);
            return new TableDestination(destination.getTableSpec(), destination.getTableDescription(), (String)this.jsonTimePartitioning.get());
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoderV2.of();
        }
    }

    static class ConstantSchemaDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        @Nullable
        private final ValueProvider<String> jsonSchema;

        ConstantSchemaDestinations(DynamicDestinations<T, TableDestination> inner, ValueProvider<String> jsonSchema) {
            super(inner);
            this.jsonSchema = jsonSchema;
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            return BigQueryHelpers.fromJsonString((String)this.jsonSchema.get(), TableSchema.class);
        }
    }

    static class DelegatingDynamicDestinations<T, DestinationT>
    extends DynamicDestinations<T, DestinationT> {
        private final DynamicDestinations<T, DestinationT> inner;

        DelegatingDynamicDestinations(DynamicDestinations<T, DestinationT> inner) {
            this.inner = inner;
        }

        @Override
        public DestinationT getDestination(ValueInSingleWindow<T> element) {
            return this.inner.getDestination(element);
        }

        @Override
        public TableSchema getSchema(DestinationT destination) {
            return this.inner.getSchema(destination);
        }

        @Override
        public TableDestination getTable(DestinationT destination) {
            return this.inner.getTable(destination);
        }

        @Override
        public Coder<DestinationT> getDestinationCoder() {
            return this.inner.getDestinationCoder();
        }
    }

    static class TableFunctionDestinations<T>
    extends DynamicDestinations<T, TableDestination> {
        private final SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;

        TableFunctionDestinations(SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
            this.tableFunction = tableFunction;
        }

        @Override
        public TableDestination getDestination(ValueInSingleWindow<T> element) {
            return (TableDestination)this.tableFunction.apply(element);
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            return null;
        }

        @Override
        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoderV2.of();
        }
    }

    static class ConstantTableDestinations<T>
    extends DynamicDestinations<T, TableDestination> {
        private final ValueProvider<String> tableSpec;
        @Nullable
        private final String tableDescription;

        ConstantTableDestinations(ValueProvider<String> tableSpec, @Nullable String tableDescription) {
            this.tableSpec = tableSpec;
            this.tableDescription = tableDescription;
        }

        static <T> ConstantTableDestinations<T> fromTableSpec(ValueProvider<String> tableSpec, String tableDescription) {
            return new ConstantTableDestinations<T>(tableSpec, tableDescription);
        }

        static <T> ConstantTableDestinations<T> fromJsonTableRef(ValueProvider<String> jsonTableRef, String tableDescription) {
            return new ConstantTableDestinations<T>((ValueProvider<String>)ValueProvider.NestedValueProvider.of(jsonTableRef, (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableSpec()), tableDescription);
        }

        @Override
        public TableDestination getDestination(ValueInSingleWindow<T> element) {
            return new TableDestination((String)this.tableSpec.get(), this.tableDescription);
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            return null;
        }

        @Override
        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoder.of();
        }
    }
}

