/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertErrorCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.GenerateShardedTable;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingWriteFn;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TagWithUniqueIds;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;

public class StreamingWriteTables<ElementT>
extends PTransform<PCollection<KV<TableDestination, ElementT>>, WriteResult> {
    private BigQueryServices bigQueryServices;
    private InsertRetryPolicy retryPolicy;
    private boolean extendedErrorInfo;
    private static final String FAILED_INSERTS_TAG_ID = "failedInserts";
    private final boolean skipInvalidRows;
    private final boolean ignoreUnknownValues;
    private final boolean ignoreInsertIds;
    private final Coder<ElementT> elementCoder;
    private final SerializableFunction<ElementT, TableRow> toTableRow;

    public StreamingWriteTables() {
        this(new BigQueryServicesImpl(), InsertRetryPolicy.alwaysRetry(), false, false, false, false, null, null);
    }

    private StreamingWriteTables(BigQueryServices bigQueryServices, InsertRetryPolicy retryPolicy, boolean extendedErrorInfo, boolean skipInvalidRows, boolean ignoreUnknownValues, boolean ignoreInsertIds, Coder<ElementT> elementCoder, SerializableFunction<ElementT, TableRow> toTableRow) {
        this.bigQueryServices = bigQueryServices;
        this.retryPolicy = retryPolicy;
        this.extendedErrorInfo = extendedErrorInfo;
        this.skipInvalidRows = skipInvalidRows;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.ignoreInsertIds = ignoreInsertIds;
        this.elementCoder = elementCoder;
        this.toTableRow = toTableRow;
    }

    StreamingWriteTables<ElementT> withTestServices(BigQueryServices bigQueryServices) {
        return new StreamingWriteTables<ElementT>(bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withInsertRetryPolicy(InsertRetryPolicy retryPolicy) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withExtendedErrorInfo(boolean extendedErrorInfo) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withSkipInvalidRows(boolean skipInvalidRows) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withIgnoreUnknownValues(boolean ignoreUnknownValues) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, ignoreUnknownValues, this.ignoreInsertIds, this.elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withIgnoreInsertIds(boolean ignoreInsertIds) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, ignoreInsertIds, this.elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withElementCoder(Coder<ElementT> elementCoder) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, elementCoder, this.toTableRow);
    }

    StreamingWriteTables<ElementT> withToTableRow(SerializableFunction<ElementT, TableRow> toTableRow) {
        return new StreamingWriteTables<ElementT>(this.bigQueryServices, this.retryPolicy, this.extendedErrorInfo, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.elementCoder, toTableRow);
    }

    public WriteResult expand(PCollection<KV<TableDestination, ElementT>> input) {
        if (this.extendedErrorInfo) {
            TupleTag failedInsertsTag = new TupleTag(FAILED_INSERTS_TAG_ID);
            PCollection<BigQueryInsertError> failedInserts = this.writeAndGetErrors(input, failedInsertsTag, BigQueryInsertErrorCoder.of(), ErrorContainer.BIG_QUERY_INSERT_ERROR_ERROR_CONTAINER);
            return WriteResult.withExtendedErrors(input.getPipeline(), (TupleTag<BigQueryInsertError>)failedInsertsTag, failedInserts);
        }
        TupleTag failedInsertsTag = new TupleTag(FAILED_INSERTS_TAG_ID);
        PCollection<TableRow> failedInserts = this.writeAndGetErrors(input, failedInsertsTag, TableRowJsonCoder.of(), ErrorContainer.TABLE_ROW_ERROR_CONTAINER);
        return WriteResult.in(input.getPipeline(), (TupleTag<TableRow>)failedInsertsTag, failedInserts);
    }

    private <T> PCollection<T> writeAndGetErrors(PCollection<KV<TableDestination, ElementT>> input, TupleTag<T> failedInsertsTag, AtomicCoder<T> coder, ErrorContainer<T> errorContainer) {
        BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
        int numShards = options.getNumStreamingKeys();
        PCollection tagged = ((PCollection)((PCollection)input.apply("ShardTableWrites", (PTransform)ParDo.of(new GenerateShardedTable(numShards)))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), this.elementCoder)).apply("TagWithUniqueIds", (PTransform)ParDo.of(new TagWithUniqueIds()))).setCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of(this.elementCoder)));
        TupleTag mainOutputTag = new TupleTag("mainOutput");
        PCollectionTuple tuple = (PCollectionTuple)((PCollection)((PCollection)tagged.apply((PTransform)Reshuffle.of())).apply("GlobalWindow", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("StreamingWrite", (PTransform)ParDo.of(new StreamingWriteFn<T, ElementT>(this.bigQueryServices, this.retryPolicy, failedInsertsTag, errorContainer, this.skipInvalidRows, this.ignoreUnknownValues, this.ignoreInsertIds, this.toTableRow)).withOutputTags(mainOutputTag, TupleTagList.of(failedInsertsTag)));
        PCollection failedInserts = tuple.get(failedInsertsTag);
        failedInserts.setCoder(coder);
        return failedInserts;
    }
}

