/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryUtils_ConversionOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StandardSQLTypeName;
import org.apache.beam.sdk.schemas.LogicalTypes;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.BaseEncoding;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class BigQueryUtils {
    private static final Map<Schema.TypeName, StandardSQLTypeName> BEAM_TO_BIGQUERY_TYPE_MAPPING = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT16, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT32, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT64, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.FLOAT, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DOUBLE, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DECIMAL, (Object)StandardSQLTypeName.NUMERIC).put((Object)Schema.TypeName.BOOLEAN, (Object)StandardSQLTypeName.BOOL).put((Object)Schema.TypeName.ARRAY, (Object)StandardSQLTypeName.ARRAY).put((Object)Schema.TypeName.ROW, (Object)StandardSQLTypeName.STRUCT).put((Object)Schema.TypeName.DATETIME, (Object)StandardSQLTypeName.TIMESTAMP).put((Object)Schema.TypeName.STRING, (Object)StandardSQLTypeName.STRING).put((Object)Schema.TypeName.BYTES, (Object)StandardSQLTypeName.BYTES).build();
    private static final Map<Schema.TypeName, Function<String, Object>> JSON_VALUE_PARSERS = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte::valueOf).put((Object)Schema.TypeName.INT16, Short::valueOf).put((Object)Schema.TypeName.INT32, Integer::valueOf).put((Object)Schema.TypeName.INT64, Long::valueOf).put((Object)Schema.TypeName.FLOAT, Float::valueOf).put((Object)Schema.TypeName.DOUBLE, Double::valueOf).put((Object)Schema.TypeName.DECIMAL, BigDecimal::new).put((Object)Schema.TypeName.BOOLEAN, Boolean::valueOf).put((Object)Schema.TypeName.STRING, str -> str).put((Object)Schema.TypeName.DATETIME, str -> new DateTime((long)(Double.parseDouble(str) * 1000.0), (Chronology)ISOChronology.getInstanceUTC())).put((Object)Schema.TypeName.BYTES, str -> BaseEncoding.base64().decode((CharSequence)str)).build();
    private static final Map<String, StandardSQLTypeName> BEAM_TO_BIGQUERY_LOGICAL_MAPPING = ImmutableMap.builder().put((Object)"SqlDateType", (Object)StandardSQLTypeName.DATE).put((Object)"SqlTimeType", (Object)StandardSQLTypeName.TIME).put((Object)"SqlTimeWithLocalTzType", (Object)StandardSQLTypeName.TIME).put((Object)"SqlTimestampWithLocalTzType", (Object)StandardSQLTypeName.DATETIME).put((Object)"SqlCharType", (Object)StandardSQLTypeName.STRING).build();
    private static final BigQueryIO.TypedRead.ToBeamRowFunction<TableRow> TABLE_ROW_TO_BEAM_ROW_FUNCTION = (BigQueryIO.TypedRead.ToBeamRowFunction & Serializable)beamSchema -> (SerializableFunction & Serializable)tr -> BigQueryUtils.toBeamRow(beamSchema, tr);
    private static final BigQueryIO.TypedRead.FromBeamRowFunction<TableRow> TABLE_ROW_FROM_BEAM_ROW_FUNCTION = (BigQueryIO.TypedRead.FromBeamRowFunction & Serializable)ignored -> BigQueryUtils::toTableRow;
    private static final SerializableFunction<Row, TableRow> ROW_TO_TABLE_ROW = new ToTableRow<Row>(SerializableFunctions.identity());
    private static final Set<String> SQL_DATE_TIME_TYPES = ImmutableSet.of((Object)"SqlDateType", (Object)"SqlTimeType", (Object)"SqlTimeWithLocalTzType", (Object)"SqlTimestampWithLocalTzType");
    private static final Set<String> SQL_STRING_TYPES = ImmutableSet.of((Object)"SqlCharType");

    private static StandardSQLTypeName toStandardSQLTypeName(Schema.FieldType fieldType) {
        StandardSQLTypeName foundType;
        if (fieldType.getTypeName().isLogicalType() && (foundType = BEAM_TO_BIGQUERY_LOGICAL_MAPPING.get(fieldType.getLogicalType().getIdentifier())) != null) {
            return foundType;
        }
        return BEAM_TO_BIGQUERY_TYPE_MAPPING.get(fieldType.getTypeName());
    }

    private static Schema.FieldType fromTableFieldSchemaType(String typeName, List<TableFieldSchema> nestedFields) {
        switch (typeName) {
            case "STRING": {
                return Schema.FieldType.STRING;
            }
            case "BYTES": {
                return Schema.FieldType.BYTES;
            }
            case "INT64": 
            case "INTEGER": {
                return Schema.FieldType.INT64;
            }
            case "FLOAT64": 
            case "FLOAT": {
                return Schema.FieldType.DOUBLE;
            }
            case "BOOL": 
            case "BOOLEAN": {
                return Schema.FieldType.BOOLEAN;
            }
            case "TIMESTAMP": {
                return Schema.FieldType.DATETIME;
            }
            case "TIME": {
                return Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Instant>("SqlTimeType", "", Schema.FieldType.DATETIME){});
            }
            case "DATE": {
                return Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Instant>("SqlDateType", "", Schema.FieldType.DATETIME){});
            }
            case "DATETIME": {
                return Schema.FieldType.logicalType((Schema.LogicalType)new LogicalTypes.PassThroughLogicalType<Instant>("SqlTimestampWithLocalTzType", "", Schema.FieldType.DATETIME){});
            }
            case "STRUCT": 
            case "RECORD": {
                Schema rowSchema = BigQueryUtils.fromTableFieldSchema(nestedFields);
                return Schema.FieldType.row((Schema)rowSchema);
            }
        }
        throw new UnsupportedOperationException("Converting BigQuery type " + typeName + " to Beam type is unsupported");
    }

    private static Schema fromTableFieldSchema(List<TableFieldSchema> tableFieldSchemas) {
        Schema.Builder schemaBuilder = Schema.builder();
        for (TableFieldSchema tableFieldSchema : tableFieldSchemas) {
            Schema.FieldType fieldType = BigQueryUtils.fromTableFieldSchemaType(tableFieldSchema.getType(), tableFieldSchema.getFields());
            Optional<Mode> fieldMode = Optional.ofNullable(tableFieldSchema.getMode()).map(Mode::valueOf);
            if (fieldMode.filter(m -> m == Mode.REPEATED).isPresent()) {
                fieldType = Schema.FieldType.array((Schema.FieldType)fieldType);
            }
            boolean nullable = !fieldMode.isPresent() || fieldMode.filter(m -> m == Mode.NULLABLE).isPresent();
            Schema.Field field = Schema.Field.of((String)tableFieldSchema.getName(), (Schema.FieldType)fieldType).withNullable(nullable);
            if (tableFieldSchema.getDescription() != null && !"".equals(tableFieldSchema.getDescription())) {
                field = field.withDescription(tableFieldSchema.getDescription());
            }
            schemaBuilder.addField(field);
        }
        return schemaBuilder.build();
    }

    private static List<TableFieldSchema> toTableFieldSchema(Schema schema) {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>(schema.getFieldCount());
        for (Schema.Field schemaField : schema.getFields()) {
            Schema.FieldType type = schemaField.getType();
            TableFieldSchema field = new TableFieldSchema().setName(schemaField.getName());
            if (schemaField.getDescription() != null && !"".equals(schemaField.getDescription())) {
                field.setDescription(schemaField.getDescription());
            }
            if (!schemaField.getType().getNullable().booleanValue()) {
                field.setMode(Mode.REQUIRED.toString());
            }
            if (Schema.TypeName.ARRAY == type.getTypeName()) {
                if ((type = type.getCollectionElementType()).getTypeName().isCollectionType() || type.getTypeName().isMapType()) {
                    throw new IllegalArgumentException("Array of collection is not supported in BigQuery.");
                }
                field.setMode(Mode.REPEATED.toString());
            }
            if (Schema.TypeName.ROW == type.getTypeName()) {
                Schema subType = type.getRowSchema();
                field.setFields(BigQueryUtils.toTableFieldSchema(subType));
            }
            if (Schema.TypeName.MAP == type.getTypeName()) {
                throw new IllegalArgumentException("Maps are not supported in BigQuery.");
            }
            field.setType(BigQueryUtils.toStandardSQLTypeName(type).toString());
            fields.add(field);
        }
        return fields;
    }

    public static TableSchema toTableSchema(Schema schema) {
        return new TableSchema().setFields(BigQueryUtils.toTableFieldSchema(schema));
    }

    public static Schema fromTableSchema(TableSchema tableSchema) {
        return BigQueryUtils.fromTableFieldSchema(tableSchema.getFields());
    }

    public static final BigQueryIO.TypedRead.ToBeamRowFunction<TableRow> tableRowToBeamRow() {
        return TABLE_ROW_TO_BEAM_ROW_FUNCTION;
    }

    public static final BigQueryIO.TypedRead.FromBeamRowFunction<TableRow> tableRowFromBeamRow() {
        return TABLE_ROW_FROM_BEAM_ROW_FUNCTION;
    }

    public static SerializableFunction<Row, TableRow> toTableRow() {
        return ROW_TO_TABLE_ROW;
    }

    public static <T> SerializableFunction<T, TableRow> toTableRow(SerializableFunction<T, Row> toRow) {
        return new ToTableRow<T>(toRow);
    }

    public static Row toBeamRow(GenericRecord record, Schema schema, ConversionOptions options) {
        List valuesInOrder = schema.getFields().stream().map(field -> BigQueryUtils.convertAvroFormat(field, record.get(field.getName()), options)).collect(Collectors.toList());
        return Row.withSchema((Schema)schema).addValues(valuesInOrder).build();
    }

    public static TableRow toTableRow(Row row) {
        TableRow output = new TableRow();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Object value = row.getValue(i);
            Schema.Field schemaField = row.getSchema().getField(i);
            output = output.set(schemaField.getName(), BigQueryUtils.fromBeamField(schemaField.getType(), value));
        }
        return output;
    }

    private static Object fromBeamField(Schema.FieldType fieldType, Object fieldValue) {
        if (fieldValue == null) {
            if (!fieldType.getNullable().booleanValue()) {
                throw new IllegalArgumentException("Field is not nullable.");
            }
            return null;
        }
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                Schema.FieldType elementType = fieldType.getCollectionElementType();
                List items = (List)fieldValue;
                ArrayList convertedItems = Lists.newArrayListWithCapacity((int)items.size());
                for (Object item : items) {
                    convertedItems.add(BigQueryUtils.fromBeamField(elementType, item));
                }
                return convertedItems;
            }
            case ROW: {
                return BigQueryUtils.toTableRow((Row)fieldValue);
            }
            case DATETIME: {
                DateTimeFormatter patternFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").toFormatter();
                return ((Instant)fieldValue).toDateTime().toString(patternFormat);
            }
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return fieldValue.toString();
            }
            case DECIMAL: {
                return fieldValue.toString();
            }
            case BYTES: {
                return BaseEncoding.base64().encode((byte[])fieldValue);
            }
        }
        return fieldValue;
    }

    public static Row toBeamRow(Schema rowSchema, TableRow jsonBqRow) {
        return (Row)rowSchema.getFields().stream().map(field -> BigQueryUtils.toBeamRowFieldValue(field, jsonBqRow.get((Object)field.getName()))).collect(Row.toRow((Schema)rowSchema));
    }

    private static Object toBeamRowFieldValue(Schema.Field field, Object bqValue) {
        if (bqValue == null) {
            if (field.getType().getNullable().booleanValue()) {
                return null;
            }
            throw new IllegalArgumentException("Received null value for non-nullable field " + field.getName());
        }
        return BigQueryUtils.toBeamValue(field.getType(), bqValue);
    }

    public static Row toBeamRow(Schema rowSchema, TableSchema bqSchema, TableRow jsonBqRow) {
        List bqFields = bqSchema.getFields();
        Map<String, Integer> bqFieldIndices = IntStream.range(0, bqFields.size()).boxed().collect(Collectors.toMap(i -> ((TableFieldSchema)bqFields.get((int)i)).getName(), i -> i));
        List rawJsonValues = rowSchema.getFields().stream().map(field -> (Integer)bqFieldIndices.get(field.getName())).map(index -> ((TableCell)jsonBqRow.getF().get((int)index)).getV()).collect(Collectors.toList());
        return (Row)IntStream.range(0, rowSchema.getFieldCount()).boxed().map(index -> BigQueryUtils.toBeamValue(rowSchema.getField(index.intValue()).getType(), rawJsonValues.get((int)index))).collect(Row.toRow((Schema)rowSchema));
    }

    private static Object toBeamValue(Schema.FieldType fieldType, Object jsonBQValue) {
        if (jsonBQValue instanceof String && JSON_VALUE_PARSERS.containsKey(fieldType.getTypeName())) {
            return JSON_VALUE_PARSERS.get(fieldType.getTypeName()).apply((String)jsonBQValue);
        }
        if (jsonBQValue instanceof List) {
            return ((List)jsonBQValue).stream().map(v -> ((Map)v).get("v")).map(v -> BigQueryUtils.toBeamValue(fieldType.getCollectionElementType(), v)).collect(Collectors.toList());
        }
        if (jsonBQValue instanceof Map) {
            TableRow tr = new TableRow();
            tr.putAll((Map)jsonBQValue);
            return BigQueryUtils.toBeamRow(fieldType.getRowSchema(), tr);
        }
        throw new UnsupportedOperationException("Converting BigQuery type '" + jsonBQValue.getClass() + "' to '" + fieldType + "' is not supported");
    }

    public static Object convertAvroFormat(Schema.Field beamField, Object avroValue, ConversionOptions options) {
        Schema.TypeName beamFieldTypeName = beamField.getType().getTypeName();
        switch (beamFieldTypeName) {
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case BYTE: {
                return BigQueryUtils.convertAvroPrimitiveTypes(beamFieldTypeName, avroValue);
            }
            case DATETIME: {
                switch (options.getTruncateTimestamps()) {
                    case TRUNCATE: {
                        return BigQueryUtils.truncateToMillis(avroValue);
                    }
                    case REJECT: {
                        return BigQueryUtils.safeToMillis(avroValue);
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown timestamp truncation option: %s", new Object[]{options.getTruncateTimestamps()}));
            }
            case STRING: {
                return BigQueryUtils.convertAvroPrimitiveTypes(beamFieldTypeName, avroValue);
            }
            case ARRAY: {
                return BigQueryUtils.convertAvroArray(beamField, avroValue);
            }
            case LOGICAL_TYPE: {
                String identifier = beamField.getType().getLogicalType().getIdentifier();
                if (SQL_DATE_TIME_TYPES.contains(identifier)) {
                    switch (options.getTruncateTimestamps()) {
                        case TRUNCATE: {
                            return BigQueryUtils.truncateToMillis(avroValue);
                        }
                        case REJECT: {
                            return BigQueryUtils.safeToMillis(avroValue);
                        }
                    }
                    throw new IllegalArgumentException(String.format("Unknown timestamp truncation option: %s", new Object[]{options.getTruncateTimestamps()}));
                }
                if (SQL_STRING_TYPES.contains(identifier)) {
                    return BigQueryUtils.convertAvroPrimitiveTypes(Schema.TypeName.STRING, avroValue);
                }
                throw new RuntimeException("Unknown logical type " + identifier);
            }
            case DECIMAL: {
                throw new RuntimeException("Does not support converting DECIMAL type value");
            }
            case MAP: {
                throw new RuntimeException("Does not support converting MAP type value");
            }
        }
        throw new RuntimeException("Does not support converting unknown type value: " + beamFieldTypeName);
    }

    private static ReadableInstant safeToMillis(Object value) {
        long subMilliPrecision = (Long)value % 1000L;
        if (subMilliPrecision != 0L) {
            throw new IllegalArgumentException(String.format("BigQuery data contained value %s with sub-millisecond precision, which Beam does not currently support. You can enable truncating timestamps to millisecond precision by using BigQueryIO.withTruncatedTimestamps", value));
        }
        return BigQueryUtils.truncateToMillis(value);
    }

    private static ReadableInstant truncateToMillis(Object value) {
        return new Instant((Long)value / 1000L);
    }

    private static Object convertAvroArray(Schema.Field beamField, Object value) {
        List values = (List)value;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object v : values) {
            ret.add(BigQueryUtils.convertAvroPrimitiveTypes(beamField.getType().getCollectionElementType().getTypeName(), v));
        }
        return ret;
    }

    private static Object convertAvroString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        if (value instanceof String) {
            return value;
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static Object convertAvroPrimitiveTypes(Schema.TypeName beamType, Object value) {
        switch (beamType) {
            case BYTE: {
                return ((Long)value).byteValue();
            }
            case INT16: {
                return ((Long)value).shortValue();
            }
            case INT32: {
                return ((Long)value).intValue();
            }
            case INT64: {
                return value;
            }
            case FLOAT: {
                return Float.valueOf(((Double)value).floatValue());
            }
            case DOUBLE: {
                return (Double)value;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case DECIMAL: {
                throw new RuntimeException("Does not support converting DECIMAL type value");
            }
            case STRING: {
                return BigQueryUtils.convertAvroString(value);
            }
        }
        throw new RuntimeException(beamType + " is not primitive type.");
    }

    private static class ToTableRow<T>
    implements SerializableFunction<T, TableRow> {
        private final SerializableFunction<T, Row> toRow;

        ToTableRow(SerializableFunction<T, Row> toRow) {
            this.toRow = toRow;
        }

        public TableRow apply(T input) {
            return BigQueryUtils.toTableRow((Row)this.toRow.apply(input));
        }
    }

    @AutoValue
    public static abstract class ConversionOptions
    implements Serializable {
        public abstract TruncateTimestamps getTruncateTimestamps();

        public static Builder builder() {
            return new AutoValue_BigQueryUtils_ConversionOptions.Builder().setTruncateTimestamps(TruncateTimestamps.REJECT);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setTruncateTimestamps(TruncateTimestamps var1);

            public abstract ConversionOptions build();
        }

        public static enum TruncateTimestamps {
            REJECT,
            TRUNCATE;

        }
    }
}

