/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteRename
extends DoFn<Iterable<KV<TableDestination, String>>, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteRename.class);
    private final BigQueryServices bqServices;
    private final PCollectionView<String> jobIdToken;
    private final BigQueryIO.Write.WriteDisposition firstPaneWriteDisposition;
    private final BigQueryIO.Write.CreateDisposition firstPaneCreateDisposition;
    private final int maxRetryJobs;
    private final String kmsKey;
    private List<PendingJobData> pendingJobs = Lists.newArrayList();

    public WriteRename(BigQueryServices bqServices, PCollectionView<String> jobIdToken, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, int maxRetryJobs, String kmsKey) {
        this.bqServices = bqServices;
        this.jobIdToken = jobIdToken;
        this.firstPaneWriteDisposition = writeDisposition;
        this.firstPaneCreateDisposition = createDisposition;
        this.maxRetryJobs = maxRetryJobs;
        this.kmsKey = kmsKey;
    }

    @DoFn.StartBundle
    public void startBundle(DoFn.StartBundleContext c) {
        this.pendingJobs.clear();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        ArrayListMultimap tempTables = ArrayListMultimap.create();
        for (KV kV : (Iterable)c.element()) {
            tempTables.put((Object)((TableDestination)kV.getKey()), (Object)((String)kV.getValue()));
        }
        for (Map.Entry entry : tempTables.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) continue;
            this.pendingJobs.add(this.startWriteRename((TableDestination)entry.getKey(), (Iterable)entry.getValue(), c));
        }
    }

    @DoFn.FinishBundle
    public void finishBundle(DoFn.FinishBundleContext c) throws Exception {
        BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class));
        BigQueryHelpers.PendingJobManager jobManager = new BigQueryHelpers.PendingJobManager();
        for (PendingJobData pendingJob : this.pendingJobs) {
            jobManager.addPendingJob(pendingJob.retryJob, (SerializableFunction<BigQueryHelpers.PendingJob, Exception>)(SerializableFunction & Serializable)j -> {
                try {
                    if (pendingJob.tableDestination.getTableDescription() != null) {
                        TableReference ref = pendingJob.tableDestination.getTableReference();
                        datasetService.patchTableDescription(ref.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(ref.getTableId())), pendingJob.tableDestination.getTableDescription());
                    }
                    WriteRename.removeTemporaryTables(datasetService, pendingJob.tempTables);
                    return null;
                }
                catch (IOException | InterruptedException e) {
                    return e;
                }
            });
        }
        jobManager.waitForDone();
    }

    private PendingJobData startWriteRename(TableDestination finalTableDestination, Iterable<String> tempTableNames, DoFn.ProcessContext c) throws Exception {
        BigQueryIO.Write.WriteDisposition writeDisposition = c.pane().getIndex() == 0L ? this.firstPaneWriteDisposition : BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
        BigQueryIO.Write.CreateDisposition createDisposition = c.pane().getIndex() == 0L ? this.firstPaneCreateDisposition : BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
        List<TableReference> tempTables = StreamSupport.stream(tempTableNames.spliterator(), false).map(table -> BigQueryHelpers.fromJsonString(table, TableReference.class)).collect(Collectors.toList());
        String jobIdPrefix = BigQueryHelpers.createJobId((String)c.sideInput(this.jobIdToken), finalTableDestination, -1, c.pane().getIndex());
        BigQueryHelpers.PendingJob retryJob = this.startCopy(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, finalTableDestination.getTableReference(), tempTables, writeDisposition, createDisposition, this.kmsKey);
        return new PendingJobData(retryJob, finalTableDestination, tempTables);
    }

    private BigQueryHelpers.PendingJob startCopy(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference ref, List<TableReference> tempTables, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey) {
        JobConfigurationTableCopy copyConfig = new JobConfigurationTableCopy().setSourceTables(tempTables).setDestinationTable(ref).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name());
        if (kmsKey != null) {
            copyConfig.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
        }
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, ref.getProjectId(), ref.getDatasetId());
        String projectId = ref.getProjectId();
        BigQueryHelpers.PendingJob retryJob = new BigQueryHelpers.PendingJob((SerializableFunction<BigQueryHelpers.RetryJobId, Void>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            LOG.info("Starting copy job for table {} using  {}, job id iteration {}", new Object[]{ref, jobRef, jobId.getRetryIndex()});
            try {
                jobService.startCopyJob(jobRef, copyConfig);
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Copy job {} failed with {}", (Object)jobRef, (Object)e);
                throw new RuntimeException(e);
            }
            return null;
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.pollJob(jobRef, Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.getJob(jobRef);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.maxRetryJobs, jobIdPrefix);
        return retryJob;
    }

    static void removeTemporaryTables(BigQueryServices.DatasetService tableService, List<TableReference> tempTables) {
        for (TableReference tableRef : tempTables) {
            try {
                LOG.debug("Deleting table {}", (Object)BigQueryHelpers.toJsonString(tableRef));
                tableService.deleteTable(tableRef);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete the table {}", (Object)BigQueryHelpers.toJsonString(tableRef), (Object)e);
            }
        }
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"firstPaneWriteDisposition", (String)this.firstPaneWriteDisposition.toString()).withLabel("Write Disposition")).add(DisplayData.item((String)"firstPaneCreateDisposition", (String)this.firstPaneCreateDisposition.toString()).withLabel("Create Disposition"));
    }

    private static class PendingJobData {
        final BigQueryHelpers.PendingJob retryJob;
        final TableDestination tableDestination;
        final List<TableReference> tempTables;

        public PendingJobData(BigQueryHelpers.PendingJob retryJob, TableDestination tableDestination, List<TableReference> tempTables) {
            this.retryJob = retryJob;
            this.tableDestination = tableDestination;
            this.tempTables = tempTables;
        }
    }
}

