/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;

class DynamicDestinationsHelpers {
    DynamicDestinationsHelpers() {
    }

    static class SchemaFromViewDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        PCollectionView<Map<String, String>> schemaView;

        SchemaFromViewDestinations(DynamicDestinations<T, TableDestination> inner, PCollectionView<Map<String, String>> schemaView) {
            super(inner);
            Preconditions.checkArgument((schemaView != null ? 1 : 0) != 0, (Object)"schemaView can not be null");
            this.schemaView = schemaView;
        }

        @Override
        public List<PCollectionView<?>> getSideInputs() {
            return ImmutableList.builder().add(this.schemaView).build();
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            Map<String, String> mapValue = this.sideInput(this.schemaView);
            String schema = mapValue.get(destination.getTableSpec());
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Schema view must contain data for every destination used, but view %s does not contain data for table destination %s produced by %s", this.schemaView, (Object)destination.getTableSpec(), (Object)this.inner);
            return BigQueryHelpers.fromJsonString(schema, TableSchema.class);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("schemaView", this.schemaView).toString();
        }
    }

    static class ConstantTimePartitioningDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        @Nullable
        private final ValueProvider<String> jsonTimePartitioning;

        ConstantTimePartitioningDestinations(DynamicDestinations<T, TableDestination> inner, ValueProvider<String> jsonTimePartitioning) {
            super(inner);
            Preconditions.checkArgument((jsonTimePartitioning != null ? 1 : 0) != 0, (Object)"jsonTimePartitioning provider can not be null");
            if (jsonTimePartitioning.isAccessible()) {
                Preconditions.checkArgument((jsonTimePartitioning.get() != null ? 1 : 0) != 0, (Object)"jsonTimePartitioning can not be null");
            }
            this.jsonTimePartitioning = jsonTimePartitioning;
        }

        @Override
        public TableDestination getDestination(ValueInSingleWindow<T> element) {
            TableDestination destination = (TableDestination)super.getDestination(element);
            String partitioning = (String)this.jsonTimePartitioning.get();
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"jsonTimePartitioning can not be null");
            return new TableDestination(destination.getTableSpec(), destination.getTableDescription(), partitioning);
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoderV2.of();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("jsonTimePartitioning", this.jsonTimePartitioning).toString();
        }
    }

    static class ConstantSchemaDestinations<T>
    extends DelegatingDynamicDestinations<T, TableDestination> {
        @Nullable
        private final ValueProvider<String> jsonSchema;

        ConstantSchemaDestinations(DynamicDestinations<T, TableDestination> inner, ValueProvider<String> jsonSchema) {
            super(inner);
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            this.jsonSchema = jsonSchema;
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            String jsonSchema = (String)this.jsonSchema.get();
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return BigQueryHelpers.fromJsonString(jsonSchema, TableSchema.class);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", (Object)this.inner).add("jsonSchema", this.jsonSchema).toString();
        }
    }

    static class DelegatingDynamicDestinations<T, DestinationT>
    extends DynamicDestinations<T, DestinationT> {
        final DynamicDestinations<T, DestinationT> inner;

        DelegatingDynamicDestinations(DynamicDestinations<T, DestinationT> inner) {
            this.inner = inner;
        }

        @Override
        public DestinationT getDestination(ValueInSingleWindow<T> element) {
            return this.inner.getDestination(element);
        }

        @Override
        public TableSchema getSchema(DestinationT destination) {
            return this.inner.getSchema(destination);
        }

        @Override
        public TableDestination getTable(DestinationT destination) {
            return this.inner.getTable(destination);
        }

        @Override
        public Coder<DestinationT> getDestinationCoder() {
            return this.inner.getDestinationCoder();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("inner", this.inner).toString();
        }
    }

    static class TableFunctionDestinations<T>
    extends DynamicDestinations<T, TableDestination> {
        private final SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction;

        TableFunctionDestinations(SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
            this.tableFunction = tableFunction;
        }

        @Override
        public TableDestination getDestination(ValueInSingleWindow<T> element) {
            TableDestination res = (TableDestination)this.tableFunction.apply(element);
            Preconditions.checkArgument((res != null ? 1 : 0) != 0, (String)"result of tableFunction can not be null, but %s returned null for element: %s", this.tableFunction, element);
            return res;
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            return null;
        }

        @Override
        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoderV2.of();
        }
    }

    static class ConstantTableDestinations<T>
    extends DynamicDestinations<T, TableDestination> {
        private final ValueProvider<String> tableSpec;
        @Nullable
        private final String tableDescription;

        ConstantTableDestinations(ValueProvider<String> tableSpec, @Nullable String tableDescription) {
            this.tableSpec = tableSpec;
            this.tableDescription = tableDescription;
        }

        static <T> ConstantTableDestinations<T> fromTableSpec(ValueProvider<String> tableSpec, String tableDescription) {
            return new ConstantTableDestinations<T>(tableSpec, tableDescription);
        }

        static <T> ConstantTableDestinations<T> fromJsonTableRef(ValueProvider<String> jsonTableRef, String tableDescription) {
            return new ConstantTableDestinations<T>((ValueProvider<String>)ValueProvider.NestedValueProvider.of(jsonTableRef, (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableSpec()), tableDescription);
        }

        @Override
        public TableDestination getDestination(ValueInSingleWindow<T> element) {
            String tableSpec = (String)this.tableSpec.get();
            Preconditions.checkArgument((tableSpec != null ? 1 : 0) != 0, (Object)"tableSpec can not be null");
            return new TableDestination(tableSpec, this.tableDescription);
        }

        @Override
        public TableSchema getSchema(TableDestination destination) {
            return null;
        }

        @Override
        public TableDestination getTable(TableDestination destination) {
            return destination;
        }

        @Override
        public Coder<TableDestination> getDestinationCoder() {
            return TableDestinationCoder.of();
        }
    }
}

