/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class BigQueryStorageTableSource<T>
extends BoundedSource<T> {
    private static final int MAX_SPLIT_COUNT = 10000;
    private static final int MIN_SPLIT_COUNT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryStorageTableSource.class);
    private final ValueProvider<TableReferenceProto.TableReference> tableRefProtoProvider;
    private final ReadOptions.TableReadOptions readOptions;
    private final SerializableFunction<SchemaAndRecord, T> parseFn;
    private final Coder<T> outputCoder;
    private final BigQueryServices bqServices;
    private final AtomicReference<Long> tableSizeBytes;

    public static <T> BigQueryStorageTableSource<T> create(ValueProvider<TableReference> tableRefProvider, @Nullable ReadOptions.TableReadOptions readOptions, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        return new BigQueryStorageTableSource<T>((ValueProvider<TableReferenceProto.TableReference>)ValueProvider.NestedValueProvider.of((ValueProvider)((ValueProvider)Preconditions.checkNotNull(tableRefProvider, (Object)"tableRefProvider")), (SerializableFunction)new BigQueryHelpers.TableRefToTableRefProto()), readOptions, parseFn, outputCoder, bqServices);
    }

    private BigQueryStorageTableSource(ValueProvider<TableReferenceProto.TableReference> tableRefProtoProvider, @Nullable ReadOptions.TableReadOptions readOptions, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        this.tableRefProtoProvider = (ValueProvider)Preconditions.checkNotNull(tableRefProtoProvider, (Object)"tableRefProtoProvider");
        this.readOptions = readOptions;
        this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        this.tableSizeBytes = new AtomicReference();
    }

    public Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTableRefProto(this.tableRefProtoProvider)).withLabel("Table"));
    }

    private TableReferenceProto.TableReference getTargetTable(BigQueryOptions bqOptions) throws IOException {
        TableReferenceProto.TableReference tableReferenceProto = (TableReferenceProto.TableReference)this.tableRefProtoProvider.get();
        return this.setDefaultProjectIfAbsent(bqOptions, tableReferenceProto);
    }

    private TableReferenceProto.TableReference setDefaultProjectIfAbsent(BigQueryOptions bqOptions, TableReferenceProto.TableReference tableReferenceProto) {
        if (Strings.isNullOrEmpty((String)tableReferenceProto.getProjectId())) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)bqOptions.getProject()) ? 1 : 0) != 0, (String)"No project ID set in %s or %s, cannot construct a complete %s", (Object)TableReferenceProto.TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName(), (Object)TableReferenceProto.TableReference.class.getSimpleName());
            LOG.info("Project ID not set in {}. Using default project from {}.", (Object)TableReferenceProto.TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
            tableReferenceProto = tableReferenceProto.toBuilder().setProjectId(bqOptions.getProject()).build();
        }
        return tableReferenceProto;
    }

    private List<String> getSelectedFields() {
        if (this.readOptions != null && !this.readOptions.getSelectedFieldsList().isEmpty()) {
            return this.readOptions.getSelectedFieldsList();
        }
        return null;
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        if (this.tableSizeBytes.get() == null) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReferenceProto.TableReference tableReferenceProto = this.setDefaultProjectIfAbsent(bqOptions, (TableReferenceProto.TableReference)this.tableRefProtoProvider.get());
            TableReference tableReference = BigQueryHelpers.toTableRef(tableReferenceProto);
            Table table = this.bqServices.getDatasetService(bqOptions).getTable(tableReference, this.getSelectedFields());
            this.tableSizeBytes.compareAndSet(null, table.getNumBytes());
        }
        return this.tableSizeBytes.get();
    }

    public List<BigQueryStorageStreamSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        Storage.ReadSession readSession;
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        TableReferenceProto.TableReference tableReferenceProto = this.setDefaultProjectIfAbsent(bqOptions, (TableReferenceProto.TableReference)this.tableRefProtoProvider.get());
        TableReference tableReference = BigQueryHelpers.toTableRef(tableReferenceProto);
        Table table = this.bqServices.getDatasetService(bqOptions).getTable(tableReference, this.getSelectedFields());
        long tableSizeBytes = table != null ? table.getNumBytes() : 0L;
        int streamCount = 0;
        if (desiredBundleSizeBytes > 0L) {
            streamCount = (int)Math.min(tableSizeBytes / desiredBundleSizeBytes, 10000L);
        }
        Storage.CreateReadSessionRequest.Builder requestBuilder = Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + bqOptions.getProject()).setTableReference(tableReferenceProto).setRequestedStreams(Math.max(streamCount, 10));
        if (this.readOptions != null) {
            requestBuilder.setReadOptions(this.readOptions);
        }
        BigQueryServices.StorageClient client = this.bqServices.getStorageClient(bqOptions);
        Object object = null;
        try {
            readSession = client.createReadSession(requestBuilder.build());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (object != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
        if (readSession.getStreamsList().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList sources = Lists.newArrayList();
        for (Storage.Stream stream : readSession.getStreamsList()) {
            sources.add(BigQueryStorageStreamSource.create(readSession, stream, table.getSchema(), this.parseFn, this.outputCoder, this.bqServices));
        }
        return ImmutableList.copyOf((Collection)sources);
    }

    public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
        throw new UnsupportedOperationException("BigQuery table source must be split before reading");
    }
}

