/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerReadFn;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteGroupFn;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SpannerIO {
    private static final long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setKeySet(KeySet.all()).build();
    }

    @Experimental
    public static CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    @Experimental
    public static Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).build();
    }

    private SpannerIO() {
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, PDone> {
        private final Write spec;

        public WriteGrouped(Write spec) {
            this.spec = spec;
        }

        public PDone expand(PCollection<MutationGroup> input) {
            input.apply("Write mutations to Cloud Spanner", (PTransform)ParDo.of((DoFn)new SpannerWriteGroupFn(this.spec)));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, PDone> {
        abstract SpannerConfig getSpannerConfig();

        abstract long getBatchSizeBytes();

        abstract Builder toBuilder();

        public Write withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Write withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Write withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Write withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Write withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Write withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Write withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        Write withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public Write withBatchSizeBytes(long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public void validate(PipelineOptions options) {
            this.getSpannerConfig().validate(options);
        }

        public PDone expand(PCollection<Mutation> input) {
            ((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)ParDo.of((DoFn)new SpannerWriteGroupFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Batch Size in Bytes"));
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setBatchSizeBytes(long var1);

            abstract Write build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class CreateTransaction
    extends PTransform<PBegin, PCollectionView<Transaction>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public PCollectionView<Transaction> expand(PBegin input) {
            return (PCollectionView)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this)))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public CreateTransaction withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public CreateTransaction withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public CreateTransaction withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public CreateTransaction withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public CreateTransaction withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public CreateTransaction withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public CreateTransaction withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        CreateTransaction withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public CreateTransaction withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public void validate(PipelineOptions options) {
            this.getSpannerConfig().validate(options);
        }

        public static abstract class Builder {
            public abstract Builder setSpannerConfig(SpannerConfig var1);

            public abstract Builder setTimestampBound(TimestampBound var1);

            public abstract CreateTransaction build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract TimestampBound getTimestampBound();

        @Nullable
        abstract Statement getQuery();

        @Nullable
        abstract String getTable();

        @Nullable
        abstract String getIndex();

        @Nullable
        abstract List<String> getColumns();

        @Nullable
        abstract KeySet getKeySet();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        abstract Builder toBuilder();

        public Read withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Read withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Read withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Read withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Read withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Read withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Read withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        Read withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public Read withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public Read withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public Read withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public Read withTable(String table) {
            return this.toBuilder().setTable(table).build();
        }

        public Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public Read withColumns(List<String> columns) {
            return this.toBuilder().setColumns(columns).build();
        }

        public Read withQuery(Statement statement) {
            return this.toBuilder().setQuery(statement).build();
        }

        public Read withQuery(String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public Read withKeySet(KeySet keySet) {
            return this.toBuilder().setKeySet(keySet).build();
        }

        public Read withIndex(String index) {
            return this.toBuilder().setIndex(index).build();
        }

        public void validate(PipelineOptions options) {
            this.getSpannerConfig().validate(options);
            Preconditions.checkNotNull((Object)this.getTimestampBound(), (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getQuery() == null) {
                if (this.getTable() != null) {
                    Preconditions.checkNotNull(this.getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
        }

        public PCollection<Struct> expand(PBegin input) {
            Read config = this;
            List<Object> sideInputs = Collections.emptyList();
            if (this.getTimestampBound() != null) {
                PCollectionView transaction = (PCollectionView)input.apply((PTransform)SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()));
                config = config.withTransaction((PCollectionView<Transaction>)transaction);
                sideInputs = Collections.singletonList(transaction);
            }
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Execute query", (PTransform)ParDo.of((DoFn)new NaiveSpannerReadFn(config)).withSideInputs(sideInputs));
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setQuery(Statement var1);

            abstract Builder setTable(String var1);

            abstract Builder setIndex(String var1);

            abstract Builder setColumns(List<String> var1);

            abstract Builder setKeySet(KeySet var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Read build();
        }
    }
}

