/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Value;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;

class MutationSizeEstimator {
    private MutationSizeEstimator() {
    }

    static long sizeOf(Mutation m) {
        long result = 0L;
        block4: for (Value v : m.getValues()) {
            switch (v.getType().getCode()) {
                case ARRAY: {
                    result += MutationSizeEstimator.estimateArrayValue(v);
                    continue block4;
                }
                case STRUCT: {
                    throw new IllegalArgumentException("Structs are not supported in mutation.");
                }
            }
            result += MutationSizeEstimator.estimatePrimitiveValue(v);
        }
        return result;
    }

    public static long sizeOf(MutationGroup group) {
        long result = 0L;
        for (Mutation m : group) {
            result += MutationSizeEstimator.sizeOf(m);
        }
        return result;
    }

    private static long estimatePrimitiveValue(Value v) {
        switch (v.getType().getCode()) {
            case BOOL: {
                return 1L;
            }
            case INT64: 
            case FLOAT64: {
                return 8L;
            }
            case DATE: 
            case TIMESTAMP: {
                return 12L;
            }
            case STRING: {
                return v.isNull() ? 0L : (long)v.getString().length();
            }
            case BYTES: {
                return v.isNull() ? 0L : (long)v.getBytes().length();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + v.getType());
    }

    private static long estimateArrayValue(Value v) {
        switch (v.getType().getArrayElementType().getCode()) {
            case BOOL: {
                return v.getBoolArray().size();
            }
            case INT64: {
                return 8 * v.getInt64Array().size();
            }
            case FLOAT64: {
                return 8 * v.getFloat64Array().size();
            }
            case STRING: {
                long totalLength = 0L;
                for (String s : v.getStringArray()) {
                    if (s == null) continue;
                    totalLength += (long)s.length();
                }
                return totalLength;
            }
            case BYTES: {
                long totalLength = 0L;
                for (ByteArray bytes : v.getBytesArray()) {
                    if (bytes == null) continue;
                    totalLength += (long)bytes.length();
                }
                return totalLength;
            }
            case DATE: {
                return 12 * v.getDateArray().size();
            }
            case TIMESTAMP: {
                return 12 * v.getTimestampArray().size();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + v.getType());
    }
}

