/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.Instant;

@VisibleForTesting
class TransformingSource<T, V>
extends BoundedSource<V> {
    private final BoundedSource<T> boundedSource;
    private final SerializableFunction<T, V> function;
    private final Coder<V> outputCoder;

    TransformingSource(BoundedSource<T> boundedSource, SerializableFunction<T, V> function, Coder<V> outputCoder) {
        this.boundedSource = (BoundedSource)Preconditions.checkNotNull(boundedSource, (Object)"boundedSource");
        this.function = (SerializableFunction)Preconditions.checkNotNull(function, (Object)"function");
        this.outputCoder = (Coder)Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
    }

    public List<? extends BoundedSource<V>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        return Lists.transform((List)this.boundedSource.split(desiredBundleSizeBytes, options), (Function)new Function<BoundedSource<T>, BoundedSource<V>>(){

            public BoundedSource<V> apply(BoundedSource<T> input) {
                return new TransformingSource(input, TransformingSource.this.function, TransformingSource.this.outputCoder);
            }
        });
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return this.boundedSource.getEstimatedSizeBytes(options);
    }

    public BoundedSource.BoundedReader<V> createReader(PipelineOptions options) throws IOException {
        return new TransformingReader(this.boundedSource.createReader(options));
    }

    public void validate() {
        this.boundedSource.validate();
    }

    public Coder<V> getDefaultOutputCoder() {
        return this.outputCoder;
    }

    private class TransformingReader
    extends BoundedSource.BoundedReader<V> {
        private final BoundedSource.BoundedReader<T> boundedReader;

        private TransformingReader(BoundedSource.BoundedReader<T> boundedReader) {
            this.boundedReader = (BoundedSource.BoundedReader)Preconditions.checkNotNull(boundedReader, (Object)"boundedReader");
        }

        public synchronized BoundedSource<V> getCurrentSource() {
            return new TransformingSource(this.boundedReader.getCurrentSource(), TransformingSource.this.function, TransformingSource.this.outputCoder);
        }

        public boolean start() throws IOException {
            return this.boundedReader.start();
        }

        public boolean advance() throws IOException {
            return this.boundedReader.advance();
        }

        public V getCurrent() throws NoSuchElementException {
            Object current = this.boundedReader.getCurrent();
            return TransformingSource.this.function.apply(current);
        }

        public void close() throws IOException {
            this.boundedReader.close();
        }

        public synchronized BoundedSource<V> splitAtFraction(double fraction) {
            BoundedSource split = this.boundedReader.splitAtFraction(fraction);
            return split == null ? null : new TransformingSource(split, TransformingSource.this.function, TransformingSource.this.outputCoder);
        }

        public Double getFractionConsumed() {
            return this.boundedReader.getFractionConsumed();
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.boundedReader.getCurrentTimestamp();
        }
    }
}

